/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.Info;
import VASSAL.build.AbstractBuildable;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.GameModule;
import VASSAL.build.GpIdChecker;
import VASSAL.build.GpIdSupport;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.ExtensionElement;
import VASSAL.build.module.ExtensionsLoader;
import VASSAL.build.module.ExtensionsManager;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.PluginsLoader;
import VASSAL.build.module.PrototypeDefinition;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.metadata.ExtensionMetaData;
import VASSAL.build.widget.PieceSlot;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.DataArchive;
import VASSAL.tools.version.VersionUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ModuleExtension
extends AbstractBuildable
implements GameComponent,
PluginsLoader.PluginElement,
GpIdSupport {
    private static final Logger logger = LoggerFactory.getLogger(ModuleExtension.class);
    public static final String BASE_MODULE_NAME = "module";
    public static final String BASE_MODULE_VERSION = "moduleVersion";
    public static final String VERSION = "version";
    public static final String VASSAL_VERSION_CREATED = "vassalVersion";
    public static final String UNIVERSAL = "anyModule";
    public static final String NEXT_PIECESLOT_ID = "nextPieceSlotId";
    public static final String EXTENSION_ID = "extensionId";
    public static final String DESCRIPTION = "description";
    private DataArchive archive;
    private String version = "0.0";
    protected boolean universal = false;
    private String lastSave;
    private String vassalVersionCreated;
    private AbstractAction editAction;
    protected int nextGpId = 0;
    protected String extensionId = "";
    protected JTextField idDisplay;
    protected String description = "";

    public ModuleExtension(DataArchive archive) {
        this.archive = archive;
    }

    public String getVersion() {
        return this.version;
    }

    public DataArchive getDataArchive() {
        return this.archive;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getUniversal() {
        return this.universal;
    }

    public void build() {
        String fileName = "buildFile";
        GameModule.getGameModule().getDataArchive().addExtension(this.archive);
        GameModule.getGameModule().setGpIdSupport(this);
        try (BufferedInputStream in = new BufferedInputStream(this.archive.getInputStream("buildFile"));){
            try {
                Document doc = Builder.createDocument(in);
                if (doc != null) {
                    this.build(doc.getDocumentElement());
                }
            }
            catch (IOException e) {
                logger.error("Error while creating document from file {}", (Object)"buildFile", (Object)e);
                throw new ExtensionsLoader.LoadExtensionException(e);
            }
        }
        catch (FileNotFoundException e) {
            logger.error("File {} not found in archive", (Object)"buildFile", (Object)e);
        }
        catch (IOException e) {
            logger.error("Error while reading file {} from archive", (Object)"buildFile", (Object)e);
        }
        GameModule.getGameModule().add(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        if (this.archive instanceof ArchiveWriter) {
            this.lastSave = this.buildString();
            if (this.extensionId.length() == 0) {
                String id = UUID.randomUUID().toString();
                this.extensionId = id.substring(id.length() - 3);
            }
            GpIdChecker checker = new GpIdChecker(this);
            for (Buildable b : this.getBuildables()) {
                this.checkGpIds(b, checker);
            }
            checker.fixErrors();
        }
    }

    protected void checkGpIds(Buildable b, GpIdChecker checker) {
        if (b instanceof PieceSlot) {
            checker.add((PieceSlot)b);
        } else if (b instanceof PrototypeDefinition) {
            checker.add((PrototypeDefinition)b);
        } else if (b instanceof ExtensionElement) {
            this.checkGpIds(((ExtensionElement)b).getExtension(), checker);
        } else if (b instanceof AbstractBuildable) {
            for (Buildable buildable : ((AbstractBuildable)b).getBuildables()) {
                this.checkGpIds(buildable, checker);
            }
        }
    }

    protected void updateGpIds() {
        for (Buildable b : this.getBuildables()) {
            this.updateGpIds(b);
        }
    }

    protected void updateGpIds(Buildable b) {
        if (b instanceof PieceSlot) {
            ((PieceSlot)b).updateGpId();
        } else if (b instanceof ExtensionElement) {
            this.updateGpIds(((ExtensionElement)b).getExtension());
        } else if (b instanceof AbstractBuildable) {
            for (Buildable buildable : ((AbstractBuildable)b).getBuildables()) {
                this.updateGpIds(buildable);
            }
        }
    }

    @Override
    public int getNextGpId() {
        return this.nextGpId;
    }

    @Override
    public void setNextGpId(int id) {
        this.nextGpId = id;
    }

    @Override
    public Command getRestoreCommand() {
        return new RegCmd(this.getName(), this.version);
    }

    @Override
    public void setup(boolean gameStarting) {
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{UNIVERSAL, VERSION, DESCRIPTION, BASE_MODULE_NAME, BASE_MODULE_VERSION, VASSAL_VERSION_CREATED, NEXT_PIECESLOT_ID, EXTENSION_ID};
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public HelpFile getHelpFile() {
        return null;
    }

    public void removeFrom(Buildable parent) {
        throw new IllegalBuildException(Resources.getString("ModuleExtension.cannot_remove"));
    }

    public boolean confirmExit() {
        boolean confirm = true;
        if (this.archive instanceof ArchiveWriter && !this.buildString().equals(this.lastSave)) {
            switch (JOptionPane.showConfirmDialog(GameModule.getGameModule().getPlayerWindow(), Resources.getString("ModuleExtension.save_extension"), "", 1)) {
                case 0: {
                    try {
                        this.save();
                    }
                    catch (IOException e) {
                        confirm = false;
                    }
                    break;
                }
                case 2: {
                    confirm = false;
                }
            }
        }
        return confirm;
    }

    @Override
    public String getAttributeValueString(String key) {
        String s = null;
        if (BASE_MODULE_NAME.equals(key)) {
            s = GameModule.getGameModule().getGameName();
        } else if (BASE_MODULE_VERSION.equals(key)) {
            s = GameModule.getGameModule().getGameVersion();
        } else if (VERSION.equals(key)) {
            s = this.version;
        } else if (VASSAL_VERSION_CREATED.equals(key)) {
            s = this.vassalVersionCreated;
        } else if (UNIVERSAL.equals(key)) {
            s = String.valueOf(this.universal);
        } else if (NEXT_PIECESLOT_ID.equals(key)) {
            s = String.valueOf(this.nextGpId);
        } else if (EXTENSION_ID.equals(key)) {
            s = this.extensionId;
        } else if (DESCRIPTION.equals(key)) {
            s = this.description;
        }
        return s;
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (BASE_MODULE_NAME.equals(key)) {
            if (!this.universal && !GameModule.getGameModule().getGameName().equals(value)) {
                throw new ExtensionsLoader.LoadExtensionException(Resources.getString("ModuleExtension.extension_built", this.getName(), value));
            }
        } else if (BASE_MODULE_VERSION.equals(key)) {
            String version = (String)value;
            if (!this.universal && VersionUtils.compareVersions(GameModule.getGameModule().getGameVersion(), version) < 0) {
                GameModule.getGameModule().warn(Resources.getString("ModuleExtension.wrong_module_version", this.getName(), version, GameModule.getGameModule().getGameVersion(), GameModule.getGameModule().getGameName()));
            }
        } else if (VASSAL_VERSION_CREATED.equals(key)) {
            this.vassalVersionCreated = (String)value;
            String runningVersion = Info.getVersion();
            if (VersionUtils.compareVersions(this.vassalVersionCreated, runningVersion) > 0) {
                GameModule.getGameModule().warn(Resources.getString("ModuleExtension.wrong_vassal_version", this.getName(), value, runningVersion));
            }
        } else if (VERSION.equals(key)) {
            this.version = (String)value;
        } else if (UNIVERSAL.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.universal = (Boolean)value;
        } else if (NEXT_PIECESLOT_ID.equals(key)) {
            try {
                this.nextGpId = Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (EXTENSION_ID.equals(key)) {
            this.extensionId = (String)value;
        } else if (DESCRIPTION.equals(key)) {
            this.description = (String)value;
        }
    }

    public String getExtensionId() {
        return this.extensionId;
    }

    @Override
    public String generateGpId() {
        return this.extensionId + ":" + this.nextGpId++;
    }

    @Override
    public void addTo(Buildable parent) {
    }

    public String getName() {
        String name = "Extension";
        if (this.archive != null) {
            name = this.archive.getName();
            int index = name.lastIndexOf(File.separatorChar);
            if (index < name.length()) {
                name = name.substring(index + 1);
            }
            if ((index = name.lastIndexOf(46)) > 0) {
                name = name.substring(0, index);
            }
        }
        return name;
    }

    public String buildString() {
        Document doc = Builder.createNewDocument();
        doc.appendChild(this.getBuildElement(doc));
        return Builder.toString(doc);
    }

    protected void write(boolean saveAs) throws IOException {
        String save;
        this.vassalVersionCreated = Info.getVersion();
        if (this.archive instanceof ArchiveWriter) {
            ArchiveWriter w = (ArchiveWriter)this.archive;
            try {
                new ExtensionMetaData(this).save(w);
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
            save = this.buildString();
            w.addFile("buildFile", new ByteArrayInputStream(save.getBytes(StandardCharsets.UTF_8)));
            if (saveAs) {
                w.saveAs(true);
            } else {
                w.save(true);
            }
        } else {
            throw new IOException("Read-only extension");
        }
        this.lastSave = save;
    }

    public void save() throws IOException {
        this.write(false);
    }

    public void saveAs() throws IOException {
        this.write(true);
    }

    public void remove(ExtensionElement el) {
        this.buildComponents.remove(el);
    }

    public Action getEditAction(final JDialog d) {
        if (this.editAction == null) {
            d.setName(this.getName());
            final StringConfigurer config = new StringConfigurer(VERSION, "Version:  ", this.version);
            d.setLayout(new BoxLayout(d.getContentPane(), 1));
            d.add(config.getControls());
            final StringConfigurer dconfig = new StringConfigurer(DESCRIPTION, "Description:  ", this.description);
            d.add(dconfig.getControls());
            Box idBox = Box.createHorizontalBox();
            idBox.add(new JLabel("Extension Id: "));
            this.idDisplay = new JTextField(12);
            this.idDisplay.setText(this.extensionId);
            this.idDisplay.setEditable(false);
            idBox.add(this.idDisplay);
            JButton change = new JButton("Change");
            change.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = (String)JOptionPane.showInputDialog(GameModule.getGameModule().getPlayerWindow(), "Are you sure you wish to change the Extension Id?\n\nThe Extension Id links counters in existing save\ngames to the counter definitions in this Extension.\n\nIf you change the Id, then the Saved Game Updater\nmay not be able to update the counters from existing\nSaved Games.\n\nNew Extension Id:", "", 2, null, null, ModuleExtension.this.getExtensionId());
                    if (s != null && !s.equals(ModuleExtension.this.getExtensionId())) {
                        ModuleExtension.this.extensionId = s;
                        ModuleExtension.this.updateGpIds();
                        ModuleExtension.this.idDisplay.setText(ModuleExtension.this.getExtensionId());
                    }
                }
            });
            idBox.add(change);
            d.add(idBox);
            final BooleanConfigurer uconfig = new BooleanConfigurer(UNIVERSAL, "Allow loading with any module?", this.universal);
            d.add(uconfig.getControls());
            Box b = Box.createHorizontalBox();
            JButton ok = new JButton("Save");
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ModuleExtension.this.setAttribute(ModuleExtension.VERSION, config.getValue());
                    ModuleExtension.this.setAttribute(ModuleExtension.DESCRIPTION, dconfig.getValue());
                    ModuleExtension.this.setAttribute(ModuleExtension.UNIVERSAL, uconfig.getValue());
                    d.dispose();
                }
            });
            b.add(ok);
            JButton cancel = new JButton("Cancel");
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    d.dispose();
                }
            });
            b.add(cancel);
            d.add(b);
            d.pack();
            d.setLocationRelativeTo(d.getParent());
            this.editAction = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    d.setVisible(true);
                }
            };
            URL iconURL = this.getClass().getResource("/images/Edit16.gif");
            if (iconURL != null) {
                this.editAction.putValue("SmallIcon", new ImageIcon(iconURL));
            } else {
                this.editAction.putValue("Name", "Edit");
            }
            this.editAction.putValue("ShortDescription", "Extension Properties");
        }
        return this.editAction;
    }

    public static class RegCmd
    extends Command {
        private String name;
        private String version;

        public RegCmd(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        @Override
        protected void executeCommand() {
            boolean containsExtension = false;
            for (ModuleExtension ext : GameModule.getGameModule().getComponentsOf(ModuleExtension.class)) {
                if (!ext.getName().equals(this.name)) continue;
                containsExtension = true;
                if (VersionUtils.compareVersions(ext.getVersion(), this.version) <= 0) break;
                GameModule.getGameModule().warn(this.getVersionErrorMsg(ext.getVersion()));
                break;
            }
            if (!containsExtension) {
                GameModule.getGameModule().warn(this.getNotLoadedMsg());
            }
        }

        protected String getVersionErrorMsg(String v) {
            return Resources.getString("ModuleExtension.wrong_extension_version", this.version, this.name, v);
        }

        protected String getNotLoadedMsg() {
            return Resources.getString("ModuleExtension.load_extension", this.name, new ExtensionsManager(GameModule.getGameModule()).getExtensionsDirectory(false));
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }
}

