/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ToolBarComponent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class ToolbarMenu
extends AbstractConfigurable
implements ContainerListener,
PropertyChangeListener,
GameComponent {
    public static final String BUTTON_TEXT = "text";
    public static final String BUTTON_ICON = "icon";
    public static final String BUTTON_HOTKEY = "hotkey";
    public static final String TOOLTIP = "tooltip";
    public static final String MENU_ITEMS = "menuItems";
    public static final String DESCRIPTION = "description";
    public static final String MENU_PROPERTY = "ToolbarMenu.popup";
    public static final String HIDDEN_BY_TOOLBAR = "hidden";
    protected List<String> menuItems = new ArrayList<String>();
    protected Map<AbstractButton, JMenuItem> buttonsToMenuMap = new HashMap<AbstractButton, JMenuItem>();
    protected LaunchButton launch = new LaunchButton(Resources.getString("General.menu"), "tooltip", "text", "hotkey", "icon", new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolbarMenu.this.launch();
        }
    });
    protected JToolBar toolbar;
    protected JPopupMenu menu = new JPopupMenu();
    protected Runnable menuBuilder;

    public ToolbarMenu() {
        this.launch.putClientProperty(MENU_PROPERTY, this.menu);
        this.launch.setToolTipText("Display Menu Options");
        GameModule.getGameModule().getGameState().addGameComponent(this);
    }

    public void launch() {
        this.menu.show(this.launch, 0, 0);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.description_label"), Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.hotkey_label"), Resources.getString("Editor.ToolbarMenu.menu_entries")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, String.class, Icon.class, NamedKeyStroke.class, String[].class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{DESCRIPTION, BUTTON_TEXT, TOOLTIP, BUTTON_ICON, BUTTON_HOTKEY, MENU_ITEMS};
    }

    @Override
    public String getAttributeValueString(String key) {
        if (MENU_ITEMS.equals(key)) {
            return StringArrayConfigurer.arrayToString(this.menuItems.toArray(new String[0]));
        }
        if (DESCRIPTION.equals(key)) {
            return this.getConfigureName();
        }
        return this.launch.getAttributeValueString(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (MENU_ITEMS.equals(key)) {
            if (value instanceof String) {
                value = StringArrayConfigurer.stringToArray((String)value);
            }
            this.menuItems = new ArrayList<String>(Arrays.asList(value));
            if (this.toolbar != null) {
                this.scheduleBuildMenu();
            }
        } else if (BUTTON_TEXT.equals(key)) {
            this.launch.setAttribute(key, value);
        } else if (DESCRIPTION.equals(key)) {
            this.setConfigureName((String)value);
        } else {
            this.launch.setAttribute(key, value);
        }
    }

    @Override
    public void addTo(Buildable parent) {
        if (parent instanceof ToolBarComponent) {
            this.toolbar = ((ToolBarComponent)((Object)parent)).getToolBar();
        }
        this.toolbar.add(this.launch);
        this.toolbar.addContainerListener(this);
        this.scheduleBuildMenu();
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ToolbarMenu.htm");
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.ToolbarMenu.component_type");
    }

    @Override
    public void removeFrom(Buildable parent) {
        this.toolbar.remove(this.launch);
        this.toolbar.removeContainerListener(this);
    }

    protected void buildMenu() {
        JButton b;
        for (AbstractButton b2 : this.buttonsToMenuMap.keySet()) {
            b2.removePropertyChangeListener(this);
            b2.setVisible(true);
            b2.putClientProperty(HIDDEN_BY_TOOLBAR, null);
        }
        this.buttonsToMenuMap.clear();
        this.menu.removeAll();
        HashMap<String, JButton> nameToButton = new HashMap<String, JButton>();
        if (this.toolbar != null) {
            int n = this.toolbar.getComponentCount();
            for (int i = 0; i < n; ++i) {
                if (!(this.toolbar.getComponentAtIndex(i) instanceof JButton)) continue;
                b = (JButton)this.toolbar.getComponentAtIndex(i);
                String text = (String)b.getClientProperty("unTranslatedText");
                if (text == null) {
                    text = b.getText();
                }
                nameToButton.put(text, b);
            }
        }
        for (String item : this.menuItems) {
            b = (JButton)nameToButton.get(item);
            if (b == null) continue;
            Object property = b.getClientProperty(MENU_PROPERTY);
            b.addPropertyChangeListener(this);
            b.setVisible(false);
            b.putClientProperty(HIDDEN_BY_TOOLBAR, Boolean.TRUE);
            if (property instanceof JPopupMenu) {
                Component[] items;
                JPopupMenu toolbarMenu = (JPopupMenu)property;
                toolbarMenu.addContainerListener(this);
                JMenu subMenu = new JMenu(b.getText());
                for (Component component : items = toolbarMenu.getComponents()) {
                    final JMenuItem otherItem = (JMenuItem)component;
                    JMenuItem myItem = new JMenuItem(otherItem.getText(), otherItem.getIcon());
                    myItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            otherItem.doClick();
                        }
                    });
                    subMenu.add(myItem);
                    this.buttonsToMenuMap.put(otherItem, myItem);
                }
                this.buttonsToMenuMap.put(b, subMenu);
                this.menu.add(subMenu);
                continue;
            }
            JMenuItem mi = new JMenuItem(b.getText(), b.getIcon());
            mi.setEnabled(b.isEnabled());
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    b.doClick();
                }
            });
            this.buttonsToMenuMap.put(b, mi);
            this.menu.add(mi);
        }
    }

    protected void scheduleBuildMenu() {
        if (this.menuBuilder == null) {
            this.menuBuilder = new Runnable(){

                @Override
                public void run() {
                    ToolbarMenu.this.buildMenu();
                    ToolbarMenu.this.menuBuilder = null;
                }
            };
            SwingUtilities.invokeLater(this.menuBuilder);
        }
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        this.scheduleBuildMenu();
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        this.scheduleBuildMenu();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JButton b = (JButton)evt.getSource();
        JMenuItem mi = this.buttonsToMenuMap.get(b);
        if (mi != null) {
            if (BUTTON_TEXT.equals(evt.getPropertyName())) {
                this.scheduleBuildMenu();
            } else if ("enabled".equals(evt.getPropertyName())) {
                mi.setEnabled(b.isEnabled());
            } else if (BUTTON_ICON.equals(evt.getPropertyName())) {
                mi.setIcon(b.getIcon());
            }
        }
    }

    @Override
    public void setup(boolean gameStarting) {
        this.scheduleBuildMenu();
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }
}

