/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.GamePieceLayout;
import VASSAL.build.module.gamepieceimage.ImageItemInstance;
import VASSAL.build.module.gamepieceimage.Item;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.Op;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class ImageItem
extends Item {
    public static final String TYPE = "Image";
    public static final String SRC_VARIABLE = "Specified in individual images";
    public static final String SRC_FIXED = "Fixed for this layout";
    protected static final String IMAGE = "image";
    public static final String SOURCE = "source";
    protected String imageSource = "Fixed for this layout";
    protected String imageName = "";
    @Deprecated(since="2020-08-06", forRemoval=true)
    protected Image image = null;
    protected ImageOp srcOp;
    protected Rectangle imageBounds = new Rectangle();
    private final VisibilityCondition falseCond = () -> false;
    private final VisibilityCondition fixedCond = () -> this.imageSource.equals(SRC_FIXED);

    public ImageItem() {
    }

    public ImageItem(GamePieceLayout l) {
        super(l);
    }

    public ImageItem(GamePieceLayout l, String n) {
        this(l);
        this.setConfigureName(n);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return (String[])ArrayUtils.insert((int)2, (Object[])super.getAttributeDescriptions(), (Object[])new String[]{"Image:  ", "Image is:  "});
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return (Class[])ArrayUtils.insert((int)2, (Object[])super.getAttributeTypes(), (Object[])new Class[]{Image.class, TextSource.class});
    }

    @Override
    public String[] getAttributeNames() {
        return (String[])ArrayUtils.insert((int)2, (Object[])super.getAttributeNames(), (Object[])new String[]{IMAGE, SOURCE});
    }

    @Override
    public void setAttribute(String key, Object o) {
        if (IMAGE.equals(key)) {
            this.imageName = o instanceof String ? (String)o : (o == null ? null : ((File)o).getName());
        } else if (SOURCE.equals(key)) {
            this.imageSource = (String)o;
        } else {
            super.setAttribute(key, o);
        }
        if (this.layout != null) {
            this.layout.refresh();
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (IMAGE.equals(key)) {
            return this.imageName;
        }
        if (SOURCE.equals(key)) {
            return this.imageSource;
        }
        return super.getAttributeValueString(key);
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if ("rotation".equals(name)) {
            return this.falseCond;
        }
        if (IMAGE.equals(name)) {
            return this.fixedCond;
        }
        return super.getAttributeVisibility(name);
    }

    @Override
    public void draw(Graphics g, GamePieceImage defn) {
        BufferedImage img;
        this.loadImage(defn);
        Point origin = this.layout.getPosition(this);
        if (this.isAntialias()) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.srcOp != null && (img = this.srcOp.getImage()) != null) {
            g.drawImage(img, origin.x, origin.y, null);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Dimension getSize() {
        return this.imageBounds.getSize();
    }

    public boolean isFixed() {
        return this.imageSource.equals(SRC_FIXED);
    }

    protected void loadImage(GamePieceImage defn) {
        String iName;
        ImageItemInstance Ii = null;
        if (defn != null) {
            Ii = defn.getImageInstance(this.getConfigureName());
        }
        if (Ii == null) {
            Ii = new ImageItemInstance();
        }
        if ((iName = this.imageSource.equals(SRC_FIXED) ? this.imageName : Ii.getImageName()) != null) {
            this.srcOp = iName.trim().length() == 0 ? BaseOp.op : Op.load(iName);
            this.imageBounds = ImageUtils.getBounds(this.srcOp.getSize());
        } else {
            this.imageBounds = new Rectangle();
        }
    }

    public static Item decode(GamePieceLayout l, String s) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ';');
        ImageItem item = new ImageItem(l);
        sd.nextToken();
        item.imageName = sd.nextToken("");
        item.imageSource = sd.nextToken(SRC_FIXED);
        return item;
    }

    @Override
    public String encode() {
        SequenceEncoder se1 = new SequenceEncoder(TYPE, ';');
        se1.append(this.imageName).append(this.imageSource);
        SequenceEncoder se2 = new SequenceEncoder(se1.getValue(), '|');
        se2.append(super.encode());
        return se2.getValue();
    }

    public static class TextSource
    extends StringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{ImageItem.SRC_VARIABLE, ImageItem.SRC_FIXED};
        }
    }

    protected static final class BaseOp
    extends AbstractTileOpImpl {
        private static final BaseOp op = new BaseOp();

        private BaseOp() {
        }

        @Override
        public BufferedImage eval() {
            BufferedImage img = ImageUtils.createCompatibleTranslucentImage(10, 10);
            Graphics2D bg = img.createGraphics();
            bg.setColor(Color.black);
            bg.drawRect(0, 0, 9, 9);
            bg.drawLine(0, 0, 9, 9);
            bg.drawLine(0, 9, 9, 0);
            bg.dispose();
            return img;
        }

        @Override
        protected void fixSize() {
        }

        @Override
        public Dimension getSize() {
            return new Dimension(10, 10);
        }

        @Override
        public int getWidth() {
            return 10;
        }

        @Override
        public int getHeight() {
            return 10;
        }

        @Override
        public List<VASSAL.tools.opcache.Op<?>> getSources() {
            return Collections.emptyList();
        }
    }
}

