/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.Player;
import VASSAL.chat.PrivateChatManager;
import VASSAL.chat.PrivateChatter;
import VASSAL.command.Command;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class PrivMsgCommand
extends Command {
    private PrivateChatManager mgr;
    private String msg;
    private Player p;

    public PrivMsgCommand(PrivateChatManager mgr, Player sender, String msg) {
        this.mgr = mgr;
        this.msg = msg;
        this.p = sender;
    }

    @Override
    public void executeCommand() {
        PrivateChatter chat = this.mgr.getChatterFor(this.p);
        if (chat == null) {
            return;
        }
        Window f = SwingUtilities.getWindowAncestor(chat);
        if (!f.isVisible()) {
            f.setVisible(true);
            Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (c == null || !SwingUtilities.isDescendingFrom(c, f)) {
                Toolkit.getDefaultToolkit().beep();
                int j = chat.getComponentCount();
                for (int i = 0; i < j; ++i) {
                    if (!(chat.getComponent(i) instanceof JTextField)) continue;
                    chat.getComponent(i).requestFocus();
                    break;
                }
            }
        } else {
            f.toFront();
        }
        chat.show(this.msg);
    }

    @Override
    public Command myUndoCommand() {
        return null;
    }

    @Override
    public boolean isLoggable() {
        return false;
    }

    public Player getSender() {
        return this.p;
    }

    public String getMessage() {
        return this.msg;
    }
}

