/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.Room;
import VASSAL.chat.SimpleRoom;
import java.util.HashMap;
import java.util.Map;

public interface ServerStatus {
    public ModuleSummary[] getStatus();

    public String[] getSupportedTimeRanges();

    public ModuleSummary[] getHistory(String var1);

    public static class ModuleSummary {
        private String moduleName;
        private Map<String, Room> rooms = new HashMap<String, Room>();

        public ModuleSummary(String moduleName) {
            this.moduleName = moduleName;
        }

        public ModuleSummary(String moduleName, Room[] rooms) {
            this(moduleName);
            for (Room r : rooms) {
                this.rooms.put(r.getName(), r);
            }
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public void setModuleName(String moduleName) {
            this.moduleName = moduleName;
        }

        public void addRoom(Room r) {
            this.rooms.put(r.getName(), r);
        }

        public SimpleRoom getRoom(String name) {
            return (SimpleRoom)this.rooms.get(name);
        }

        public Room[] getRooms() {
            return this.rooms.values().toArray(new Room[0]);
        }

        public int numPlayers() {
            Room[] roomsArray = this.getRooms();
            int n = 0;
            for (Room room : roomsArray) {
                n += ((SimpleRoom)room).numPlayers();
            }
            return n;
        }

        public String toString() {
            return this.moduleName;
        }
    }
}

