/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.PlayerEncoder;
import VASSAL.chat.SynchCommand;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;

public class SynchEncoder
implements CommandEncoder {
    public static final String COMMAND_PREFIX = "SYNC";
    private PlayerEncoder playerEncoder;
    private ChatServerConnection client;

    public SynchEncoder(PlayerEncoder playerEncoder, ChatServerConnection client) {
        this.playerEncoder = playerEncoder;
        this.client = client;
    }

    @Override
    public Command decode(String s) {
        if (s.startsWith(COMMAND_PREFIX)) {
            Player p = this.playerEncoder.stringToPlayer(s.substring(COMMAND_PREFIX.length()));
            return new SynchCommand(p, this.client);
        }
        return null;
    }

    @Override
    public String encode(Command c) {
        if (c instanceof SynchCommand) {
            SynchCommand cmd = (SynchCommand)c;
            return COMMAND_PREFIX + this.playerEncoder.playerToString(cmd.getPlayer());
        }
        return null;
    }
}

