/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.jabber;

import VASSAL.build.GameModule;
import VASSAL.chat.LockableChatServerConnection;
import VASSAL.chat.LockableRoom;
import VASSAL.chat.Player;
import VASSAL.chat.PlayerEncoder;
import VASSAL.chat.PrivateChatEncoder;
import VASSAL.chat.PrivateChatManager;
import VASSAL.chat.Room;
import VASSAL.chat.ServerStatus;
import VASSAL.chat.SimpleStatus;
import VASSAL.chat.SoundEncoder;
import VASSAL.chat.SynchEncoder;
import VASSAL.chat.jabber.AccountInfo;
import VASSAL.chat.jabber.JabberPlayer;
import VASSAL.chat.jabber.JabberRoom;
import VASSAL.chat.jabber.LockableJabberRoomControls;
import VASSAL.chat.jabber.PacketProcessor;
import VASSAL.chat.messageboard.MessageBoard;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.chat.ui.InviteAction;
import VASSAL.chat.ui.KickAction;
import VASSAL.chat.ui.LockableRoomTreeRenderer;
import VASSAL.chat.ui.PrivateMessageAction;
import VASSAL.chat.ui.RoomInteractionControlsInitializer;
import VASSAL.chat.ui.SendSoundAction;
import VASSAL.chat.ui.ShowProfileAction;
import VASSAL.chat.ui.SimpleStatusControlsInitializer;
import VASSAL.chat.ui.SynchAction;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.io.DeobfuscatingInputStream;
import VASSAL.tools.io.FastByteArrayOutputStream;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.io.ObfuscatingOutputStream;
import VASSAL.tools.swing.Dialogs;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromContainsFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.muc.DefaultParticipantStatusListener;
import org.jivesoftware.smackx.muc.DefaultUserStatusListener;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.InvitationListener;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jivesoftware.smackx.muc.UserStatusListener;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.jivesoftware.smackx.packet.MUCUser;
import org.jivesoftware.smackx.packet.VCard;

public class JabberClient
implements LockableChatServerConnection,
PacketListener,
ServerStatus,
ChatControlsInitializer,
PlayerEncoder {
    private static final String QUERY_ROOMS = "http://jabber.org/protocol/muc#rooms";
    private static final String QUERY_USER = "http://jabber.org/protocol/muc#user";
    private static final String INVITE = "Invite";
    private static final String REAL_NAME = "realName";
    public static final String JID_RESOURCE = "/VASSAL";
    public static final String ROOM_CONFIG = "roomConfig";
    public static final String ROOM_JID = "roomJid";
    public static final String ROOM_NAME = "roomName";
    public static final String OWNER = "owner";
    private MessageBoard msgSvr;
    private XMPPConnection conn;
    private String host;
    private int port = 5222;
    private PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    private JabberPlayer me;
    private String conferenceService;
    private MonitorRooms monitor;
    private CommandEncoder encoder;
    private final JabberRoom defaultRoom;
    private MultiUserChat currentChat;
    private AccountInfo account;
    private SynchEncoder synchEncoder;
    protected SoundEncoder soundEncoder;
    protected PrivateChatEncoder privateChatEncoder;
    protected RoomInteractionControlsInitializer roomControls;
    protected SimpleStatusControlsInitializer playerStatusControls;
    protected JabberPlayer.Manager playerMgr = new JabberPlayer.Manager();
    protected JabberRoom.Manager roomMgr = new JabberRoom.Manager();
    protected PropertyChangeListener idChangeListener;
    protected UserStatusListener kickListener;
    protected InvitationListener inviteListener;
    protected ParticipantStatusListener userListener;

    public JabberClient(CommandEncoder encoder, String host, int port, AccountInfo account) {
        XMPPConnection.DEBUG_ENABLED = "true".equals(System.getProperty("debugJabber"));
        this.host = host;
        this.conferenceService = "conference." + host;
        this.encoder = encoder;
        this.account = account;
        this.defaultRoom = this.roomMgr.getRoomByName(this, "Main Room");
        this.roomControls = new LockableJabberRoomControls(this);
        this.roomControls.addPlayerActionFactory(ShowProfileAction.factory());
        this.roomControls.addPlayerActionFactory(SynchAction.factory(this));
        PrivateChatManager privateChatManager = new PrivateChatManager(this);
        this.roomControls.addPlayerActionFactory(PrivateMessageAction.factory(this, privateChatManager));
        this.roomControls.addPlayerActionFactory(SendSoundAction.factory(this, Resources.getString("Chat.send_wakeup"), "wakeUpSound", "phone1.wav"));
        this.roomControls.addPlayerActionFactory(InviteAction.factory(this));
        this.roomControls.addPlayerActionFactory(KickAction.factory(this));
        this.playerStatusControls = new SimpleStatusControlsInitializer(this);
        this.synchEncoder = new SynchEncoder(this, this);
        this.soundEncoder = new SoundEncoder(this);
        this.privateChatEncoder = new PrivateChatEncoder(this, privateChatManager);
        this.idChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (JabberClient.this.me != null) {
                    SimpleStatus s = (SimpleStatus)JabberClient.this.me.getStatus();
                    s.updateStatus();
                    JabberClient.this.me.setStatus(s);
                    JabberClient.this.me.setName((String)GameModule.getGameModule().getPrefs().getValue("RealName"));
                }
                if (JabberClient.this.monitor != null) {
                    JabberClient.this.monitor.sendStatus(JabberClient.this.me);
                }
            }
        };
        this.kickListener = new DefaultUserStatusListener(){

            public void kicked(String kicker, String reason) {
                JabberClient.this.fireStatus(Resources.getString("Chat.kicked", JabberClient.this.getRoom().getName()));
                JabberClient.this.setRoom(JabberClient.this.defaultRoom);
            }
        };
        this.inviteListener = new InvitationListener(){

            public void invitationReceived(XMPPConnection conn, String room, String inviter, String reason, String password, Message mess) {
                if (JabberClient.INVITE.equals(reason)) {
                    String playerLogin = inviter.split("@")[0];
                    JabberPlayer player = JabberClient.this.playerMgr.getPlayer(inviter + JabberClient.JID_RESOURCE);
                    String playerName = player.getName() + "(" + playerLogin + ")";
                    String roomName = JabberClient.this.roomMgr.getRoomByJID(JabberClient.this, room).getName();
                    int i = Dialogs.showConfirmDialog(GameModule.getGameModule().getPlayerWindow(), Resources.getString("Chat.invite_heading"), Resources.getString("Chat.invite_heading"), Resources.getString("Chat.invitation", playerName, roomName), 3, null, 0, JabberClient.INVITE + inviter, Resources.getString("Chat.ignore_invitation"));
                    if (i == 0) {
                        JabberClient.this.doInvite(inviter, roomName);
                    } else {
                        MultiUserChat.decline((XMPPConnection)conn, (String)room, (String)inviter, (String)"");
                    }
                }
            }
        };
        this.userListener = new DefaultParticipantStatusListener(){

            public void kicked(String participant, String arg1, String arg2) {
                this.revokeMembership(participant);
            }

            public void left(String participant) {
                this.revokeMembership(participant);
            }

            private void revokeMembership(String participant) {
                LockableRoom room = JabberClient.this.getCurrentRoom();
                if (room.isLocked() && room.isOwner(JabberClient.this.me.getJid())) {
                    try {
                        String jid = JabberPlayer.xmppAddressToJid(participant);
                        JabberClient.this.currentChat.revokeMembership(JabberClient.this.playerMgr.getPlayer(jid).getId());
                    }
                    catch (XMPPException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.propSupport.addPropertyChangeListener(propertyName, l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propSupport.addPropertyChangeListener(l);
    }

    @Override
    public boolean isConnected() {
        return this.conn != null && this.conn.isConnected();
    }

    @Override
    public void sendToOthers(Command c) {
        if (this.currentChat != null) {
            try {
                this.currentChat.sendMessage(this.encodeMessage(this.encoder.encode(c)));
            }
            catch (XMPPException e) {
                this.reportXMPPException(e);
            }
        }
    }

    @Override
    public void setConnected(boolean connect) {
        if (connect) {
            if (!this.isConnected()) {
                if (this.conn != null) {
                    this.conn.disconnect();
                }
                try {
                    this.playerMgr.clear();
                    this.roomMgr.clear();
                    String username = this.account.getUserName();
                    String password = this.account.getPassword();
                    this.me = this.playerMgr.getPlayerByLogin(this, this.account.getUserName());
                    GameModule g = GameModule.getGameModule();
                    SimpleStatus s = (SimpleStatus)this.me.getStatus();
                    s.updateStatus();
                    this.me.setStatus(s);
                    this.me.setName((String)g.getPrefs().getValue("RealName"));
                    ConnectionConfiguration config = new ConnectionConfiguration(this.host, this.port);
                    config.setCompressionEnabled(true);
                    config.setDebuggerEnabled(XMPPConnection.DEBUG_ENABLED);
                    config.setReconnectionAllowed(true);
                    this.conn = new XMPPConnection(config);
                    this.conn.connect();
                    this.conn.addConnectionListener((org.jivesoftware.smack.ConnectionListener)new ConnectionListener());
                    try {
                        this.conn.login(username, password, "VASSAL");
                    }
                    catch (XMPPException e) {
                        HashMap<String, String> attributes = new HashMap<String, String>();
                        attributes.put("name", this.me.getName());
                        try {
                            this.conn.getAccountManager().createAccount(username, password, attributes);
                        }
                        catch (XMPPException createAccountError) {
                            if (createAccountError.getXMPPError() != null && createAccountError.getXMPPError().getCode() == 409) {
                                this.fireStatus(Resources.getString("Chat.invalid_password", username));
                                this.setConnected(false);
                                return;
                            }
                            this.setConnected(false);
                            throw createAccountError;
                        }
                        this.conn.disconnect();
                        this.conn.connect();
                        try {
                            this.conn.login(username, password, "VASSAL");
                        }
                        catch (XMPPException retryError) {
                            this.setConnected(false);
                            throw retryError;
                        }
                        VCard c = new VCard();
                        c.setNickName(this.me.getName());
                        c.save(this.conn);
                    }
                    this.monitor = new MonitorRooms();
                    this.monitor.init();
                    this.propSupport.firePropertyChange("Connected", null, Boolean.TRUE);
                    this.fireStatus(Resources.getString("Server.connected", this.host + ":" + this.port));
                    this.setRoom(this.defaultRoom);
                    GameModule.getGameModule().addIdChangeListener(this.idChangeListener);
                    MultiUserChat.addInvitationListener((XMPPConnection)this.conn, (InvitationListener)this.inviteListener);
                }
                catch (XMPPException e) {
                    this.reportXMPPException(e);
                    if (e.getWrappedThrowable() != null && e.getWrappedThrowable().getLocalizedMessage() != null) {
                        this.fireStatus(e.getWrappedThrowable().getMessage());
                    }
                    this.setConnected(false);
                }
            }
        } else if (this.isConnected()) {
            this.leaveCurrentRoom();
            if (this.monitor != null) {
                this.monitor.disconnect();
            }
            this.conn.disconnect();
            this.tidyConnection();
        }
    }

    private void tidyConnection() {
        this.conn = null;
        this.monitor = null;
        this.currentChat = null;
        this.propSupport.firePropertyChange("Connected", null, Boolean.FALSE);
        this.playerMgr.clear();
        this.roomMgr.clear();
        this.fireStatus(Resources.getString("Server.disconnected", this.host + ":" + this.port));
    }

    private void leaveCurrentRoom() {
        if (this.currentChat != null) {
            this.currentChat.leave();
            this.currentChat.removeMessageListener((PacketListener)this);
            this.currentChat.removeUserStatusListener(this.kickListener);
            this.currentChat.removeParticipantStatusListener(this.userListener);
            this.currentChat = null;
        }
    }

    @Override
    public void initializeControls(ChatServerControls controls) {
        this.playerStatusControls.initializeControls(controls);
        this.roomControls.initializeControls(controls);
        controls.setRoomControlsVisible(true);
        GameModule.getGameModule().addCommandEncoder(this.synchEncoder);
        GameModule.getGameModule().addCommandEncoder(this.privateChatEncoder);
        GameModule.getGameModule().addCommandEncoder(this.soundEncoder);
        controls.getRoomTree().setCellRenderer(new LockableRoomTreeRenderer());
    }

    @Override
    public void uninitializeControls(ChatServerControls controls) {
        this.roomControls.uninitializeControls(controls);
        this.playerStatusControls.uninitializeControls(controls);
        GameModule.getGameModule().removeCommandEncoder(this.synchEncoder);
        GameModule.getGameModule().removeCommandEncoder(this.privateChatEncoder);
        GameModule.getGameModule().removeCommandEncoder(this.soundEncoder);
    }

    public void processPacket(Packet packet) {
        Message m = (Message)packet;
        if (!m.getFrom().equals(this.currentChat.getRoom() + "/" + this.currentChat.getNickname())) {
            this.propSupport.firePropertyChange("Msg", null, this.decodeMessage(m.getBody()));
        }
    }

    public void processServerMessage(String subject, String message) {
        GameModule g = GameModule.getGameModule();
        g.warn("##### " + Resources.getString("JabberClient.message_from_admin", this.host + ":" + this.port));
        if (subject != null) {
            g.warn(Resources.getString("JabberClient.subject") + subject);
        }
        g.warn(message);
        g.warn("##### " + Resources.getString("JabberClient.end_message"));
    }

    @Override
    public Room getRoom() {
        return this.monitor.getCurrentRoom();
    }

    public JabberRoom getRoomByName(String name) {
        return this.roomMgr.getRoomByName(this, name);
    }

    public String getCurrentRoomJID() {
        return this.currentChat == null ? null : this.currentChat.getRoom();
    }

    public LockableRoom getCurrentRoom() {
        return this.monitor.getCurrentRoom();
    }

    public void setRoom(String roomName) {
        this.setRoom(this.roomMgr.getRoomByName(this, roomName));
    }

    @Override
    public void setRoom(Room r) {
        JabberRoom newRoom = null;
        try {
            newRoom = r instanceof JabberRoom ? (JabberRoom)r : this.roomMgr.getRoomByName(this, r.getName());
            if (!newRoom.equals(this.getRoom())) {
                String failedToJoinMessage = newRoom.canJoin(this.me);
                if (failedToJoinMessage != null) {
                    this.fireStatus(Resources.getString("Chat.failed_to_join", newRoom.getName(), failedToJoinMessage));
                    return;
                }
                this.leaveCurrentRoom();
                this.currentChat = newRoom.join(this, (JabberPlayer)this.getUserInfo());
                if (newRoom.isOwnedByMe()) {
                    this.currentChat.addParticipantStatusListener(this.userListener);
                }
                this.fireStatus(Resources.getString("Chat.joined_room", newRoom.getName()));
                if (!newRoom.isOwnedByMe() && !this.isDefaultRoom(newRoom)) {
                    new SynchAction(newRoom.getOwningPlayer(), this).actionPerformed(null);
                    GameModule.getGameModule().warn(Resources.getString("Chat.synchronize_complete"));
                } else {
                    SynchAction.clearSynchRoom();
                }
                this.currentChat.addUserStatusListener(this.kickListener);
                this.monitor.sendRoomChanged();
                this.monitor.sendStatus(this.me, newRoom);
            }
        }
        catch (XMPPException e) {
            this.reportXMPPException(e);
            String mess = null;
            if (e.getXMPPError() != null) {
                XMPPError error = e.getXMPPError();
                if (error.getCode() == 407) {
                    mess = Resources.getString("Chat.not_a_member");
                } else {
                    mess = e.getXMPPError().getMessage();
                    if (mess == null) {
                        mess = e.getXMPPError().getCondition();
                    }
                }
            } else {
                mess = e.getMessage();
            }
            this.fireStatus(Resources.getString("Chat.failed_to_join", newRoom.getName(), mess));
        }
    }

    @Override
    public Room[] getAvailableRooms() {
        return this.monitor.getAvailableRooms();
    }

    protected void fireRoomsUpdated() {
        this.propSupport.firePropertyChange("AvailableRooms", null, this.getAvailableRooms());
        this.propSupport.firePropertyChange("Room", null, this.getRoom());
    }

    protected void fireStatus(String msg) {
        this.propSupport.firePropertyChange("Status", null, msg);
    }

    @Override
    public Player getUserInfo() {
        return this.playerMgr.getPlayerByLogin(this, this.account.getUserName());
    }

    @Override
    public void setUserInfo(Player p) {
        if (this.monitor != null) {
            this.monitor.sendStatus((JabberPlayer)p);
        }
    }

    @Override
    public String getDefaultRoomName() {
        return this.defaultRoom.getName();
    }

    @Override
    public boolean isDefaultRoom(Room r) {
        return r == null ? false : r.getName().equals(this.getDefaultRoomName());
    }

    @Override
    public void sendTo(Player recipient, Command c) {
        Chat chat = this.conn.getChatManager().createChat(((JabberPlayer)recipient).getJid(), null);
        try {
            chat.sendMessage(this.encodeMessage(this.encoder.encode(c)));
        }
        catch (XMPPException e) {
            this.reportXMPPException(e);
        }
    }

    @Override
    public boolean isInvitable(Player invitee) {
        JabberRoom room;
        return !invitee.equals(this.me) && !(room = this.monitor.getCurrentRoom()).contains(invitee) && room.isOwnedByMe() && room.isLocked();
    }

    @Override
    public void sendInvite(Player invitee) {
        try {
            this.currentChat.grantMembership(invitee.getId());
        }
        catch (XMPPException e) {
            ErrorDialog.bug(new Throwable("Unable to grant membership to room " + this.getCurrentRoom().getName() + " to player " + invitee.getId(), e));
        }
        this.currentChat.invite(((JabberPlayer)invitee).getRawJid(), INVITE);
    }

    @Override
    public void doInvite(String playerId, String roomName) {
        this.setRoom(roomName);
    }

    @Override
    public boolean isKickable(Player kickee) {
        JabberRoom room;
        return !kickee.equals(this.me) && (room = this.monitor.getCurrentRoom()).contains(kickee) && room.isOwnedByMe() && room.isLocked();
    }

    @Override
    public void doKick(Player kickee) {
        try {
            this.currentChat.kickParticipant(((JabberPlayer)kickee).getLoginName(), "");
        }
        catch (XMPPException e) {
            e.printStackTrace();
        }
    }

    private void reportXMPPException(XMPPException e) {
        e.printStackTrace();
    }

    public MessageBoard getMessageServer() {
        return this.msgSvr;
    }

    public ServerStatus getStatusServer() {
        return this;
    }

    public XMPPConnection getConnection() {
        return this.conn;
    }

    public String getModule() {
        return "vassal-" + GameModule.getGameModule().getGameName();
    }

    public String getConferenceService() {
        return this.conferenceService;
    }

    public static String unescapeNode(String node) {
        return StringUtils.unescapeNode((String)node);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected String encodeMessage(String clearText) {
        try (FastByteArrayOutputStream ba = new FastByteArrayOutputStream();){
            String string;
            try (ObfuscatingOutputStream out = new ObfuscatingOutputStream(ba);){
                out.write(clearText.getBytes(StandardCharsets.UTF_8));
                string = new String(ba.toByteArray(), StandardCharsets.UTF_8);
            }
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected String decodeMessage(String encodedMessage) {
        try (ByteArrayInputStream ba = new ByteArrayInputStream(encodedMessage.getBytes(StandardCharsets.UTF_8));){
            String string;
            try (DeobfuscatingInputStream in = new DeobfuscatingInputStream(ba);){
                string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            }
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public void lockRoom(LockableRoom r) {
        if (r instanceof JabberRoom) {
            JabberRoom room = (JabberRoom)r;
            room.toggleLock(this.currentChat);
            try {
                this.monitor.sendRoomChanged();
            }
            catch (XMPPException xMPPException) {
                // empty catch block
            }
        }
    }

    public CommandEncoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(CommandEncoder encoder) {
        this.encoder = encoder;
    }

    @Override
    public ServerStatus.ModuleSummary[] getHistory(String timeRange) {
        return new ServerStatus.ModuleSummary[0];
    }

    @Override
    public ServerStatus.ModuleSummary[] getStatus() {
        ArrayList entries = new ArrayList();
        try {
            for (HostedRoom room : MultiUserChat.getHostedRooms((XMPPConnection)this.conn, (String)this.conferenceService)) {
                MultiUserChat.getRoomInfo((XMPPConnection)this.conn, (String)room.getJid());
            }
        }
        catch (XMPPException e) {
            e.printStackTrace();
        }
        return entries.toArray(new ServerStatus.ModuleSummary[0]);
    }

    @Override
    public String[] getSupportedTimeRanges() {
        return new String[0];
    }

    public static void main(String[] args) {
        XMPPConnection.DEBUG_ENABLED = true;
        CommandEncoder c = new CommandEncoder(){

            @Override
            public Command decode(String command) {
                System.err.println(command);
                return null;
            }

            @Override
            public String encode(Command c) {
                return null;
            }
        };
        final String username = args.length == 0 ? "test" : args[0];
        final String password = args.length == 0 ? "test" : args[1];
        AccountInfo account = new AccountInfo(){

            @Override
            public String getPassword() {
                return password;
            }

            @Override
            public String getUserName() {
                return username;
            }

            @Override
            public String getModule() {
                return "JabberTestModule";
            }

            @Override
            public String getRealName() {
                return username;
            }
        };
        JabberClient client = new JabberClient(c, "localhost", 5222, account);
        client.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                System.err.println(evt.getPropertyName() + "=" + evt.getNewValue());
            }
        });
        ChatServerControls controls = new ChatServerControls();
        controls.setClient(client);
        JFrame f = new JFrame(username);
        f.add(controls.getControls());
        f.pack();
        f.setVisible(true);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    public String getHost() {
        return this.host;
    }

    @Override
    public String playerToString(Player p) {
        return ((JabberPlayer)p).getJid();
    }

    @Override
    public Player stringToPlayer(String s) {
        return this.playerMgr.getPlayer(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String testConnection(String host, String port, String login, String passwd) {
        StringBuilder text;
        block13: {
            text = new StringBuilder(Resources.getString("JabberClient.testing_connection") + host + ":" + port + " " + login + "/" + passwd).append("\n");
            if (host.length() == 0) {
                return text.append(Resources.getString("JabberClient.error_no_host")).toString();
            }
            int portNo = 0;
            try {
                portNo = Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                return text.append(Resources.getString("JabberClient.error_port_number")).toString();
            }
            ConnectionConfiguration config = new ConnectionConfiguration(host, portNo);
            config.setCompressionEnabled(true);
            config.setDebuggerEnabled(XMPPConnection.DEBUG_ENABLED);
            config.setReconnectionAllowed(true);
            XMPPConnection conn = new XMPPConnection(config);
            try {
                text.append(Resources.getString("JabberClient.attempting_to_connect")).append("\n");
                conn.connect();
                text.append(Resources.getString("JabberClient.success")).append("\n");
                text.append(Resources.getString("JabberClient.attempting_to_login")).append("\n");
                try {
                    conn.login(login, passwd, "VASSAL");
                    text.append(Resources.getString("JabberClient.success"));
                }
                catch (XMPPException e) {
                    text.append(Resources.getString("JabberClient.login_failed")).append("\n");
                    text.append(Resources.getString("JabberClient.attempting_to_create")).append("\n");
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    attributes.put("name", GameModule.getUserId());
                    try {
                        conn.getAccountManager().createAccount(login, passwd, attributes);
                        text.append(Resources.getString("JabberClient.success"));
                    }
                    catch (XMPPException ex) {
                        text.append(Resources.getString("JabberClient.failed")).append("\n");
                        if (ex.getXMPPError() != null && ex.getXMPPError().getCode() == 409) {
                            text.append(Resources.getString("Chat.invalid_password")).append("\n");
                            break block13;
                        }
                        text.append(JabberClient.formatXMPPError(ex));
                    }
                }
            }
            catch (XMPPException e) {
                text.append(Resources.getString("JabberClient.failed")).append("\n");
                text.append(JabberClient.formatXMPPError(e));
            }
            finally {
                conn.disconnect();
            }
        }
        return text.toString();
    }

    private static String formatXMPPError(XMPPException e) {
        XMPPError error = e.getXMPPError();
        if (error == null) {
            return Resources.getString("Server.server_error", e.getMessage(), "", "");
        }
        return Resources.getString("Server.server_error", e.getXMPPError().getMessage(), e.getXMPPError().getCondition(), e.getXMPPError().getCode());
    }

    private class ConnectionListener
    implements org.jivesoftware.smack.ConnectionListener {
        private ConnectionListener() {
        }

        public void connectionClosed() {
        }

        public void connectionClosedOnError(Exception e) {
            XMPPException xe;
            String msg = e.getMessage();
            if (e instanceof XMPPException && (xe = (XMPPException)((Object)e)).getStreamError() != null && "conflict".equals(xe.getStreamError().getCode())) {
                msg = Resources.getString("Server.account_in_use");
            }
            if (msg != null) {
                JabberClient.this.fireStatus(msg);
            }
            JabberClient.this.setConnected(false);
        }

        public void reconnectingIn(int seconds) {
        }

        public void reconnectionFailed(Exception e) {
        }

        public void reconnectionSuccessful() {
        }
    }

    private class MonitorRooms
    implements PacketListener,
    ParticipantStatusListener {
        private static final String ROOM_CHANGE_ACTION = "changedRoom";
        private MultiUserChat monitorRoom;
        private Comparator<Room> roomSortOrder = new Comparator<Room>(){

            @Override
            public int compare(Room o1, Room o2) {
                if (o1.equals(JabberClient.this.defaultRoom) && !o2.equals(JabberClient.this.defaultRoom)) {
                    return -1;
                }
                if (o2.equals(JabberClient.this.defaultRoom) && !o1.equals(JabberClient.this.defaultRoom)) {
                    return 1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        };

        private MonitorRooms() {
        }

        public void init() throws XMPPException {
            block2: {
                new TrackRooms().addTo(JabberClient.this.conn);
                new TrackStatus(this.getMonitorRoomJID().toLowerCase()).addTo(JabberClient.this.conn);
                new ListenForChat().addTo(JabberClient.this.conn);
                this.monitorRoom = new MultiUserChat(JabberClient.this.conn, this.getMonitorRoomJID());
                this.monitorRoom.addMessageListener((PacketListener)this);
                this.monitorRoom.addParticipantStatusListener((ParticipantStatusListener)this);
                this.monitorRoom.join(StringUtils.parseName((String)JabberClient.this.conn.getUser()));
                try {
                    this.monitorRoom.sendConfigurationForm(new Form("submit"));
                }
                catch (XMPPException ex) {
                    if (ex.getXMPPError().getCode() == 403) break block2;
                    throw ex;
                }
            }
            this.sendStatus(JabberClient.this.me);
        }

        public String getMonitorRoomJID() {
            return StringUtils.escapeNode((String)JabberClient.this.getModule()) + "@" + JabberClient.this.getConferenceService();
        }

        protected void sendStatus(JabberPlayer p) {
            this.sendStatus(p, null, p.getJoinedRoom());
        }

        protected void sendStatus(JabberPlayer player, JabberRoom room) {
            this.sendStatus(player, null, room);
        }

        protected void sendStatus(JabberPlayer player, String recipient, JabberRoom room) {
            SimpleStatus s = (SimpleStatus)player.getStatus();
            Presence p = new Presence(Presence.Type.available);
            p.setStatus("");
            p.setMode(Presence.Mode.chat);
            p.setProperty("looking", (Object)s.isLooking());
            p.setProperty("away", (Object)s.isAway());
            p.setProperty("ip", (Object)s.getIp());
            p.setProperty("client", (Object)s.getClient());
            p.setProperty("moduleVersion", (Object)s.getModuleVersion());
            p.setProperty("crc", (Object)s.getCrc());
            p.setProperty(JabberClient.REAL_NAME, (Object)player.getName());
            if (room != null) {
                p.setProperty(JabberClient.ROOM_CONFIG, (Object)room.encodeConfig());
                p.setProperty(JabberClient.ROOM_JID, (Object)room.getJID());
                p.setProperty(JabberClient.ROOM_NAME, (Object)room.getName());
            }
            p.setTo(recipient == null ? this.monitorRoom.getRoom() : recipient);
            JabberClient.this.conn.sendPacket((Packet)p);
        }

        public Room[] getAvailableRooms() {
            List l;
            HashMap occupants = new HashMap();
            for (JabberPlayer jabberPlayer : JabberClient.this.playerMgr.getAllPlayers()) {
                JabberRoom room = jabberPlayer.getJoinedRoom();
                if (room == null) continue;
                l = occupants.computeIfAbsent(room, k -> new ArrayList());
                l.add(jabberPlayer);
            }
            if (!occupants.containsKey(JabberClient.this.defaultRoom)) {
                List l2 = Collections.emptyList();
                occupants.put(JabberClient.this.defaultRoom, l2);
            }
            Set rooms = occupants.keySet();
            for (JabberRoom room : rooms) {
                l = (List)occupants.get(room);
                room.setPlayers(l.toArray(new JabberPlayer[0]));
            }
            Room[] roomArray = rooms.toArray(new Room[0]);
            Arrays.sort(roomArray, this.roomSortOrder);
            return roomArray;
        }

        public JabberRoom getCurrentRoom() {
            String jid = JabberClient.this.getCurrentRoomJID();
            return JabberClient.this.roomMgr.getRoomByJID(JabberClient.this, jid);
        }

        public void sendRoomChanged() throws XMPPException {
            Message m = this.monitorRoom.createMessage();
            m.setBody(ROOM_CHANGE_ACTION);
            this.monitorRoom.sendMessage(m);
        }

        public void disconnect() {
            this.monitorRoom.leave();
        }

        public String getAbsolutePlayerJID(String jid) {
            return StringUtils.parseResource((String)jid) + "@" + JabberClient.this.host + JabberClient.JID_RESOURCE;
        }

        private void sendRoomQuery(String jid) {
            DiscoverItems disco = new DiscoverItems();
            disco.setType(IQ.Type.GET);
            disco.setTo(jid);
            disco.setNode(JabberClient.QUERY_ROOMS);
            JabberClient.this.conn.sendPacket((Packet)disco);
        }

        public void processPacket(Packet packet) {
            Message m = (Message)packet;
            if (ROOM_CHANGE_ACTION.equals(m.getBody())) {
                String jid = this.getAbsolutePlayerJID(packet.getFrom());
                JabberClient.this.playerMgr.getPlayer(this.getAbsolutePlayerJID(packet.getFrom()));
                this.sendRoomQuery(jid);
            }
        }

        public void joined(String participant) {
            JabberClient.this.playerMgr.getPlayer(this.getAbsolutePlayerJID(participant));
        }

        public void left(String participant) {
            String jid = this.getAbsolutePlayerJID(participant);
            JabberClient.this.playerMgr.deletePlayer(jid);
            JabberClient.this.fireRoomsUpdated();
        }

        public void kicked(String participant, String actor, String reason) {
        }

        public void voiceGranted(String participant) {
        }

        public void voiceRevoked(String participant) {
        }

        public void banned(String participant, String actor, String reason) {
        }

        public void membershipGranted(String participant) {
        }

        public void membershipRevoked(String participant) {
        }

        public void moderatorGranted(String participant) {
        }

        public void moderatorRevoked(String participant) {
        }

        public void ownershipGranted(String participant) {
        }

        public void ownershipRevoked(String participant) {
        }

        public void adminGranted(String participant) {
        }

        public void adminRevoked(String participant) {
        }

        public void nicknameChanged(String participant, String newNickname) {
        }

        private class TrackRooms
        extends PacketProcessor {
            private PacketFilter roomResponseFilter = new AndFilter(new PacketFilter[]{new IQTypeFilter(IQ.Type.RESULT), new PacketTypeFilter(DiscoverItems.class)});
            private PacketFilter newPlayerFilter = new AndFilter(new PacketFilter[]{new PacketTypeFilter(Presence.class), new FromContainsFilter(MonitorRooms.this.getMonitorRoomJID())});

            @Override
            public void process(Packet packet) {
                if (this.roomResponseFilter.accept(packet)) {
                    DiscoverItems result = (DiscoverItems)packet;
                    JabberPlayer player = JabberClient.this.playerMgr.getPlayer(packet.getFrom());
                    Iterator items = result.getItems();
                    while (items.hasNext()) {
                        String roomJID = ((DiscoverItems.Item)items.next()).getEntityID();
                        JabberRoom room = JabberClient.this.roomMgr.getRoomByJID(JabberClient.this, roomJID);
                        try {
                            room.setInfo(MultiUserChat.getRoomInfo((XMPPConnection)JabberClient.this.getConnection(), (String)roomJID));
                        }
                        catch (XMPPException xMPPException) {
                            // empty catch block
                        }
                        if (roomJID.equals(MonitorRooms.this.monitorRoom.getRoom())) continue;
                        player.join(JabberClient.this.roomMgr.getRoomByJID(JabberClient.this, roomJID));
                    }
                    JabberClient.this.fireRoomsUpdated();
                } else if (this.newPlayerFilter.accept(packet)) {
                    MonitorRooms.this.sendRoomQuery(MonitorRooms.this.getAbsolutePlayerJID(packet.getFrom()));
                }
            }

            @Override
            public boolean acceptPacket(Packet packet) {
                boolean accept = false;
                if (this.roomResponseFilter.accept(packet)) {
                    accept = JabberClient.QUERY_ROOMS.equals(((DiscoverItems)packet).getNode());
                } else if (this.newPlayerFilter.accept(packet)) {
                    accept = ((Presence)packet).isAvailable();
                }
                return accept;
            }
        }

        private class TrackStatus
        extends PacketProcessor {
            String prefix;
            private PacketFilter changeStatusFilter = new PacketFilter(){

                public boolean accept(Packet packet) {
                    String name;
                    Presence p;
                    boolean accept = false;
                    if (packet instanceof Presence && (p = (Presence)packet).getType() == Presence.Type.available && p.getMode() == Presence.Mode.chat && (name = p.getFrom()) != null && name.toLowerCase().startsWith(TrackStatus.this.prefix)) {
                        accept = true;
                    }
                    return accept;
                }
            };

            public TrackStatus(String prefix) {
                this.prefix = prefix;
            }

            @Override
            public boolean acceptPacket(Packet packet) {
                return packet instanceof Presence;
            }

            @Override
            public void process(Packet packet) {
                Presence p;
                if (this.changeStatusFilter.accept(packet)) {
                    p = (Presence)packet;
                    JabberPlayer player = JabberClient.this.playerMgr.getPlayer(MonitorRooms.this.getAbsolutePlayerJID(p.getFrom()));
                    SimpleStatus status = (SimpleStatus)player.getStatus();
                    String profile = status == null ? "" : status.getProfile();
                    Object looking = p.getProperty("looking");
                    Object away = p.getProperty("away");
                    String ip = p.getProperty("ip").toString();
                    String client = p.getProperty("client").toString();
                    String moduleVersion = p.getProperty("moduleVersion").toString();
                    String crc = p.getProperty("crc").toString();
                    status = new SimpleStatus(looking == null ? false : (Boolean)looking, away == null ? false : (Boolean)away, profile, client, ip, moduleVersion, crc);
                    player.setStatus(status);
                    player.setName(String.valueOf(p.getProperty(JabberClient.REAL_NAME)));
                    JabberClient.this.fireRoomsUpdated();
                }
                if (packet instanceof Presence && (p = (Presence)packet).getType().equals((Object)Presence.Type.available)) {
                    PacketExtension ext = p.getExtension(JabberClient.QUERY_USER);
                    JabberRoom room = null;
                    if (ext instanceof MUCUser) {
                        String affiliation = ((MUCUser)ext).getItem().getAffiliation();
                        String jid = JabberClient.this.playerMgr.getPlayer(MonitorRooms.this.getAbsolutePlayerJID(p.getFrom())).getJid();
                        Object roomJid = (String)p.getProperty(JabberClient.ROOM_JID);
                        String roomConfig = (String)p.getProperty(JabberClient.ROOM_CONFIG);
                        String roomName = (String)p.getProperty(JabberClient.ROOM_NAME);
                        if (roomJid == null) {
                            roomJid = StringUtils.parseName((String)p.getFrom()) + "@" + JabberClient.this.getConferenceService();
                        }
                        if ((room = JabberClient.this.roomMgr.getRoomByJID(JabberClient.this, (String)roomJid, roomName)) != null) {
                            if (JabberClient.OWNER.equals(affiliation)) {
                                room.addOwner(jid);
                            } else {
                                room.removeOwner(jid);
                            }
                        }
                        if (roomConfig != null && room != null) {
                            room.decodeConfig(roomConfig);
                        }
                    }
                }
            }
        }

        private class ListenForChat
        extends PacketProcessor {
            private PacketFilter chatFilter = new MessageTypeFilter(Message.Type.chat);
            private PacketFilter serverMessageFilter = new MessageTypeFilter(Message.Type.normal);

            private ListenForChat() {
            }

            @Override
            protected boolean acceptPacket(Packet packet) {
                if (this.chatFilter.accept(packet)) {
                    return true;
                }
                if (this.serverMessageFilter.accept(packet)) {
                    return packet.getFrom().equals(JabberClient.this.getConnection().getHost());
                }
                return false;
            }

            @Override
            protected void process(Packet packet) {
                if (this.chatFilter.accept(packet)) {
                    JabberClient.this.processPacket(packet);
                } else {
                    Message m = (Message)packet;
                    JabberClient.this.processServerMessage(m.getSubject(), m.getBody());
                }
            }
        }
    }
}

