/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SimpleStatus;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.i18n.Resources;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class SimpleStatusControlsInitializer
implements ChatControlsInitializer {
    private ChatServerConnection client;
    private boolean includeLooking;
    private JButton lookingBox;
    private JButton awayButton;

    public SimpleStatusControlsInitializer(ChatServerConnection client, boolean includeLooking) {
        this.client = client;
        this.includeLooking = includeLooking;
    }

    public SimpleStatusControlsInitializer(ChatServerConnection client) {
        this(client, true);
    }

    @Override
    public void initializeControls(final ChatServerControls controls) {
        URL imageURL;
        if (this.includeLooking) {
            this.lookingBox = new JButton(Resources.getString("Chat.looking_for_a_game"));
            this.lookingBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (SimpleStatusControlsInitializer.this.client != null) {
                        Player p = SimpleStatusControlsInitializer.this.client.getUserInfo();
                        SimpleStatus s = (SimpleStatus)p.getStatus();
                        s = new SimpleStatus(!s.isLooking(), s.isAway(), s.getProfile(), s.getClient(), s.getIp(), s.getModuleVersion(), s.getCrc());
                        SimpleStatusControlsInitializer.this.client.setUserInfo(new SimplePlayer(p.getId(), p.getName(), s));
                    }
                }
            });
            this.lookingBox.setSize(this.lookingBox.getMinimumSize());
            imageURL = this.getClass().getResource("/images/playerLooking.gif");
            if (imageURL != null) {
                this.lookingBox.setToolTipText(this.lookingBox.getText());
                this.lookingBox.setText("");
                this.lookingBox.setIcon(new ImageIcon(imageURL));
            }
        }
        this.awayButton = new JButton(Resources.getString("Chat.away_from_keyboard"));
        this.awayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (SimpleStatusControlsInitializer.this.client != null) {
                    Player p = SimpleStatusControlsInitializer.this.client.getUserInfo();
                    SimpleStatus s = (SimpleStatus)p.getStatus();
                    s = new SimpleStatus(s.isLooking(), true, s.getProfile(), s.getClient(), s.getIp(), s.getModuleVersion(), s.getCrc());
                    SimpleStatusControlsInitializer.this.client.setUserInfo(new SimplePlayer(p.getId(), p.getName(), s));
                    JOptionPane.showMessageDialog(controls.getRoomTree(), Resources.getString("Chat.im_back"), Resources.getString("Chat.away_from_keyboard"), -1);
                    s = (SimpleStatus)p.getStatus();
                    s = new SimpleStatus(s.isLooking(), false, s.getProfile(), s.getClient(), s.getIp(), s.getModuleVersion(), s.getCrc());
                    SimpleStatusControlsInitializer.this.client.setUserInfo(new SimplePlayer(p.getId(), p.getName(), s));
                }
            }
        });
        imageURL = this.getClass().getResource("/images/playerAway.gif");
        if (imageURL != null) {
            this.awayButton.setToolTipText(this.awayButton.getText());
            this.awayButton.setText("");
            this.awayButton.setIcon(new ImageIcon(imageURL));
        }
        if (this.includeLooking) {
            controls.getToolbar().add(this.lookingBox);
        }
        controls.getToolbar().add(this.awayButton);
    }

    @Override
    public void uninitializeControls(ChatServerControls controls) {
        if (this.includeLooking) {
            controls.getToolbar().remove(this.lookingBox);
        }
        controls.getToolbar().remove(this.awayButton);
    }
}

