/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.StringConfigurer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class FormattedStringConfigurer
extends StringConfigurer
implements ActionListener,
FocusListener {
    private final DefaultComboBoxModel<String> optionsModel = new DefaultComboBoxModel();
    private JComboBox<String> dropList;

    public FormattedStringConfigurer(String key, String name) {
        this(key, name, new String[0]);
    }

    public FormattedStringConfigurer(String key, String name, String[] options) {
        super(key, name);
        this.setOptions(options);
    }

    public void setOptions(String[] options) {
        this.optionsModel.removeAllElements();
        this.optionsModel.addElement("Insert");
        for (String option : options) {
            this.optionsModel.addElement(option);
        }
        this.setListVisibility();
    }

    public String[] getOptions() {
        String[] s = new String[this.optionsModel.getSize()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = this.optionsModel.getElementAt(i);
        }
        return s;
    }

    @Override
    public Component getControls() {
        if (this.p == null) {
            super.getControls();
            this.nameField.addFocusListener(this);
            this.dropList = new JComboBox<String>(this.optionsModel);
            this.dropList.setSelectedIndex(0);
            this.dropList.setEnabled(false);
            this.dropList.addActionListener(this);
            this.setListVisibility();
            this.p.add(this.dropList);
        }
        return this.p;
    }

    private void setListVisibility() {
        if (this.dropList != null) {
            this.dropList.setVisible(this.optionsModel.getSize() > 1);
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object item = "";
        int selectedIndex = this.dropList.getSelectedIndex();
        if (selectedIndex > 0) {
            item = "$" + this.optionsModel.getElementAt(selectedIndex) + "$";
            Object work = this.nameField.getText();
            int pos = this.nameField.getCaretPosition();
            if (this.nameField.getSelectedText() != null) {
                int start = this.nameField.getSelectionStart();
                int end = this.nameField.getSelectionEnd();
                if (pos > ((String)(work = ((String)work).substring(0, start) + ((String)work).substring(end))).length()) {
                    pos = ((String)work).length();
                }
            }
            String news = ((String)work).substring(0, pos) + (String)item + ((String)work).substring(pos);
            this.nameField.setText(news);
            this.nameField.setCaretPosition(pos + ((String)item).length());
            this.noUpdate = true;
            this.setValue(this.nameField.getText());
            this.noUpdate = false;
            this.nameField.repaint();
        }
        this.nameField.requestFocusInWindow();
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.dropList.setSelectedIndex(0);
        this.dropList.setEnabled(true);
        this.dropList.repaint();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.dropList.setEnabled(false);
    }
}

