/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;

public class HotKeyConfigurer
extends Configurer
implements KeyListener {
    private JTextField tf;
    private JPanel p;

    public HotKeyConfigurer(String key, String name) {
        this(key, name, KeyStroke.getKeyStroke('\u0000'));
    }

    public HotKeyConfigurer(String key, String name, KeyStroke val) {
        super(key, name, val);
    }

    @Override
    public void setValue(Object o) {
        super.setValue(o);
        if (this.tf != null && !this.tf.getText().equals(this.keyToString())) {
            this.tf.setText(this.keyToString());
        }
    }

    public String keyToString() {
        return HotKeyConfigurer.getString((KeyStroke)this.getValue());
    }

    @Override
    public String getValueString() {
        return HotKeyConfigurer.encode((KeyStroke)this.getValue());
    }

    @Override
    public void setValue(String s) {
        this.setValue(s == null ? null : HotKeyConfigurer.decode(s));
    }

    @Override
    public Component getControls() {
        if (this.p == null) {
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 0));
            this.tf = new JTextField(8);
            this.tf.setMaximumSize(new Dimension(this.tf.getMaximumSize().width, this.tf.getPreferredSize().height));
            this.tf.setText(this.keyToString());
            this.tf.addKeyListener(this);
            this.p.add(new JLabel(this.getName()));
            this.p.add(this.tf);
        }
        return this.p;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 8: 
            case 127: {
                this.setValue(null);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 157: {
                break;
            }
            default: {
                this.setValue(SwingUtils.systemToGeneric(SwingUtils.getKeyStrokeForEvent(e)));
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.tf.setText(HotKeyConfigurer.getString((KeyStroke)this.getValue()));
    }

    public static String getString(KeyStroke k) {
        Object s;
        if (k == null) {
            return null;
        }
        int code = k.getKeyCode();
        switch (code) {
            case 107: {
                s = Resources.getString("Keys.numplus");
                break;
            }
            case 109: {
                s = Resources.getString("Keys.numminus");
                break;
            }
            case 33: {
                s = Resources.getString("Keys.pgup");
                break;
            }
            case 34: {
                s = Resources.getString("Keys.pgdn");
                break;
            }
            case 91: {
                s = Resources.getString("Keys.bropen");
                break;
            }
            case 93: {
                s = Resources.getString("Keys.brclose");
                break;
            }
            default: {
                s = "";
            }
        }
        if (((String)s).isEmpty() || ((String)s).contains("Keys.")) {
            s = KeyEvent.getKeyText(code);
        }
        s = StringUtils.capitalize((String)s);
        s = ((String)s).replace(' ', '_');
        int mods = SwingUtils.genericToSystem(k).getModifiers();
        if ((mods & 0x40) > 0) {
            s = Resources.getString("Keys.shift") + "+" + (String)s;
        }
        if ((mods & 0x80) > 0) {
            s = Resources.getString("Keys.ctrl") + "+" + (String)s;
        }
        if ((mods & 0x100) > 0) {
            s = Resources.getString("Keys.meta") + "+" + (String)s;
        }
        if ((mods & 0x200) > 0) {
            s = Resources.getString("Keys.alt") + "+" + (String)s;
        }
        return s;
    }

    public static KeyStroke decode(String s) {
        int index = s.indexOf(44);
        if (index < 0) {
            return null;
        }
        try {
            return KeyStroke.getKeyStroke(Integer.parseInt(s.substring(0, index)), Integer.parseInt(s.substring(index + 1)));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static String encode(KeyStroke stroke) {
        return stroke == null ? "" : stroke.getKeyCode() + "," + stroke.getModifiers();
    }
}

