/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class NamedKeyStrokeArrayConfigurer
extends Configurer {
    private List<NamedHotKeyConfigurer> configs = new ArrayList<NamedHotKeyConfigurer>();
    private Box controls;
    private JPanel panel;

    public NamedKeyStrokeArrayConfigurer(String key, String name) {
        super(key, name);
    }

    public NamedKeyStrokeArrayConfigurer(String key, String name, NamedKeyStroke[] val) {
        super(key, name, val);
    }

    @Override
    public Component getControls() {
        if (this.panel == null) {
            this.panel = new JPanel(new BorderLayout());
            this.controls = Box.createVerticalBox();
            JScrollPane scroll = new JScrollPane(this.controls);
            Box b = Box.createHorizontalBox();
            this.controls.add(b);
            JLabel l = new JLabel(this.getName());
            b.add(l);
            JButton button = new JButton("Add");
            b.add(button);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NamedKeyStrokeArrayConfigurer.this.addKey(null);
                }
            });
            this.panel.add((Component)scroll, "Center");
            NamedKeyStroke[] keyStrokes = (NamedKeyStroke[])this.value;
            if (keyStrokes != null) {
                for (NamedKeyStroke keyStroke : keyStrokes) {
                    this.addKey(keyStroke);
                }
            }
            this.addKey(null);
        }
        return this.panel;
    }

    private void addKey(NamedKeyStroke keyStroke) {
        NamedHotKeyConfigurer config = new NamedHotKeyConfigurer(null, null, keyStroke);
        this.configs.add(config);
        this.controls.add(config.getControls());
        if (this.configs.size() > 5) {
            this.panel.setPreferredSize(new Dimension(this.panel.getPreferredSize().width, 150));
        } else {
            this.panel.setPreferredSize(null);
        }
        Window w = SwingUtilities.getWindowAncestor(this.controls);
        if (w != null) {
            w.pack();
        }
    }

    @Override
    public String getValueString() {
        return NamedKeyStrokeArrayConfigurer.encode(this.getKeyStrokes());
    }

    @Override
    public void setValue(String s) {
        this.setValue(NamedKeyStrokeArrayConfigurer.decode(s));
    }

    @Override
    public void setValue(Object o) {
        super.setValue(o);
        if (this.controls != null) {
            int i;
            NamedKeyStroke[] keyStrokes = (NamedKeyStroke[])o;
            if (keyStrokes == null) {
                keyStrokes = new NamedKeyStroke[]{};
            }
            for (i = 0; i < keyStrokes.length; ++i) {
                if (i > this.configs.size()) {
                    this.addKey(keyStrokes[i]);
                    continue;
                }
                this.configs.get(i).setValue(keyStrokes[i]);
            }
            for (i = keyStrokes.length; i < this.configs.size(); ++i) {
                this.configs.get(i).setValue(null);
            }
        }
    }

    public NamedKeyStroke[] getKeyStrokes() {
        ArrayList<NamedKeyStroke> l = new ArrayList<NamedKeyStroke>();
        for (NamedHotKeyConfigurer hotKeyConfigurer : this.configs) {
            NamedKeyStroke value = hotKeyConfigurer.getValueNamedKeyStroke();
            if (value == null) continue;
            l.add(value);
        }
        return l.toArray(new NamedKeyStroke[0]);
    }

    public static NamedKeyStroke[] decode(String s) {
        if (s == null) {
            return null;
        }
        ArrayList<NamedKeyStroke> l = new ArrayList<NamedKeyStroke>();
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ',');
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token == "") continue;
            l.add(NamedHotKeyConfigurer.decode(token));
        }
        return l.toArray(new NamedKeyStroke[0]);
    }

    public static String encode(NamedKeyStroke[] keys) {
        if (keys == null) {
            return null;
        }
        SequenceEncoder se = new SequenceEncoder(',');
        for (NamedKeyStroke key : keys) {
            if (key.isNull()) continue;
            se.append(NamedHotKeyConfigurer.encode(key));
        }
        return se.getValue() != null ? se.getValue() : "";
    }
}

