/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.ShowHelpAction;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.SavedGameUpdater;
import VASSAL.tools.ScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SavedGameUpdaterDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private DefaultListModel<File> savedGamesModel;
    private SavedGameUpdater updater = new SavedGameUpdater();
    private Properties oldPieceInfo;
    private JFileChooser fc;
    private static final String VERSION_KEY = "moduleVerion";
    private static final String MODULE_NAME_KEY = "moduleName";
    private JButton updateButton;
    private JTextField versionField;

    public SavedGameUpdaterDialog(Frame owner) throws HeadlessException {
        super(owner, false);
        this.setTitle("Update Saved Games");
        this.initComponents();
        this.fc = new JFileChooser();
        this.fc.setCurrentDirectory(GameModule.getGameModule().getFileChooser().getCurrentDirectory());
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        Box versionBox = Box.createHorizontalBox();
        versionBox.add(new JLabel("Module version of saved games:  "));
        this.versionField = new JTextField(8);
        this.versionField.setEditable(false);
        this.versionField.setMaximumSize(new Dimension(this.versionField.getMaximumSize().width, this.versionField.getPreferredSize().height));
        versionBox.add(this.versionField);
        JButton importButton = new JButton("Import GamePiece info");
        importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SavedGameUpdaterDialog.this.importPieceInfo();
            }
        });
        versionBox.add(importButton);
        this.add(versionBox);
        JButton exportButton = new JButton("Export GamePiece info");
        exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SavedGameUpdaterDialog.this.exportPieceInfo();
            }
        });
        Box importExportBox = Box.createHorizontalBox();
        importExportBox.add(importButton);
        importExportBox.add(exportButton);
        this.add(importExportBox);
        Box savedGamesBox = Box.createHorizontalBox();
        Box left = Box.createVerticalBox();
        left.add(new JLabel("Saved Games:"));
        JButton chooseGamesButton = new JButton("Choose");
        chooseGamesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SavedGameUpdaterDialog.this.chooseSavedGames();
            }
        });
        left.add(chooseGamesButton);
        savedGamesBox.add(left);
        this.savedGamesModel = new DefaultListModel();
        JList<File> savedGamesList = new JList<File>(this.savedGamesModel);
        savedGamesList.setVisibleRowCount(5);
        savedGamesList.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText(((File)value).getName());
                return this;
            }
        });
        savedGamesBox.add(new ScrollPane(savedGamesList));
        this.add(savedGamesBox);
        Box buttonsBox = Box.createHorizontalBox();
        this.updateButton = new JButton("Update games");
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SavedGameUpdaterDialog.this.updateGames();
            }
        });
        this.updateButton.setEnabled(false);
        buttonsBox.add(this.updateButton);
        JButton helpButton = new JButton("Help");
        HelpFile hf = null;
        try {
            hf = new HelpFile(null, new File(new File(Documentation.getDocumentationBaseDir(), "ReferenceManual"), "SavedGameUpdater.htm"));
        }
        catch (MalformedURLException ex) {
            ErrorDialog.bug(ex);
        }
        helpButton.addActionListener(new ShowHelpAction(hf.getContents(), null));
        buttonsBox.add(helpButton);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SavedGameUpdaterDialog.this.dispose();
            }
        });
        buttonsBox.add(closeButton);
        this.add(buttonsBox);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void updateGames() {
        this.updateButton.setEnabled(false);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int n = SavedGameUpdaterDialog.this.savedGamesModel.size();
                for (int i = 0; i < n; ++i) {
                    try {
                        File savedGame = SavedGameUpdaterDialog.this.savedGamesModel.getElementAt(i);
                        SavedGameUpdaterDialog.this.updater.updateSavedGame(SavedGameUpdaterDialog.this.oldPieceInfo, savedGame);
                        GameModule.getGameModule().warn("Updated " + savedGame.getName() + " from version " + SavedGameUpdaterDialog.this.versionField.getText() + " to " + GameModule.getGameModule().getGameVersion());
                        continue;
                    }
                    catch (IOException e) {
                        Runnable showError = new Runnable(){

                            @Override
                            public void run() {
                                SavedGameUpdaterDialog.this.showErrorMessage(e, "Update failed", "Unable to save file");
                            }
                        };
                        try {
                            SwingUtilities.invokeAndWait(showError);
                            continue;
                        }
                        catch (InterruptedException | InvocationTargetException exception) {
                            // empty catch block
                        }
                    }
                }
                SavedGameUpdaterDialog.this.updateButton.setEnabled(true);
            }
        };
        new Thread(runnable).start();
    }

    private void chooseSavedGames() {
        File[] selectedFiles;
        this.fc.setMultiSelectionEnabled(true);
        if (1 != this.fc.showOpenDialog(this) && (selectedFiles = this.fc.getSelectedFiles()) != null) {
            this.savedGamesModel.clear();
            for (File selectedFile : selectedFiles) {
                this.savedGamesModel.addElement(selectedFile);
            }
        }
    }

    private void exportPieceInfo() {
        this.fc.setMultiSelectionEnabled(false);
        if (1 != this.fc.showSaveDialog(this)) {
            Properties p = this.updater.getPieceSlotsMap();
            p.put(MODULE_NAME_KEY, GameModule.getGameModule().getGameName());
            p.put(VERSION_KEY, GameModule.getGameModule().getGameVersion());
            try (FileOutputStream fout = new FileOutputStream(this.fc.getSelectedFile());
                 BufferedOutputStream out = new BufferedOutputStream(fout);){
                p.store(out, null);
            }
            catch (IOException e) {
                this.showErrorMessage(e, "Export failed", "Unable to write info");
            }
        }
    }

    private void importPieceInfo() {
        this.fc.setMultiSelectionEnabled(false);
        if (1 != this.fc.showOpenDialog(this)) {
            this.oldPieceInfo = new Properties();
            try (FileInputStream fin = new FileInputStream(this.fc.getSelectedFile());
                 BufferedInputStream in = new BufferedInputStream(fin);){
                this.oldPieceInfo.load(in);
                String moduleVersion = this.oldPieceInfo.getProperty(VERSION_KEY);
                String moduleName = this.oldPieceInfo.getProperty(MODULE_NAME_KEY);
                if (!GameModule.getGameModule().getGameName().equals(moduleName)) {
                    this.showErrorMessage(null, "Import failed", "Imported info is from the wrong module:  " + moduleName);
                    this.oldPieceInfo = null;
                    this.versionField.setText(null);
                } else if (GameModule.getGameModule().getGameVersion().equals(moduleVersion)) {
                    this.showErrorMessage(null, "Import failed", "Imported info is from the current version, " + moduleVersion + ".\nLoad the older version in the editor and export the GamePiece info,\nThen load this module again and import the older version's info");
                    this.oldPieceInfo = null;
                    this.versionField.setText(null);
                } else {
                    this.versionField.setText(moduleVersion);
                }
            }
            catch (IOException e) {
                this.showErrorMessage(e, "Import failed", "Unable to import info");
                this.oldPieceInfo = null;
            }
            catch (IllegalArgumentException e) {
                this.showErrorMessage(e, "Import failed", "Malformed input file");
                this.oldPieceInfo = null;
            }
        }
        this.updateButton.setEnabled(this.oldPieceInfo != null);
    }

    private void showErrorMessage(Exception e, String title, String defaultMessage) {
        String msg;
        String string = msg = e == null ? null : e.getMessage();
        if (msg == null) {
            msg = defaultMessage;
        }
        JOptionPane.showMessageDialog(this, msg, title, 0);
    }
}

