/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.MassKeyCommand;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.PropertyExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.BooleanAndPieceFilter;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.GlobalCommand;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.RangeFilter;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class CounterGlobalKeyCommand
extends Decorator
implements TranslatablePiece,
RecursionLimiter.Loopable {
    public static final String ID = "globalkey;";
    protected KeyCommand[] command;
    protected String commandName;
    protected NamedKeyStroke key;
    protected NamedKeyStroke globalKey;
    protected GlobalCommand globalCommand = new GlobalCommand(this);
    protected PropertyExpression propertiesFilter = new PropertyExpression();
    protected boolean restrictRange;
    protected boolean fixedRange = true;
    protected int range;
    protected String rangeProperty = "";
    private KeyCommand myCommand;
    protected String description;

    public CounterGlobalKeyCommand() {
        this(ID, null);
    }

    public CounterGlobalKeyCommand(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.commandName = st.nextToken("Global Command");
        this.key = st.nextNamedKeyStroke('G');
        this.globalKey = st.nextNamedKeyStroke('K');
        this.propertiesFilter.setExpression(st.nextToken(""));
        this.restrictRange = st.nextBoolean(false);
        this.range = st.nextInt(1);
        this.globalCommand.setReportSingle(st.nextBoolean(true));
        this.globalCommand.setKeyStroke(this.globalKey);
        this.fixedRange = st.nextBoolean(true);
        this.rangeProperty = st.nextToken("");
        this.description = st.nextToken("");
        this.globalCommand.setSelectFromDeck(st.nextInt(-1));
        this.command = null;
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.commandName).append(this.key).append(this.globalKey).append(this.propertiesFilter.getExpression()).append(this.restrictRange).append(this.range).append(this.globalCommand.isReportSingle()).append(this.fixedRange).append(this.rangeProperty).append(this.description).append(this.globalCommand.getSelectFromDeck());
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.command == null) {
            this.myCommand = new KeyCommand(this.commandName, this.key, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.command = this.commandName.length() > 0 && this.key != null && !this.key.isNull() ? new KeyCommand[]{this.myCommand} : new KeyCommand[0];
        }
        if (this.command.length > 0) {
            this.command[0].setEnabled(this.getMap() != null);
        }
        return this.command;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        return this.myCommand.matches(stroke) ? this.apply() : null;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public String getDescription() {
        Object d = "Global Key Command";
        if (this.description.length() > 0) {
            d = (String)d + " - " + this.description;
        }
        return d;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GlobalKeyCommand.htm");
    }

    public Command apply() {
        PieceFilter filter = this.propertiesFilter.getFilter(Decorator.getOutermost(this));
        Command c = new NullCommand();
        if (this.restrictRange) {
            int r = this.range;
            if (!this.fixedRange) {
                String rangeValue = (String)Decorator.getOutermost(this).getProperty(this.rangeProperty);
                try {
                    r = Integer.parseInt(rangeValue);
                }
                catch (NumberFormatException e) {
                    CounterGlobalKeyCommand.reportDataError(this, Resources.getString("Error.non_number_error"), "range[" + this.rangeProperty + "]=" + rangeValue, e);
                }
            }
            filter = new BooleanAndPieceFilter(filter, new RangeFilter(this.getMap(), this.getPosition(), r));
        }
        for (Map m : Map.getMapList()) {
            c = c.append(this.globalCommand.apply(m, filter));
        }
        return c;
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.commandName, this.getCommandDescription(this.description, "Command name"));
    }

    @Override
    public String getComponentName() {
        return this.piece.getName();
    }

    @Override
    public String getComponentTypeName() {
        return this.getDescription();
    }

    public static class Ed
    implements PieceEditor {
        protected StringConfigurer nameInput;
        protected NamedHotKeyConfigurer keyInput;
        protected NamedHotKeyConfigurer globalKey;
        protected PropertyExpressionConfigurer propertyMatch;
        protected MassKeyCommand.DeckPolicyConfig deckPolicy;
        protected BooleanConfigurer suppress;
        protected BooleanConfigurer restrictRange;
        protected BooleanConfigurer fixedRange;
        protected IntConfigurer range;
        protected StringConfigurer rangeProperty;
        protected StringConfigurer descInput;
        protected JPanel controls;

        public Ed(CounterGlobalKeyCommand p) {
            PropertyChangeListener pl = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean isRange = Boolean.TRUE.equals(restrictRange.getValue());
                    boolean isFixed = Boolean.TRUE.equals(fixedRange.getValue());
                    range.getControls().setVisible(isRange && isFixed);
                    fixedRange.getControls().setVisible(isRange);
                    rangeProperty.getControls().setVisible(isRange && !isFixed);
                    Window w = SwingUtilities.getWindowAncestor(range.getControls());
                    if (w != null) {
                        w.pack();
                    }
                }
            };
            this.controls = new JPanel();
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.descInput = new StringConfigurer(null, "Description:  ", p.description);
            this.controls.add(this.descInput.getControls());
            this.nameInput = new StringConfigurer(null, "Command name:  ", p.commandName);
            this.controls.add(this.nameInput.getControls());
            this.keyInput = new NamedHotKeyConfigurer(null, "Keyboard Command:  ", p.key);
            this.controls.add(this.keyInput.getControls());
            this.globalKey = new NamedHotKeyConfigurer(null, "Global Key Command:  ", p.globalKey);
            this.controls.add(this.globalKey.getControls());
            this.propertyMatch = new PropertyExpressionConfigurer(null, "Matching Properties:  ", p.propertiesFilter);
            this.controls.add(this.propertyMatch.getControls());
            this.deckPolicy = new MassKeyCommand.DeckPolicyConfig();
            this.deckPolicy.setValue(p.globalCommand.getSelectFromDeck());
            this.controls.add(this.deckPolicy.getControls());
            this.restrictRange = new BooleanConfigurer(null, "Restrict Range?", p.restrictRange);
            this.controls.add(this.restrictRange.getControls());
            this.restrictRange.addPropertyChangeListener(pl);
            this.fixedRange = new BooleanConfigurer(null, "Fixed Range?", p.fixedRange);
            this.controls.add(this.fixedRange.getControls());
            this.fixedRange.addPropertyChangeListener(pl);
            this.range = new IntConfigurer(null, "Range:  ", (Integer)p.range);
            this.controls.add(this.range.getControls());
            this.rangeProperty = new StringConfigurer(null, "Range Property:  ", p.rangeProperty);
            this.controls.add(this.rangeProperty.getControls());
            this.suppress = new BooleanConfigurer(null, "Suppress individual reports?", p.globalCommand.isReportSingle());
            this.controls.add(this.suppress.getControls());
            pl.propertyChange(null);
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.nameInput.getValueString()).append(this.keyInput.getValueString()).append(this.globalKey.getValueString()).append(this.propertyMatch.getValueString()).append(this.restrictRange.getValueString()).append(this.range.getValueString()).append(this.suppress.booleanValue()).append(this.fixedRange.booleanValue()).append(this.rangeProperty.getValueString()).append(this.descInput.getValueString()).append(this.deckPolicy.getIntValue());
            return CounterGlobalKeyCommand.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }
}

