/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.Map;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.Stack;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.Sort;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;

public class DragBuffer {
    private static final DragBuffer THE_BUFFER = new DragBuffer();
    private final List<GamePiece> pieces = new ArrayList<GamePiece>();
    private MouseEvent lastRelease;
    private Component dropTarget;
    private MouseListener dropHandler;
    private Map dragFromMap;

    private DragBuffer() {
    }

    public static DragBuffer getBuffer() {
        return THE_BUFFER;
    }

    public void add(GamePiece p) {
        if (p != null && !this.pieces.contains(p) && !Boolean.TRUE.equals(p.getProperty("RestrictedMovement"))) {
            if (p instanceof Stack) {
                for (GamePiece gamePiece : ((Stack)p).asList()) {
                    if (!Boolean.TRUE.equals(gamePiece.getProperty("RestrictedMovement"))) continue;
                    return;
                }
            }
            this.pieces.add(p);
            this.dragFromMap = p.getMap();
        }
    }

    public Map getFromMap() {
        return this.dragFromMap;
    }

    public void clear() {
        this.pieces.clear();
    }

    public void addDragSource(Component c) {
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DragBuffer.this.lastRelease = null;
                DragBuffer.this.dropTarget = null;
                DragBuffer.this.dropHandler = null;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                e.getComponent().setCursor(null);
                Component source = (Component)e.getSource();
                e.translatePoint(source.getLocationOnScreen().x, source.getLocationOnScreen().y);
                if (DragBuffer.this.dropTarget == null) {
                    DragBuffer.this.lastRelease = e;
                } else {
                    e.translatePoint(-DragBuffer.this.dropTarget.getLocationOnScreen().x, -DragBuffer.this.dropTarget.getLocationOnScreen().y);
                    DragBuffer.this.dropHandler.mouseReleased(e);
                }
            }
        });
    }

    public void addDropTarget(Component c, final MouseListener l) {
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                Component source = (Component)e.getSource();
                if (source.isShowing()) {
                    if (DragBuffer.this.lastRelease != null) {
                        e.translatePoint(source.getLocationOnScreen().x, source.getLocationOnScreen().y);
                        if (DragBuffer.this.isCloseEnough(e.getPoint(), DragBuffer.this.lastRelease.getPoint())) {
                            e.translatePoint(-source.getLocationOnScreen().x, -source.getLocationOnScreen().y);
                            l.mouseReleased(e);
                        }
                    } else {
                        DragBuffer.this.dropTarget = source;
                        DragBuffer.this.dropHandler = l;
                    }
                }
            }
        });
    }

    private boolean isCloseEnough(Point p1, Point p2) {
        return Math.abs(p1.x - p2.x) < 3 && Math.abs(p1.y - p2.y) < 3;
    }

    public void remove(GamePiece p) {
        this.pieces.remove(p);
    }

    public boolean contains(GamePiece p) {
        return this.pieces.contains(p);
    }

    public boolean containsAllMembers(Stack s) {
        List<GamePiece> members = s.asList();
        for (GamePiece p : members) {
            if (this.contains(p)) continue;
            return false;
        }
        return true;
    }

    public List<GamePiece> asList() {
        return Collections.unmodifiableList(this.pieces);
    }

    public PieceIterator getIterator() {
        return new PieceIterator(this.pieces.iterator());
    }

    public boolean isEmpty() {
        return this.pieces.isEmpty();
    }

    public String contents() {
        String s = "";
        Iterator<GamePiece> i = this.pieces.iterator();
        while (i.hasNext()) {
            s = s.concat(i.next().getName());
            if (!i.hasNext()) continue;
            s = s.concat(",");
        }
        return s;
    }

    public static void main(String[] args) {
        JFrame f1 = new JFrame();
        f1.setSize(200, 200);
        f1.setVisible(true);
        JFrame f2 = new JFrame();
        f2.setSize(200, 200);
        f2.setLocation(200, 0);
        f2.setVisible(true);
        MouseAdapter l = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                evt.translatePoint(((JFrame)evt.getSource()).getLocationOnScreen().x, ((JFrame)evt.getSource()).getLocationOnScreen().y);
                System.err.println("Press at " + evt.getPoint());
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                System.err.println("Release at " + evt.getPoint());
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                evt.translatePoint(((JFrame)evt.getSource()).getLocationOnScreen().x, ((JFrame)evt.getSource()).getLocationOnScreen().y);
                System.err.println("Enter at " + evt.getPoint());
            }
        };
        DragBuffer.getBuffer().addDragSource(f1);
        DragBuffer.getBuffer().addDropTarget(f2, l);
    }

    public Cursor createDragCursor(Component comp) {
        Cursor c = null;
        if (!this.pieces.isEmpty()) {
            c = Cursor.getPredefinedCursor(12);
        }
        return c;
    }

    public void sort(Comparator<GamePiece> comp) {
        this.pieces.sort(comp);
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public void sort(Sort.Comparator comp) {
        ProblemDialog.showDeprecated("2020-08-06");
        this.sort((Comparator)((Object)comp));
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public static void init(DragBuffer db) {
        ProblemDialog.showDeprecated("2020-08-06");
    }
}

