/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.EventFilter;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.KeyStroke;

public class Immobilized
extends Decorator
implements EditablePiece {
    public static final String ID = "immob;";
    protected boolean shiftToSelect = false;
    protected boolean altToSelect = false;
    protected boolean ignoreGrid = false;
    protected boolean neverSelect = false;
    protected boolean neverMove = false;
    protected boolean moveIfSelected = false;
    protected boolean neverBandSelect = false;
    protected boolean altToBandSelect = false;
    protected EventFilter selectFilter;
    protected EventFilter moveFilter;
    protected EventFilter bandselectFilter;
    protected static final char MOVE_SELECTED = 'I';
    protected static final char MOVE_NORMAL = 'N';
    protected static final char NEVER_MOVE = 'V';
    protected static final char IGNORE_GRID = 'g';
    protected static final char SHIFT_SELECT = 'i';
    protected static final char ALT_SELECT = 'c';
    protected static final char NEVER_SELECT = 'n';
    protected static final char NEVER_BAND_SELECT = 'Z';
    protected static final char ALT_BAND_SELECT = 'A';
    protected static EventFilter NEVER = new EventFilter(){

        @Override
        public boolean rejectEvent(InputEvent evt) {
            return true;
        }
    };

    public Immobilized() {
        this(ID, null);
    }

    @Deprecated
    public Immobilized(GamePiece p, String type) {
        this(type, p);
    }

    public Immobilized(String type, GamePiece p) {
        this.setInner(p);
        this.mySetType(type);
    }

    @Override
    public void mySetType(String type) {
        this.shiftToSelect = false;
        this.altToSelect = false;
        this.neverSelect = false;
        this.ignoreGrid = false;
        this.neverMove = false;
        this.moveIfSelected = false;
        this.neverBandSelect = false;
        this.altToBandSelect = false;
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        String selectionOptions = st.nextToken("");
        String movementOptions = st.nextToken("");
        if (selectionOptions.indexOf(105) >= 0) {
            this.shiftToSelect = true;
            this.moveIfSelected = true;
        }
        if (selectionOptions.indexOf(99) >= 0) {
            this.altToSelect = true;
            this.moveIfSelected = true;
        }
        if (selectionOptions.indexOf(110) >= 0) {
            this.neverSelect = true;
            this.neverMove = true;
        }
        if (selectionOptions.indexOf(103) >= 0) {
            this.ignoreGrid = true;
        }
        if (selectionOptions.indexOf(65) >= 0) {
            this.altToBandSelect = true;
        }
        if (selectionOptions.indexOf(90) >= 0) {
            this.neverBandSelect = true;
        }
        if (movementOptions.length() > 0) {
            switch (movementOptions.charAt(0)) {
                case 'V': {
                    this.neverMove = true;
                    this.moveIfSelected = false;
                    break;
                }
                case 'I': {
                    this.neverMove = false;
                    this.moveIfSelected = true;
                    break;
                }
                default: {
                    this.neverMove = false;
                    this.moveIfSelected = false;
                }
            }
        }
        this.selectFilter = this.neverSelect ? NEVER : (this.shiftToSelect ? new UseShift() : (this.altToSelect ? new UseAlt() : null));
        this.moveFilter = this.neverMove ? NEVER : (this.moveIfSelected ? new MoveIfSelected() : null);
        this.bandselectFilter = this.neverBandSelect ? NEVER : (this.altToBandSelect ? new UseAlt() : null);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public KeyCommand[] myGetKeyCommands() {
        return new KeyCommand[0];
    }

    @Override
    public Command myKeyEvent(KeyStroke e) {
        return null;
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if ("NoStack".equals(key)) {
            return Boolean.TRUE;
        }
        if ("Immobile".equals(key)) {
            return this.moveIfSelected || this.neverMove;
        }
        if ("IgnoreGrid".equals(key)) {
            return this.ignoreGrid;
        }
        if ("selectEventFilter".equals(key)) {
            return this.selectFilter;
        }
        if ("moveEventFilter".equals(key)) {
            return this.moveFilter;
        }
        if ("cannotMove".equals(key)) {
            return this.neverMove;
        }
        if ("bandSelectEventFilter".equals(key)) {
            return this.bandselectFilter;
        }
        return super.getLocalizedProperty(key);
    }

    @Override
    public Object getProperty(Object key) {
        if ("NoStack".equals(key)) {
            return Boolean.TRUE;
        }
        if ("Immobile".equals(key)) {
            return this.moveIfSelected || this.neverMove;
        }
        if ("IgnoreGrid".equals(key)) {
            return this.ignoreGrid;
        }
        if ("selectEventFilter".equals(key)) {
            return this.selectFilter;
        }
        if ("moveEventFilter".equals(key)) {
            return this.moveFilter;
        }
        if ("cannotMove".equals(key)) {
            return this.neverMove;
        }
        if ("bandSelectEventFilter".equals(key)) {
            return this.bandselectFilter;
        }
        return super.getProperty(key);
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String myGetType() {
        StringBuilder buffer = new StringBuilder(ID);
        if (this.neverSelect) {
            buffer.append('n');
        } else if (this.shiftToSelect) {
            buffer.append('i');
        } else if (this.altToSelect) {
            buffer.append('c');
        }
        if (this.ignoreGrid) {
            buffer.append('g');
        }
        if (this.neverBandSelect) {
            buffer.append('Z');
        } else if (this.altToBandSelect) {
            buffer.append('A');
        }
        buffer.append(';');
        if (this.neverMove) {
            buffer.append('V');
        } else if (this.moveIfSelected) {
            buffer.append('I');
        } else {
            buffer.append('N');
        }
        return buffer.toString();
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public void mySetState(String s) {
    }

    @Override
    public String getDescription() {
        return "Does not stack";
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("NonStacking.htm");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("Immobile");
        l.add("IgnoreGrid");
        l.add("cannotMove");
        return l;
    }

    public class UseShift
    implements EventFilter {
        @Override
        public boolean rejectEvent(InputEvent evt) {
            return !evt.isShiftDown() && !Boolean.TRUE.equals(Immobilized.this.getProperty("Selected"));
        }
    }

    public class UseAlt
    implements EventFilter {
        @Override
        public boolean rejectEvent(InputEvent evt) {
            return !evt.isAltDown() && !Boolean.TRUE.equals(Immobilized.this.getProperty("Selected"));
        }
    }

    protected class MoveIfSelected
    implements EventFilter {
        protected MoveIfSelected() {
        }

        @Override
        public boolean rejectEvent(InputEvent evt) {
            return !Boolean.TRUE.equals(Immobilized.this.getProperty("Selected"));
        }
    }

    private static class Ed
    implements PieceEditor {
        private JComboBox<String> selectionOption = new JComboBox();
        private JComboBox<String> movementOption;
        private JComboBox<String> bandSelectOption;
        private JCheckBox ignoreGridBox;
        private Box controls;

        public Ed(Immobilized p) {
            this.selectionOption.addItem("normally");
            this.selectionOption.addItem("when shift-key down");
            this.selectionOption.addItem("when alt-key down");
            this.selectionOption.addItem("never");
            if (p.neverSelect) {
                this.selectionOption.setSelectedIndex(3);
            } else if (p.altToSelect) {
                this.selectionOption.setSelectedIndex(2);
            } else if (p.shiftToSelect) {
                this.selectionOption.setSelectedIndex(1);
            } else {
                this.selectionOption.setSelectedIndex(0);
            }
            this.ignoreGridBox = new JCheckBox("Ignore map grid when moving?");
            this.ignoreGridBox.setSelected(p.ignoreGrid);
            this.controls = Box.createVerticalBox();
            Box b = Box.createHorizontalBox();
            b.add(new JLabel("Select piece:  "));
            b.add(this.selectionOption);
            this.controls.add(b);
            this.bandSelectOption = new JComboBox();
            this.bandSelectOption.addItem("normally");
            this.bandSelectOption.addItem("when alt-key down");
            this.bandSelectOption.addItem("never");
            if (p.neverBandSelect) {
                this.bandSelectOption.setSelectedIndex(2);
            } else if (p.altToBandSelect) {
                this.bandSelectOption.setSelectedIndex(1);
            } else {
                this.bandSelectOption.setSelectedIndex(0);
            }
            b = Box.createHorizontalBox();
            b.add(new JLabel("Band-Select piece:  "));
            b.add(this.bandSelectOption);
            this.controls.add(b);
            this.movementOption = new JComboBox();
            this.movementOption.addItem("normally");
            this.movementOption.addItem("only if selected");
            this.movementOption.addItem("never");
            if (p.neverMove) {
                this.movementOption.setSelectedIndex(2);
            } else if (p.moveIfSelected) {
                this.movementOption.setSelectedIndex(1);
            } else {
                this.movementOption.setSelectedIndex(0);
            }
            b = Box.createHorizontalBox();
            b.add(new JLabel("Move piece:  "));
            b.add(this.movementOption);
            this.controls.add(b);
            this.controls.add(this.ignoreGridBox);
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            Object s = Immobilized.ID;
            switch (this.selectionOption.getSelectedIndex()) {
                case 1: {
                    s = (String)s + "i";
                    break;
                }
                case 2: {
                    s = (String)s + "c";
                    break;
                }
                case 3: {
                    s = (String)s + "n";
                }
            }
            if (this.ignoreGridBox.isSelected()) {
                s = (String)s + "g";
            }
            switch (this.bandSelectOption.getSelectedIndex()) {
                case 1: {
                    s = (String)s + "A";
                    break;
                }
                case 2: {
                    s = (String)s + "Z";
                }
            }
            s = (String)s + ";";
            switch (this.movementOption.getSelectedIndex()) {
                case 0: {
                    s = (String)s + "N";
                    break;
                }
                case 1: {
                    s = (String)s + "I";
                    break;
                }
                case 2: {
                    s = (String)s + "V";
                }
            }
            return s;
        }

        @Override
        public Component getControls() {
            return this.controls;
        }
    }
}

