/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.GameModule;
import VASSAL.configure.IntConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ScrollPane;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class AdjustableSpeedScrollPane
extends ScrollPane {
    private static final long serialVersionUID = 1L;
    private static final String SCROLL_SPEED = "scrollSpeed";
    private static final int defaultSpeed = 50;

    public AdjustableSpeedScrollPane(Component view) {
        this(view, 20, 30);
    }

    public AdjustableSpeedScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
        IntConfigurer config = new IntConfigurer(SCROLL_SPEED, Resources.getString("AdjustableSpeedScrollPane.scroll_increment"), (Integer)50);
        config.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (AdjustableSpeedScrollPane.SCROLL_SPEED.equals(e.getPropertyName())) {
                    AdjustableSpeedScrollPane.this.setSpeed((Integer)e.getNewValue());
                }
            }
        });
        GameModule g = GameModule.getGameModule();
        if (g == null) {
            this.setSpeed(50);
        } else {
            Prefs prefs = g.getPrefs();
            prefs.addOption(Resources.getString("Prefs.general_tab"), config);
            this.setSpeed((Integer)prefs.getValue(SCROLL_SPEED));
        }
    }

    private void setSpeed(int speed) {
        this.verticalScrollBar.setUnitIncrement(speed);
        this.horizontalScrollBar.setUnitIncrement(speed);
    }
}

