/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.counters.EditablePiece;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.ExpressionException;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import java.util.HashMap;
import java.util.Map;

public class FormattedString
implements RecursionLimiter.Loopable {
    protected String formatString;
    protected Expression format;
    protected Map<String, String> props = new HashMap<String, String>();
    protected PropertySource defaultProperties;

    @Override
    public String getComponentTypeName() {
        return "FormattedString";
    }

    @Override
    public String getComponentName() {
        return "FormattedString";
    }

    public FormattedString() {
        this("");
    }

    public FormattedString(String s) {
        this(s, GameModule.getGameModule());
    }

    public FormattedString(PropertySource defaultProperties) {
        this("", defaultProperties);
    }

    public FormattedString(String formatString, PropertySource defaultProperties) {
        this.setFormat(formatString);
        this.defaultProperties = defaultProperties;
    }

    public void setFormat(String s) {
        this.formatString = s;
        this.format = Expression.createExpression(s);
    }

    public String getFormat() {
        return this.formatString;
    }

    public void setProperty(String name, String value) {
        this.props.put(name, value);
    }

    public void clearProperties() {
        this.props.clear();
    }

    public String getText() {
        return this.getText(this.defaultProperties, false);
    }

    public String getLocalizedText() {
        return this.getText(this.defaultProperties, true);
    }

    public String getText(PropertySource ps) {
        return this.getText(ps, false);
    }

    public String getText(PropertySource ps, String def) {
        String s = this.getText(ps, false);
        if (s == null || s.length() == 0) {
            s = def;
        }
        return s;
    }

    public String getLocalizedText(PropertySource ps) {
        return this.getText(ps, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getText(PropertySource ps, boolean localized) {
        PropertySource source = ps == null ? this.defaultProperties : ps;
        try {
            RecursionLimiter.startExecution(this);
            try {
                String string = this.format.evaluate(source, this.props, localized);
                return string;
            }
            catch (ExpressionException e) {
                String string;
                try {
                    if (source instanceof EditablePiece) {
                        ErrorDialog.dataWarning(new BadDataReport((EditablePiece)source, Resources.getString("Error.expression_error"), this.format.getExpression(), (Throwable)e));
                    } else if (source instanceof AbstractConfigurable) {
                        ErrorDialog.dataWarning(new BadDataReport((AbstractConfigurable)((Object)source), Resources.getString("Error.expression_error"), this.format.getExpression(), (Throwable)e));
                    } else {
                        ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Error.expression_error"), this.format.getExpression(), e));
                    }
                    string = "";
                }
                catch (RecursionLimitException e2) {
                    ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Error.possible_infinite_string_loop"), this.format.getExpression(), e2));
                    String string2 = "";
                    return string2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                RecursionLimiter.endExecution();
                return string;
            }
        }
        finally {
            RecursionLimiter.endExecution();
        }
    }

    public int getTextAsInt(PropertySource ps, String description, EditablePiece source) {
        int result = 0;
        String value = this.getText(ps, "0");
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            ErrorDialog.dataWarning(new BadDataReport(source, Resources.getString("Error.non_number_error"), FormattedString.debugInfo(this, value, description), (Throwable)e));
        }
        return result;
    }

    public int getTextAsInt(PropertySource ps, String description, AbstractConfigurable source) {
        int result = 0;
        String value = this.getText(ps, "0");
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            ErrorDialog.dataWarning(new BadDataReport(source, Resources.getString("Error.non_number_error"), FormattedString.debugInfo(this, value, description), (Throwable)e));
        }
        return result;
    }

    public static String debugInfo(FormattedString format, String value, String description) {
        return description + (String)(value.equals(format.getFormat()) ? "" : "[" + format.getFormat() + "]") + "=" + value;
    }

    public String debugInfo(String value, String description) {
        return FormattedString.debugInfo(this, value, description);
    }

    public PropertySource getDefaultProperties() {
        return this.defaultProperties;
    }

    public void setDefaultProperties(PropertySource defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.formatString == null ? 0 : this.formatString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FormattedString other = (FormattedString)obj;
        return !(this.formatString == null ? other.formatString != null : !this.formatString.equals(other.formatString));
    }
}

