/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board;

import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridContainer;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridNumbering;
import VASSAL.build.module.map.boardPicker.board.mapgrid.RegularGridNumbering;
import VASSAL.i18n.Resources;
import VASSAL.tools.AdjustableSpeedScrollPane;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.lang3.SystemUtils;

public abstract class GridEditor
extends JDialog
implements MouseListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    protected static final String SET = Resources.getString("Editor.GridEditor.set_grid_shape");
    protected static final String CANCEL = Resources.getString("General.cancel");
    protected static final String CANCEL_SET = Resources.getString("Editor.GridEditor.cancel_set");
    protected static final String OK = Resources.getString("General.save");
    protected static final String NUMBERING = Resources.getString("Editor.GridEditor.numbering");
    protected EditableGrid grid;
    protected Board board;
    protected JPanel view;
    protected JScrollPane scroll;
    protected boolean setMode;
    protected Point hp1;
    protected Point hp2;
    protected Point hp3;
    protected JButton okButton;
    protected JButton canSetButton;
    protected JButton setButton;
    protected JButton numberingButton;
    protected boolean saveGridVisible;
    protected boolean saveNumberingVisible;
    protected double saveDx;
    protected double saveDy;
    protected Point saveOrigin;
    protected static final int DELTA = 1;
    protected static final double DDELTA = 0.1;
    protected static final int FAST = 5;
    protected static final int ERROR_MARGIN = 5;

    public GridEditor(EditableGrid grid) {
        this.setTitle(Resources.getString("Editor.ModuleEditor.edit", grid.getGridName()));
        this.setModal(true);
        this.grid = grid;
        GridContainer container = grid.getContainer();
        if (container != null) {
            this.board = container.getBoard();
        }
        this.saveGridVisible = grid.isVisible();
        if (grid.getGridNumbering() != null) {
            this.saveNumberingVisible = grid.getGridNumbering().isVisible();
        }
        this.saveDx = grid.getDx();
        this.saveDy = grid.getDy();
        this.saveOrigin = grid.getOrigin();
        this.initComponents();
    }

    protected void initComponents() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                GridEditor.this.cancel();
            }
        });
        this.view = new GridPanel(this.board);
        this.view.addMouseListener(this);
        this.view.addKeyListener(this);
        this.view.setFocusable(true);
        this.scroll = new AdjustableSpeedScrollPane(this.view, 22, 32);
        this.scroll.setPreferredSize(new Dimension(800, 600));
        this.add((Component)this.scroll, "Center");
        Box textPanel = Box.createVerticalBox();
        textPanel.add(new JLabel(Resources.getString("Editor.GridEditor.arrow_keys")));
        textPanel.add(new JLabel(SystemUtils.IS_OS_MAC_OSX ? Resources.getString("Editor.GridEditor.command_arrow_keys") : Resources.getString("Editor.GridEditor.control_arrow_keys")));
        textPanel.add(new JLabel(Resources.getString("Editor.GridEditor.shift_key")));
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton(OK);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridEditor.this.cancelSetMode();
                GridEditor.this.setVisible(false);
            }
        });
        buttonPanel.add(this.okButton);
        JButton canButton = new JButton(CANCEL);
        canButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridEditor.this.cancel();
            }
        });
        buttonPanel.add(canButton);
        this.setButton = new JButton(SET);
        this.setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridEditor.this.startSetMode();
            }
        });
        this.setButton.setRequestFocusEnabled(false);
        buttonPanel.add(this.setButton);
        this.canSetButton = new JButton(CANCEL_SET);
        this.canSetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridEditor.this.cancelSetMode();
            }
        });
        this.canSetButton.setVisible(false);
        this.canSetButton.setRequestFocusEnabled(false);
        buttonPanel.add(this.canSetButton);
        this.numberingButton = new JButton(NUMBERING);
        this.numberingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((RegularGridNumbering)GridEditor.this.grid.getGridNumbering()).setAttribute("visible", !GridEditor.this.grid.getGridNumbering().isVisible());
                GridEditor.this.repaint();
            }
        });
        this.numberingButton.setEnabled(this.grid.getGridNumbering() != null);
        this.numberingButton.setVisible(true);
        this.numberingButton.setRequestFocusEnabled(false);
        buttonPanel.add(this.numberingButton);
        Box controlPanel = Box.createVerticalBox();
        controlPanel.add(textPanel);
        controlPanel.add(buttonPanel);
        this.add((Component)controlPanel, "South");
        this.scroll.revalidate();
        this.pack();
        this.repaint();
    }

    protected void cancel() {
        this.cancelSetMode();
        this.grid.setDx(this.saveDx);
        this.grid.setDy(this.saveDy);
        this.grid.setOrigin(this.saveOrigin);
        this.setVisible(false);
    }

    protected void cancelSetMode() {
        this.canSetButton.setVisible(false);
        this.setButton.setVisible(true);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        this.setMode = false;
        this.grid.setVisible(this.saveGridVisible);
        if (this.grid.getGridNumbering() != null && this.saveNumberingVisible) {
            ((RegularGridNumbering)this.grid.getGridNumbering()).setAttribute("visible", this.saveNumberingVisible);
        }
        this.repaint();
    }

    protected void startSetMode() {
        this.hp1 = null;
        this.hp2 = null;
        this.hp3 = null;
        this.setMode = true;
        this.canSetButton.setVisible(true);
        this.setButton.setVisible(false);
        this.view.setCursor(Cursor.getPredefinedCursor(1));
        this.grid.setVisible(false);
        JOptionPane.showMessageDialog(null, Resources.getString("Editor.GridEditor.click_on_3"));
        this.repaint();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.setMode) {
            return;
        }
        boolean sideways = this.grid.isSideways();
        switch (e.getKeyCode()) {
            case 38: {
                if (SwingUtils.isModifierKeyDown(e)) {
                    if (sideways) {
                        this.adjustDx(-1, e);
                        break;
                    }
                    this.adjustDy(-1, e);
                    break;
                }
                if (sideways) {
                    this.adjustX0(-1, e);
                    break;
                }
                this.adjustY0(-1, e);
                break;
            }
            case 40: {
                if (SwingUtils.isModifierKeyDown(e)) {
                    if (sideways) {
                        this.adjustDx(1, e);
                        break;
                    }
                    this.adjustDy(1, e);
                    break;
                }
                if (sideways) {
                    this.adjustX0(1, e);
                    break;
                }
                this.adjustY0(1, e);
                break;
            }
            case 37: {
                if (SwingUtils.isModifierKeyDown(e)) {
                    if (sideways) {
                        this.adjustDy(-1, e);
                        break;
                    }
                    this.adjustDx(-1, e);
                    break;
                }
                if (sideways) {
                    this.adjustY0(-1, e);
                    break;
                }
                this.adjustX0(-1, e);
                break;
            }
            case 39: {
                if (SwingUtils.isModifierKeyDown(e)) {
                    if (sideways) {
                        this.adjustDy(1, e);
                        break;
                    }
                    this.adjustDx(1, e);
                    break;
                }
                if (sideways) {
                    this.adjustY0(1, e);
                    break;
                }
                this.adjustX0(1, e);
                break;
            }
            default: {
                return;
            }
        }
        this.repaint();
        e.consume();
    }

    public void rebuild() {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.rebuild();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.setMode) {
            if (this.hp1 == null) {
                this.hp1 = e.getPoint();
            } else if (this.hp2 == null) {
                this.hp2 = e.getPoint();
            } else if (this.hp3 == null) {
                this.hp3 = e.getPoint();
                this.calculate();
                this.cancelSetMode();
            }
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    protected void adjustX0(int direction, KeyEvent e) {
        int delta = direction * 1;
        if (e.isShiftDown()) {
            delta *= 5;
        }
        Point p = this.grid.getOrigin();
        this.setNewOrigin(new Point(p.x + delta, p.y));
    }

    protected void adjustY0(int direction, KeyEvent e) {
        int delta = direction * 1;
        if (e.isShiftDown()) {
            delta *= 5;
        }
        Point p = this.grid.getOrigin();
        this.setNewOrigin(new Point(p.x, p.y + delta));
    }

    protected void adjustDx(int direction, KeyEvent e) {
        double delta = (double)direction * 0.1;
        if (e.isShiftDown()) {
            delta *= 5.0;
        }
        this.grid.setDx(this.grid.getDx() + delta);
    }

    protected void adjustDy(int direction, KeyEvent e) {
        double delta = (double)direction * 0.1;
        if (e.isShiftDown()) {
            delta *= 5.0;
        }
        this.grid.setDy(this.grid.getDy() + delta);
    }

    protected void setNewOrigin(Point p) {
        int width = (int)Math.round(this.grid.getDx());
        int height = (int)Math.round(this.grid.getDy());
        if (p.x < -width) {
            p.x += width;
        } else if (p.x > width) {
            p.x -= width;
        }
        if (p.y < -height) {
            p.y += height;
        } else if (p.y > height) {
            p.y -= height;
        }
        this.grid.setOrigin(p);
    }

    protected boolean isHorizontal(Point p1, Point p2) {
        return Math.abs(p2.y - p1.y) <= 5;
    }

    protected boolean isVertical(Point p1, Point p2) {
        return Math.abs(p2.x - p1.x) <= 5;
    }

    protected boolean isPerpendicular(Point p1, Point p2) {
        return this.isHorizontal(p1, p2) || this.isVertical(p1, p2);
    }

    protected void reportShapeError() {
        JOptionPane.showMessageDialog(null, Resources.getString("Editor.GridEditor.does_not_look", this.grid.getGridName()), Resources.getString("Editor.GridEditor.grid_shape_error"), 0);
    }

    public abstract void calculate();

    public static interface EditableGrid {
        public double getDx();

        public double getDy();

        public Point getOrigin();

        public void setDx(double var1);

        public void setDy(double var1);

        public void setOrigin(Point var1);

        public boolean isSideways();

        public void setSideways(boolean var1);

        public GridContainer getContainer();

        public GridNumbering getGridNumbering();

        public boolean isVisible();

        public void setVisible(boolean var1);

        public String getGridName();
    }

    protected class GridPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected Board board;

        public GridPanel() {
            this.setFocusTraversalKeysEnabled(false);
        }

        public GridPanel(Board b) {
            this();
            this.setBoard(b);
        }

        public void setBoard(Board b) {
            this.board = b;
            this.setSize(this.board.getSize());
            this.setPreferredSize(this.board.getSize());
        }

        public Board getBoard() {
            return this.board;
        }

        @Override
        public void paint(Graphics g) {
            if (this.board != null) {
                Graphics2D g2d = (Graphics2D)g;
                double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
                AffineTransform orig_t = g2d.getTransform();
                g2d.setTransform(SwingUtils.descaleTransform(orig_t));
                Rectangle b = this.getVisibleRect();
                b.x = (int)((double)b.x * os_scale);
                b.y = (int)((double)b.y * os_scale);
                b.width = (int)((double)b.width * os_scale);
                b.height = (int)((double)b.height * os_scale);
                g.clearRect(b.x, b.y, b.width, b.height);
                this.board.draw(g, 0, 0, os_scale, this);
                g2d.setTransform(orig_t);
                if (GridEditor.this.setMode) {
                    this.highlight(g, GridEditor.this.hp1);
                    this.highlight(g, GridEditor.this.hp2);
                    this.highlight(g, GridEditor.this.hp3);
                }
            } else {
                super.paint(g);
            }
        }

        protected void highlight(Graphics g, Point p) {
            int r1 = 3;
            int r2 = 10;
            if (p != null) {
                g.setColor(Color.red);
                g.fillOval(p.x - 1, p.y - 1, 3, 3);
                g.drawOval(p.x - 5, p.y - 5, 10, 10);
            }
        }

        @Override
        public boolean isFocusable() {
            return true;
        }
    }
}

