/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board.mapgrid;

import VASSAL.build.Buildable;
import VASSAL.build.module.map.boardPicker.board.SquareGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.RegularGridNumbering;
import VASSAL.tools.image.LabelUtils;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SquareGridNumbering
extends RegularGridNumbering {
    private SquareGrid grid;

    @Override
    public void addTo(Buildable parent) {
        this.grid = (SquareGrid)parent;
        this.grid.setGridNumbering(this);
    }

    @Override
    protected JComponent getGridVisualizer() {
        if (this.visualizer == null) {
            this.visualizer = new JPanel(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paint(Graphics g) {
                    Graphics2D g2d = (Graphics2D)g;
                    double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
                    AffineTransform orig_t = g2d.getTransform();
                    g2d.setTransform(SwingUtils.descaleTransform(orig_t));
                    Rectangle bounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                    bounds.x = (int)((double)bounds.x * os_scale);
                    bounds.y = (int)((double)bounds.y * os_scale);
                    bounds.width = (int)((double)bounds.width * os_scale);
                    bounds.height = (int)((double)bounds.height * os_scale);
                    g.clearRect(0, 0, bounds.width, bounds.height);
                    SquareGridNumbering.this.grid.forceDraw(g, bounds, bounds, os_scale, false);
                    SquareGridNumbering.this.forceDraw(g, bounds, bounds, os_scale, false);
                    g2d.setTransform(orig_t);
                }

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(3 * (int)SquareGridNumbering.this.grid.getDx(), 3 * (int)SquareGridNumbering.this.grid.getDy());
                }
            };
        }
        return this.visualizer;
    }

    @Override
    public void draw(Graphics g, Rectangle bounds, Rectangle visibleRect, double scale, boolean reversed) {
        if (this.visible) {
            this.forceDraw(g, bounds, visibleRect, scale, reversed);
        }
    }

    public void forceDraw(Graphics g, Rectangle bounds, Rectangle visibleRect, double scale, boolean reversed) {
        int size = (int)(scale * (double)this.fontSize + 0.5);
        if (size < 5 || !bounds.intersects(visibleRect)) {
            return;
        }
        Rectangle region = bounds.intersection(visibleRect);
        Shape oldClip = g.getClip();
        if (oldClip != null) {
            Area clipArea = new Area(oldClip);
            clipArea.intersect(new Area(region));
            g.setClip(clipArea);
        }
        double deltaX = scale * this.grid.getDx();
        double deltaY = scale * this.grid.getDy();
        Point centerPoint = null;
        Graphics2D g2d = (Graphics2D)g;
        double radians = 0.0;
        if (this.rotateTextDegrees != 0) {
            radians = Math.toRadians(this.rotateTextDegrees);
            g2d.rotate(radians);
        }
        int minCol = reversed ? (int)Math.ceil(((double)bounds.x - scale * (double)this.grid.getOrigin().x + (double)bounds.width - (double)region.x) / deltaX) : (int)Math.floor(((double)(region.x - bounds.x) - scale * (double)this.grid.getOrigin().x) / deltaX);
        double xmin = reversed ? (double)bounds.x - scale * (double)this.grid.getOrigin().x + (double)bounds.width - deltaX * (double)minCol : (double)bounds.x + scale * (double)this.grid.getOrigin().x + deltaX * (double)minCol;
        double xmax = (double)(region.x + region.width) + deltaX;
        int minRow = reversed ? (int)Math.ceil(((double)bounds.y - scale * (double)this.grid.getOrigin().y + (double)bounds.height - (double)region.y) / deltaY) : (int)Math.floor(((double)(region.y - bounds.y) - scale * (double)this.grid.getOrigin().y) / deltaY);
        double ymin = reversed ? (double)bounds.y - scale * (double)this.grid.getOrigin().y + (double)bounds.height - deltaY * (double)minRow : (double)bounds.y + scale * (double)this.grid.getOrigin().y + deltaY * (double)minRow;
        double ymax = (double)(region.y + region.height) + deltaY;
        Font f = new Font("Dialog", 0, size);
        int column = minCol;
        double x = xmin;
        while (x < xmax) {
            int row = minRow;
            double y = ymin;
            while (y < ymax) {
                int printRow = row;
                int printColumn = column;
                if (this.vDescending) {
                    printRow = this.getMaxRows() - row;
                }
                if (this.hDescending) {
                    printColumn = this.getMaxColumns() - column;
                }
                int newX = 0;
                int newY = 0;
                switch (this.rotateTextDegrees) {
                    case 90: {
                        newX = (int)(x + deltaX / 2.0);
                        newY = (int)y;
                        break;
                    }
                    case 180: {
                        newX = (int)x;
                        newY = (int)(y + deltaY / 2.0);
                        break;
                    }
                    case 270: {
                        newX = (int)(x - deltaX / 2.0);
                        newY = (int)y;
                        break;
                    }
                    default: {
                        newX = (int)x;
                        newY = (int)(y - deltaY / 2.0);
                    }
                }
                centerPoint = this.offsetLabelCenter(newX, newY, scale);
                LabelUtils.drawLabel(g, this.getName(printRow, printColumn), centerPoint.x, centerPoint.y, f, 0, 3, this.color, null, null);
                y += deltaY;
                row += reversed ? -1 : 1;
            }
            x += deltaX;
            column += reversed ? -1 : 1;
        }
        if (this.rotateTextDegrees != 0) {
            g2d.rotate(-radians);
        }
        g.setClip(oldClip);
    }

    @Override
    public int getColumn(Point p) {
        int col = (int)Math.floor((double)(p.x - this.grid.getOrigin().x) / this.grid.getDx() + 0.5);
        if (this.hDescending) {
            return this.getMaxColumns() - col;
        }
        return col;
    }

    @Override
    public int getRow(Point p) {
        int row = (int)((double)(p.y - this.grid.getOrigin().y) / this.grid.getDy() + 0.5);
        if (this.vDescending) {
            return this.getMaxRows() - row;
        }
        return row;
    }

    @Override
    public Point getCenterPoint(int col, int row) {
        if (this.vDescending) {
            row = this.getMaxRows() - row;
        }
        if (this.hDescending) {
            col = this.getMaxColumns() - col;
        }
        return new Point((int)((double)col * this.grid.getDx() + (double)this.grid.getOrigin().x), (int)((double)row * this.grid.getDy() + (double)this.grid.getOrigin().y));
    }

    @Override
    public void removeFrom(Buildable parent) {
        this.grid.setGridNumbering(null);
    }

    protected int getMaxRows() {
        return (int)((double)this.grid.getContainer().getSize().height / this.grid.getDy() + 0.5);
    }

    protected int getMaxColumns() {
        return (int)((double)this.grid.getContainer().getSize().width / this.grid.getDx() + 0.5);
    }
}

