/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.tools.io.IOUtils;
import java.awt.Frame;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public abstract class Compressor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] in) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(byteOut);
        try {
            zipOut.putNextEntry(new ZipEntry("Dummy"));
            zipOut.write(in);
        }
        finally {
            try {
                zipOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return byteOut.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] in) throws IOException {
        ZipInputStream zipIn = new ZipInputStream(new ByteArrayInputStream(in));
        try {
            zipIn.getNextEntry();
            byte[] byArray = IOUtils.toByteArray((InputStream)zipIn);
            return byArray;
        }
        finally {
            try {
                zipIn.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            Frame f = new Frame();
            TextField tf = new TextField(60);
            f.add(tf);
            f.pack();
            f.setVisible(true);
            tf.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        String s = evt.getActionCommand();
                        System.err.println("Input (" + s.length() + ") = " + s);
                        String comp = new String(Compressor.compress(s.getBytes()));
                        System.err.println("Compressed (" + comp.length() + ") = " + comp);
                        String decomp = new String(Compressor.decompress(comp.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
                        System.err.println("Decompressed (" + decomp.length() + ") = " + decomp);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            });
        } else {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            FileInputStream file = new FileInputStream(args[0]);
            try {
                IOUtils.copy((InputStream)file, (OutputStream)byteOut);
            }
            finally {
                try {
                    file.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            byte[] contents = byteOut.toByteArray();
            if (contents[0] == 80 && contents[1] == 75) {
                byte[] uncompressed = Compressor.decompress(contents);
                FileOutputStream out = new FileOutputStream(args[0] + ".uncompressed");
                try {
                    out.write(uncompressed);
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                byte[] recompressed = Compressor.compress(uncompressed);
                if (!Arrays.equals(recompressed, contents)) {
                    throw new RuntimeException("Compression failed");
                }
            } else {
                byte[] compressed = Compressor.compress(contents);
                FileOutputStream out = new FileOutputStream(args[0] + ".compressed");
                try {
                    out.write(compressed);
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (!Arrays.equals(Compressor.decompress(compressed), contents)) {
                    throw new RuntimeException("Compression failed");
                }
            }
        }
    }
}

