/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.PrivateChatter;
import VASSAL.i18n.Resources;
import VASSAL.tools.menu.MenuManager;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class PrivateChatManager {
    private ChatServerConnection client;
    private List<Entry> chatters = new ArrayList<Entry>();
    private List<Player> banned = new ArrayList<Player>();

    public PrivateChatManager(ChatServerConnection client) {
        this.client = client;
    }

    public PrivateChatter getChatterFor(final Player sender) {
        if (this.banned.contains(sender)) {
            return null;
        }
        PrivateChatter chat = null;
        int index = this.chatters.indexOf(new Entry(sender, null));
        if (index >= 0) {
            chat = this.chatters.get((int)index).chatter;
        }
        if (chat == null) {
            chat = new PrivateChatter(sender, this.client);
            this.chatters.add(new Entry(sender, chat));
            JFrame f = new JFrame();
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PrivateChatManager.this.promptToBan(sender);
                }
            });
            f.setTitle(Resources.getString("Chat.private_channel", sender.getName()));
            f.setJMenuBar(MenuManager.getInstance().getMenuBarFor(f));
            f.getContentPane().add(chat);
            f.setSize(640, 320);
            f.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - f.getSize().width / 2, 0);
        }
        return chat;
    }

    private void promptToBan(Player p) {
        if (0 == JOptionPane.showConfirmDialog(null, Resources.getString("Chat.ignore_messages", p.getName()), null, 0)) {
            this.banned.add(p);
        }
    }

    private static class Entry {
        private Player player;
        private PrivateChatter chatter;

        private Entry(Player p, PrivateChatter chat) {
            if (p == null) {
                throw new NullPointerException();
            }
            this.player = p;
            this.chatter = chat;
        }

        public boolean equals(Object o) {
            if (o instanceof Entry) {
                return this.player.equals(((Entry)o).player);
            }
            return false;
        }
    }
}

