/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.CommandDecoder;
import VASSAL.chat.HttpMessageServer;
import VASSAL.chat.node.NodeServerInfo;
import VASSAL.chat.node.SocketNodeClient;
import VASSAL.chat.peer2peer.PeerPoolInfo;
import VASSAL.i18n.Resources;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeClientFactory
extends ChatServerFactory {
    private static final Logger logger = LoggerFactory.getLogger(NodeClientFactory.class);
    private static final String UNNAMED_MODULE = Resources.getString("Chat.unknown_module");
    private static final String UNKNOWN_USER = Resources.getString("Chat.unknown_user");
    public static final String NODE_TYPE = "node";
    public static final String NODE_HOST = "nodeHost";
    public static final String NODE_PORT = "nodePort";

    @Override
    public ChatServerConnection buildServer(Properties param) {
        final String host = param.getProperty(NODE_HOST, "game.vassalengine.org");
        final int port = Integer.parseInt(param.getProperty(NODE_PORT, "5050"));
        NodeServerInfo nodeServerInfo = new NodeServerInfo(){

            @Override
            public String getHostName() {
                return host;
            }

            @Override
            public int getPort() {
                return port;
            }
        };
        PeerPoolInfo publicInfo = new PeerPoolInfo(){

            @Override
            public String getModuleName() {
                GameModule g = GameModule.getGameModule();
                return g == null ? UNNAMED_MODULE : g.getGameName();
            }

            @Override
            public String getUserName() {
                GameModule g = GameModule.getGameModule();
                return g == null ? UNKNOWN_USER : (String)g.getPrefs().getValue("RealName");
            }
        };
        HttpMessageServer httpMessageServer = new HttpMessageServer(publicInfo);
        GameModule g = GameModule.getGameModule();
        SocketNodeClient server = new SocketNodeClient(g.getGameName(), GameModule.getUserId() + "." + System.currentTimeMillis(), g, nodeServerInfo, httpMessageServer, httpMessageServer);
        g.getPrefs().getOption("RealName").fireUpdate();
        g.getPrefs().getOption("Profile").fireUpdate();
        server.addPropertyChangeListener("Status", e -> {
            String mess = (String)e.getNewValue();
            GameModule.getGameModule().warn(mess);
            logger.error("", (Object)mess);
        });
        server.addPropertyChangeListener("Msg", new CommandDecoder());
        return server;
    }
}

