/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.tools.SequenceEncoder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class KeyStrokeArrayConfigurer
extends Configurer {
    private List<HotKeyConfigurer> configs = new ArrayList<HotKeyConfigurer>();
    private Box controls;
    private JPanel panel;

    public KeyStrokeArrayConfigurer(String key, String name) {
        super(key, name);
    }

    public KeyStrokeArrayConfigurer(String key, String name, KeyStroke[] val) {
        super(key, name, val);
    }

    @Override
    public Component getControls() {
        if (this.panel == null) {
            this.panel = new JPanel(new BorderLayout());
            this.controls = Box.createVerticalBox();
            JScrollPane scroll = new JScrollPane(this.controls);
            Box b = Box.createHorizontalBox();
            this.controls.add(b);
            JLabel l = new JLabel(this.getName());
            b.add(l);
            JButton button = new JButton("Add");
            b.add(button);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeyStrokeArrayConfigurer.this.addKey(null);
                }
            });
            this.panel.add((Component)scroll, "Center");
            KeyStroke[] keyStrokes = (KeyStroke[])this.value;
            if (keyStrokes != null) {
                for (KeyStroke keyStroke : keyStrokes) {
                    this.addKey(keyStroke);
                }
            }
            this.addKey(null);
        }
        return this.panel;
    }

    private void addKey(KeyStroke keyStroke) {
        HotKeyConfigurer config = new HotKeyConfigurer(null, null, keyStroke);
        this.configs.add(config);
        this.controls.add(config.getControls());
        if (this.configs.size() > 5) {
            this.panel.setPreferredSize(new Dimension(this.panel.getPreferredSize().width, 150));
        } else {
            this.panel.setPreferredSize(null);
        }
        Window w = SwingUtilities.getWindowAncestor(this.controls);
        if (w != null) {
            w.pack();
        }
    }

    @Override
    public String getValueString() {
        return KeyStrokeArrayConfigurer.encode(this.getKeyStrokes());
    }

    @Override
    public void setValue(String s) {
        this.setValue(KeyStrokeArrayConfigurer.decode(s));
    }

    @Override
    public void setValue(Object o) {
        super.setValue(o);
        if (this.controls != null) {
            int i;
            KeyStroke[] keyStrokes = (KeyStroke[])o;
            if (keyStrokes == null) {
                keyStrokes = new KeyStroke[]{};
            }
            for (i = 0; i < keyStrokes.length; ++i) {
                if (i > this.configs.size()) {
                    this.addKey(keyStrokes[i]);
                    continue;
                }
                this.configs.get(i).setValue(keyStrokes[i]);
            }
            for (i = keyStrokes.length; i < this.configs.size(); ++i) {
                this.configs.get(i).setValue(null);
            }
        }
    }

    public KeyStroke[] getKeyStrokes() {
        ArrayList<KeyStroke> l = new ArrayList<KeyStroke>();
        for (HotKeyConfigurer hotKeyConfigurer : this.configs) {
            KeyStroke value = (KeyStroke)hotKeyConfigurer.getValue();
            if (value == null) continue;
            l.add(value);
        }
        return l.toArray(new KeyStroke[0]);
    }

    public static KeyStroke[] decode(String s) {
        if (s == null) {
            return null;
        }
        ArrayList<KeyStroke> l = new ArrayList<KeyStroke>();
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ',');
        while (st.hasMoreTokens()) {
            l.add(HotKeyConfigurer.decode(st.nextToken()));
        }
        return l.toArray(new KeyStroke[0]);
    }

    public static String encode(KeyStroke[] keys) {
        if (keys == null) {
            return null;
        }
        SequenceEncoder se = new SequenceEncoder(',');
        for (KeyStroke key : keys) {
            se.append(HotKeyConfigurer.encode(key));
        }
        return se.getValue() != null ? se.getValue() : "";
    }
}

