/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.preferences;

import VASSAL.Info;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ReadErrorDialog;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class ReadOnlyPrefs {
    protected Properties storedValues = new Properties();

    public ReadOnlyPrefs(String name) {
        this(new File(Info.getPrefsDir(), Prefs.sanitize(name)));
    }

    protected ReadOnlyPrefs(File file) {
        try (FileInputStream fin2 = new FileInputStream(file);
             BufferedInputStream in = new BufferedInputStream(fin2);){
            this.storedValues.load(in);
        }
        catch (FileNotFoundException fin2) {
        }
        catch (IOException e) {
            ReadErrorDialog.error(e, file);
        }
    }

    public String getStoredValue(String key) {
        return this.storedValues.getProperty(key);
    }

    public static ReadOnlyPrefs getGlobalPrefs() {
        return new ReadOnlyPrefs(new File(Info.getPrefsDir(), "V_Global"));
    }
}

