/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.KeyStrokeSource;
import VASSAL.tools.swing.SwingUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;

public class KeyStrokeListener {
    private ActionListener l;
    private KeyStroke key;
    private List<KeyStrokeSource> sources = new ArrayList<KeyStrokeSource>();

    public KeyStrokeListener(ActionListener l, KeyStroke key) {
        this.l = l;
        this.setKeyStroke(key);
    }

    public KeyStrokeListener(ActionListener l) {
        this(l, null);
    }

    public void setKeyStroke(KeyStroke newKey) {
        if (newKey != null && newKey.getKeyCode() == 0) {
            newKey = null;
        }
        if (this.key != null) {
            for (KeyStrokeSource s : this.sources) {
                s.getComponent().unregisterKeyboardAction(SwingUtils.genericToSystem(this.key));
            }
        }
        this.key = newKey;
        for (KeyStrokeSource s : this.sources) {
            this.addKeyStrokeSource(s);
        }
    }

    public KeyStroke getKeyStroke() {
        return this.key;
    }

    public void keyPressed(KeyStroke stroke) {
        if (stroke != null && this.key != null && stroke.equals(SwingUtils.genericToSystem(this.key))) {
            this.l.actionPerformed(new ActionEvent(this, 0, "Direct Invocation"));
        }
    }

    public void addKeyStrokeSource(KeyStrokeSource src) {
        if (!this.sources.contains(src)) {
            this.sources.add(src);
        }
        if (this.key != null) {
            src.getComponent().registerKeyboardAction(this.l, SwingUtils.genericToSystem(this.key), src.getMode());
        }
    }
}

