/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.ExtensionMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.WriteErrorDialog;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ExtensionsManager {
    private File moduleFile;
    private File extensionsDir;
    private File inactiveDir;
    private final FilenameFilter filter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            File fileCandidate = new File(dir, name);
            return !fileCandidate.isHidden() && !fileCandidate.isDirectory();
        }
    };

    public ExtensionsManager(File moduleFile) {
        this.moduleFile = moduleFile;
    }

    public ExtensionsManager(GameModule module) {
        this.moduleFile = new File(GameModule.getGameModule().getDataArchive().getName());
    }

    public ExtensionsManager(String dir) {
        this.extensionsDir = this.ensureExists(new File(Info.getConfDir(), dir));
    }

    public File getExtensionsDirectory(boolean mustExist) {
        if (this.extensionsDir == null && this.moduleFile != null) {
            String dirName = this.moduleFile.getPath();
            int index = dirName.lastIndexOf(46);
            if (index > 0) {
                dirName = dirName.substring(0, index);
            }
            File dir = new File(dirName + "_ext");
            if (mustExist) {
                dir = this.ensureExists(dir);
            }
            this.extensionsDir = dir;
            if (this.extensionsDir == null) {
                return null;
            }
        }
        if (mustExist && !this.extensionsDir.exists()) {
            this.extensionsDir = this.ensureExists(this.extensionsDir);
        }
        return this.extensionsDir;
    }

    public void setExtensionsDirectory(File dir) {
        this.extensionsDir = dir == null ? null : this.ensureExists(dir);
    }

    protected File ensureExists(File dir) {
        if (dir.exists() && !dir.isDirectory()) {
            WriteErrorDialog.error(new IOException(dir + "is not a directory"), dir);
            return null;
        }
        if (!dir.exists() && !dir.mkdirs()) {
            WriteErrorDialog.error(new IOException("Could not create " + dir), dir);
            return null;
        }
        return dir;
    }

    public File getInactiveExtensionsDirectory(boolean mustExist) {
        if (this.inactiveDir == null) {
            File extDir = this.getExtensionsDirectory(mustExist);
            if (extDir == null) {
                return null;
            }
            this.inactiveDir = new File(extDir, "inactive");
            if (mustExist) {
                this.inactiveDir = this.ensureExists(this.inactiveDir);
                if (this.inactiveDir == null) {
                    return null;
                }
            }
        }
        if (mustExist && !this.inactiveDir.exists()) {
            this.inactiveDir = this.ensureExists(this.inactiveDir);
        }
        return this.inactiveDir;
    }

    public File setActive(File extension, boolean active) {
        File newExt;
        if (active) {
            File extensionsDirectory = this.getExtensionsDirectory(true);
            if (extensionsDirectory == null) {
                return extension;
            }
            newExt = new File(extensionsDirectory, extension.getName());
        } else {
            File inactiveExtensionsDirectory = this.getInactiveExtensionsDirectory(true);
            if (inactiveExtensionsDirectory == null) {
                return extension;
            }
            newExt = new File(inactiveExtensionsDirectory, extension.getName());
        }
        extension.renameTo(newExt);
        return newExt;
    }

    private List<File> getExtensions(File dir) {
        ArrayList<File> extensions = new ArrayList<File>(0);
        if (dir != null && dir.exists()) {
            File[] files = dir.listFiles(this.filter);
            if (files == null) {
                ReadErrorDialog.error(new IOException(), dir);
            } else {
                for (File file : files) {
                    AbstractMetaData metadata = MetaDataFactory.buildMetaData(file);
                    if (!(metadata instanceof ExtensionMetaData)) continue;
                    extensions.add(file);
                }
            }
        }
        return extensions;
    }

    public List<File> getActiveExtensions() {
        return this.getExtensions(this.getExtensionsDirectory(false));
    }

    public List<File> getInactiveExtensions() {
        return this.getExtensions(this.getInactiveExtensionsDirectory(false));
    }

    public boolean isExtensionActive(File extension) {
        for (File f : this.getActiveExtensions()) {
            if (!f.getName().equals(extension.getName())) continue;
            return true;
        }
        return false;
    }
}

