/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.PrototypeDefinition;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.Configurer;
import VASSAL.configure.SingleChildInstance;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Resources;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PrototypesContainer
extends AbstractConfigurable {
    private static PrototypesContainer instance;
    private final Map<String, PrototypeDefinition> definitions = new HashMap<String, PrototypeDefinition>();

    public Collection<PrototypeDefinition> getDefinitions() {
        return Collections.unmodifiableCollection(this.definitions.values());
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[0];
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public String getAttributeValueString(String key) {
        return null;
    }

    @Override
    public void setAttribute(String key, Object value) {
    }

    @Override
    public Configurer getConfigurer() {
        return null;
    }

    @Override
    public void addTo(Buildable parent) {
        this.validator = new SingleChildInstance(GameModule.getGameModule(), this.getClass());
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{PrototypeDefinition.class};
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.PrototypesContainer.component_type");
    }

    @Override
    public void add(Buildable b) {
        super.add(b);
        if (b instanceof PrototypeDefinition) {
            PrototypeDefinition def = (PrototypeDefinition)b;
            this.definitions.put(def.getConfigureName(), def);
            def.addPropertyChangeListener(evt -> {
                if ("name".equals(evt.getPropertyName())) {
                    this.definitions.remove(evt.getOldValue());
                    this.definitions.put((String)evt.getNewValue(), (PrototypeDefinition)evt.getSource());
                }
            });
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Prototypes.htm");
    }

    @Override
    public void removeFrom(Buildable parent) {
    }

    public static PrototypeDefinition getPrototype(String name) {
        if (instance == null) {
            Iterator<PrototypesContainer> i = GameModule.getGameModule().getComponentsOf(PrototypesContainer.class).iterator();
            if (i.hasNext()) {
                instance = i.next();
            } else {
                return null;
            }
        }
        return PrototypesContainer.instance.definitions.get(name);
    }

    @Override
    public ComponentI18nData getI18nData() {
        ComponentI18nData data = super.getI18nData();
        data.setPrefix("");
        return data;
    }
}

