/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GameSetupStep;
import VASSAL.build.module.GameState;
import VASSAL.build.module.PredefinedSetup;
import VASSAL.build.module.documentation.Tutorial;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.command.Command;
import VASSAL.command.CommandFilter;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.FileConfigurer;
import VASSAL.configure.PasswordConfigurer;
import VASSAL.configure.ShowHelpAction;
import VASSAL.configure.StringConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.launch.BasicModule;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.SplashScreen;
import VASSAL.tools.image.ImageUtils;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import org.netbeans.api.wizard.WizardDisplayer;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardBranchController;
import org.netbeans.spi.wizard.WizardController;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardPage;
import org.netbeans.spi.wizard.WizardPanelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardSupport {
    private static final Logger logger = LoggerFactory.getLogger(WizardSupport.class);
    public static final String POST_INITIAL_STEPS_WIZARD = "postInitialStepsWizard";
    public static final String POST_LOAD_GAME_WIZARD = "postLoadGameWizard";
    public static final String POST_PLAY_OFFLINE_WIZARD = "postPlayOfflineWizard";
    public static final String WELCOME_WIZARD_KEY = "welcomeWizard";
    public static final String SETUP_KEY = "setup";
    public static final String ACTION_KEY = "action";
    public static final String LOAD_TUTORIAL_ACTION = "tutorial";
    public static final String PLAY_ONLINE_ACTION = "online";
    public static final String PLAY_OFFLINE_ACTION = "offline";
    public static final String LOAD_GAME_ACTION = "loadGame";
    public static final String WELCOME_WIZARD_ENABLED = "showWelcomeWizard";
    protected Dimension logoSize = new Dimension(200, 200);
    protected List<PredefinedSetup> setups = new ArrayList<PredefinedSetup>();
    protected Tutorial tutorial;

    public void addPredefinedSetup(PredefinedSetup setup) {
        if (!setup.isMenu()) {
            this.setups.add(setup);
        }
    }

    public void removePredefinedSetup(PredefinedSetup setup) {
        this.setups.remove(setup);
    }

    public void setTutorial(Tutorial tutorial) {
        this.tutorial = tutorial;
    }

    public void showWelcomeWizard() {
        GameModule g = GameModule.getGameModule();
        BranchingWizard c = this.createWelcomeWizard();
        Wizard welcomeWizard = c.createWizard();
        HashMap<String, Wizard> props = new HashMap<String, Wizard>();
        props.put(WELCOME_WIZARD_KEY, welcomeWizard);
        ShowHelpAction help = null;
        try {
            help = new ShowHelpAction(new URL("http://www.vassalengine.org/wiki/doku.php?id=getting_started:getting_started"), null);
        }
        catch (MalformedURLException e) {
            ErrorDialog.bug(e);
        }
        Object result = WizardDisplayer.showWizard((Wizard)welcomeWizard, null, (Action)help, props);
        if (result instanceof Map) {
            Map m = (Map)result;
            Object action = m.get(ACTION_KEY);
            if (PLAY_ONLINE_ACTION.equals(action)) {
                final ChatServerControls controls = ((BasicModule)g).getServerControls();
                g.getPlayerWindow().setVisible(true);
                controls.toggleVisible();
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() {
                        controls.getClient().setConnected(true);
                        return null;
                    }
                }.execute();
            } else {
                g.getGameState().setup(true);
                g.getPlayerWindow().setVisible(true);
            }
        } else {
            g.getPlayerWindow().setVisible(true);
        }
    }

    protected BranchingWizard createWelcomeWizard() {
        InitialWelcomeSteps info = this.createInitialWelcomeSteps();
        info.setTutorial(this.tutorial);
        return new BranchingWizard(info, POST_INITIAL_STEPS_WIZARD);
    }

    public WizardPanelProvider createPlayOfflinePanels() {
        if (this.setups.isEmpty()) {
            return GameSetupPanels.newInstance();
        }
        return new PlayOfflinePanels(Resources.getString("WizardSupport.WizardSupport.PlayOffline"), Resources.getString("WizardSupport.WizardSupport.SelectSetup"), this.setups);
    }

    public void showGameSetupWizard() {
        GameSetupPanels panels = GameSetupPanels.newInstance();
        if (panels != null) {
            WizardDisplayer.showWizard((Wizard)panels.newWizard(this.logoSize), (Rectangle)new Rectangle(0, 0, this.logoSize.width + 400, this.logoSize.height));
        }
    }

    public InitialWelcomeSteps createInitialWelcomeSteps() {
        if (!this.isRealName()) {
            return new InitialWelcomeSteps(new String[]{"name", ACTION_KEY}, new String[]{Resources.getString("WizardSupport.WizardSupport.EnterName"), Resources.getString("WizardSupport.WizardSupport.SelectPlayMode")});
        }
        return new InitialWelcomeSteps(new String[]{ACTION_KEY}, new String[]{Resources.getString("WizardSupport.SelectPlayMode")});
    }

    private boolean isRealName() {
        String name = (String)GameModule.getGameModule().getPrefs().getValue("RealName");
        return name != null && !name.isBlank() && !name.equals(Resources.getString("Prefs.newbie"));
    }

    public void setBackgroundImage(Image image) {
        if (image != null) {
            ImageIcon icon = new ImageIcon(image);
            this.logoSize = new Dimension(icon.getIconWidth(), icon.getIconHeight());
            BufferedImage img = ImageUtils.createCompatibleTranslucentImage(this.logoSize.width, this.logoSize.height);
            Graphics2D g = img.createGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
            g.setComposite(AlphaComposite.getInstance(3, 0.5f));
            icon.paintIcon(null, g, 0, 0);
            g.dispose();
            UIManager.put("wizard.sidebar.image", img);
        }
    }

    public static class BranchingWizard
    extends WizardBranchController {
        private String wizardKey;

        public BranchingWizard(WizardPanelProvider base, String key) {
            super(base);
            this.wizardKey = key;
        }

        protected WizardPanelProvider getPanelProviderForStep(String step, Map settings) {
            return (WizardPanelProvider)settings.get(this.wizardKey);
        }

        protected Wizard getWizardForStep(String step, Map settings) {
            Wizard w = null;
            Object next = settings.get(this.wizardKey);
            w = next instanceof Wizard ? (Wizard)next : super.getWizardForStep(step, settings);
            return w;
        }
    }

    public class InitialWelcomeSteps
    extends WizardPanelProvider {
        public static final String NAME_STEP = "name";
        protected JComponent nameControls;
        protected JComponent actionControls;
        protected Tutorial tutorial;

        public InitialWelcomeSteps(String[] steps, String[] stepDescriptions) {
            super(Resources.getString("WizardSupport.Welcome"), steps, stepDescriptions);
        }

        protected JComponent createPanel(WizardController controller, String id, Map settings) {
            JComponent c;
            if (NAME_STEP.equals(id)) {
                c = this.getNameControls(controller, settings);
            } else if (WizardSupport.ACTION_KEY.equals(id)) {
                c = this.getActionControls(controller, settings);
            } else {
                throw new IllegalArgumentException("Illegal step: " + id);
            }
            SplashScreen.disposeAll();
            return c;
        }

        private JComponent getActionControls(WizardController controller, Map<String, Object> settings) {
            if (this.actionControls == null) {
                Box box = Box.createVerticalBox();
                ButtonGroup group = new ButtonGroup();
                JRadioButton tutorialButton = null;
                if (this.tutorial != null && this.tutorial.isFirstRun()) {
                    tutorialButton = this.createTutorialButton(controller, settings);
                    this.addButton(tutorialButton, group, box);
                    box.add(Box.createVerticalStrut(20));
                }
                JRadioButton b = this.createPlayOfflineButton(controller, settings);
                b.doClick();
                this.addButton(b, group, box);
                settings.put(WizardSupport.ACTION_KEY, WizardSupport.PLAY_OFFLINE_ACTION);
                this.addButton(this.createPlayOnlineButton(controller, settings), group, box);
                this.addButton(this.createLoadSavedGameButton(controller, settings), group, box);
                if (tutorialButton != null) {
                    final JRadioButton clickOnMe = tutorialButton;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            clickOnMe.doClick();
                        }
                    });
                    tutorialButton.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            if (e.getStateChange() == 2) {
                                InitialWelcomeSteps.this.tutorial.markAsViewed();
                            }
                        }
                    });
                } else if (this.tutorial != null) {
                    this.addButton(this.createTutorialButton(controller, settings), group, box);
                }
                this.actionControls = box;
                box.add(Box.createVerticalGlue());
                final BooleanConfigurer wizardConf = (BooleanConfigurer)Prefs.getGlobalPrefs().getOption(WizardSupport.WELCOME_WIZARD_KEY);
                final JCheckBox show = new JCheckBox(wizardConf.getName());
                show.setSelected(wizardConf.booleanValue());
                show.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        wizardConf.setValue(show.isSelected());
                    }
                });
                box.add(show);
            }
            return this.actionControls;
        }

        private JRadioButton createTutorialButton(final WizardController controller, final Map<String, Object> settings) {
            JRadioButton b = new JRadioButton(Resources.getString("WizardSupport.LoadTutorial"));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    controller.setProblem(Resources.getString("WizardSupport.LoadingTutorial"));
                    try {
                        new TutorialLoader(controller, settings, new BufferedInputStream(InitialWelcomeSteps.this.tutorial.getTutorialContents()), WizardSupport.POST_INITIAL_STEPS_WIZARD, InitialWelcomeSteps.this.tutorial).start();
                    }
                    catch (IOException e1) {
                        logger.error("", (Throwable)e1);
                        controller.setProblem(Resources.getString("WizardSupport.ErrorLoadingTutorial"));
                    }
                }
            });
            return b;
        }

        private JRadioButton createLoadSavedGameButton(final WizardController controller, final Map<String, Object> settings) {
            JRadioButton b = new JRadioButton(Resources.getString("WizardSupport.LoadSavedGame"));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    settings.put(WizardSupport.ACTION_KEY, WizardSupport.LOAD_GAME_ACTION);
                    Wizard wiz = new BranchingWizard(new LoadSavedGamePanels(), WizardSupport.POST_LOAD_GAME_WIZARD).createWizard();
                    settings.put(WizardSupport.POST_INITIAL_STEPS_WIZARD, wiz);
                    controller.setForwardNavigationMode(1);
                    controller.setProblem(null);
                }
            });
            return b;
        }

        private JRadioButton createPlayOnlineButton(final WizardController controller, final Map<String, Object> settings) {
            JRadioButton b = new JRadioButton(Resources.getString("WizardSupport.PlayOnline"));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    settings.put(WizardSupport.ACTION_KEY, WizardSupport.PLAY_ONLINE_ACTION);
                    controller.setForwardNavigationMode(2);
                    controller.setProblem(null);
                }
            });
            return b;
        }

        private JRadioButton createPlayOfflineButton(final WizardController controller, final Map<String, Object> settings) {
            JRadioButton b = new JRadioButton(Resources.getString("WizardSupport.PlayOffline"));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GameModule.getGameModule().getGameState().setup(false);
                    settings.put(WizardSupport.ACTION_KEY, WizardSupport.PLAY_OFFLINE_ACTION);
                    WizardPanelProvider panels = WizardSupport.this.createPlayOfflinePanels();
                    if (panels == null) {
                        controller.setForwardNavigationMode(2);
                    } else {
                        Wizard wiz = new BranchingWizard(panels, WizardSupport.POST_PLAY_OFFLINE_WIZARD).createWizard();
                        settings.put(WizardSupport.POST_INITIAL_STEPS_WIZARD, wiz);
                        controller.setForwardNavigationMode(1);
                    }
                }
            });
            return b;
        }

        private void addButton(JRadioButton button, ButtonGroup group, Box box) {
            box.add(button);
            group.add(button);
        }

        protected JComponent getNameControls(final WizardController controller, final Map<String, Object> settings) {
            if (this.nameControls == null) {
                Box box = Box.createVerticalBox();
                box.add(Box.createVerticalGlue());
                controller.setProblem(Resources.getString("WizardSupport.EnterNameAndPassword"));
                final StringConfigurer nameConfig = new StringConfigurer(null, Resources.getString("WizardSupport.RealName"));
                final PasswordConfigurer pwd = new PasswordConfigurer(null, Resources.getString("WizardSupport.Password"));
                final PasswordConfigurer pwd2 = new PasswordConfigurer(null, Resources.getString("WizardSupport.ConfirmPassword"));
                PropertyChangeListener pl = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        settings.put("RealName", nameConfig.getValue());
                        settings.put("SecretName", pwd.getValue());
                        if (nameConfig.getValue() == null || "".equals(nameConfig.getValue())) {
                            controller.setProblem(Resources.getString("WizardSupport.EnterYourName"));
                        } else if (pwd.getValue() == null || "".equals(pwd.getValue())) {
                            controller.setProblem(Resources.getString("WizardSupport.EnterYourPassword"));
                        } else if (!pwd.getValue().equals(pwd2.getValue())) {
                            controller.setProblem(Resources.getString("WizardSupport.PasswordsDontMatch"));
                        } else {
                            Prefs p = GameModule.getGameModule().getPrefs();
                            p.getOption("RealName").setValue(nameConfig.getValueString());
                            p.getOption("SecretName").setValue(pwd.getValueString());
                            try {
                                p.save();
                                controller.setProblem(null);
                            }
                            catch (IOException e) {
                                String msg = e.getMessage();
                                if (msg == null) {
                                    msg = Resources.getString("Prefs.unable_to_save");
                                }
                                controller.setProblem(msg);
                            }
                        }
                    }
                };
                nameConfig.addPropertyChangeListener(pl);
                pwd.addPropertyChangeListener(pl);
                pwd2.addPropertyChangeListener(pl);
                box.add(nameConfig.getControls());
                box.add(pwd.getControls());
                box.add(pwd2.getControls());
                JLabel l = new JLabel(Resources.getString("WizardSupport.NameAndPasswordDetails"));
                l.setAlignmentX(0.5f);
                box.add(l);
                box.add(Box.createVerticalGlue());
                this.nameControls = box;
            }
            return this.nameControls;
        }

        public void setTutorial(Tutorial tutorial) {
            this.tutorial = tutorial;
        }
    }

    public static class GameSetupPanels
    extends WizardPanelProvider
    implements WizardPage.WizardResultProducer {
        private WizardPage[] pages;
        private List<GameSetupStep> setupSteps;

        private GameSetupPanels(String[] steps, String[] descriptions, WizardPage[] pages, List<GameSetupStep> setupSteps) {
            super(steps, descriptions);
            this.pages = pages;
            this.setupSteps = setupSteps;
        }

        public static GameSetupPanels newInstance() {
            GameSetupPanels panels = null;
            ArrayList<SetupStepPage> pages = new ArrayList<SetupStepPage>();
            ArrayList<GameSetupStep> setupSteps = new ArrayList<GameSetupStep>();
            Iterator<GameSetupStep> i = GameModule.getGameModule().getGameState().getUnfinishedSetupSteps();
            while (i.hasNext()) {
                GameSetupStep step = i.next();
                setupSteps.add(step);
                SetupStepPage page = new SetupStepPage(step);
                pages.add(page);
            }
            if (!pages.isEmpty()) {
                WizardPage[] wizardPages = pages.toArray(new WizardPage[0]);
                String[] steps = new String[setupSteps.size()];
                String[] desc = new String[setupSteps.size()];
                int n = setupSteps.size();
                for (int i2 = 0; i2 < n; ++i2) {
                    steps[i2] = String.valueOf(i2);
                    desc[i2] = setupSteps.get(i2).getStepTitle();
                }
                panels = new GameSetupPanels(steps, desc, wizardPages, setupSteps);
            }
            return panels;
        }

        protected JComponent createPanel(WizardController controller, String id, Map settings) {
            int index = this.indexOfStep(id);
            controller.setForwardNavigationMode(index == this.pages.length - 1 ? 2 : 1);
            return this.pages[index];
        }

        public boolean cancel(Map settings) {
            GameModule.getGameModule().getGameState().setup(false);
            return true;
        }

        public Object finish(Map wizardData) throws WizardException {
            for (GameSetupStep step : this.setupSteps) {
                step.finish();
            }
            return wizardData;
        }

        public Wizard newWizard(Dimension logoSize) {
            return this.createWizard();
        }
    }

    public static class PlayOfflinePanels
    extends WizardPanelProvider {
        private final List<PredefinedSetup> setups;
        private final String description;

        protected PlayOfflinePanels(String title, String singleDescription, List<PredefinedSetup> setups) {
            super(title, WizardSupport.SETUP_KEY, singleDescription);
            this.setups = setups;
            this.description = singleDescription;
        }

        protected JComponent createPanel(final WizardController controller, String id, final Map settings) {
            DefaultComboBoxModel<PredefinedSetup> comboBoxModel = new DefaultComboBoxModel<PredefinedSetup>(new Vector<PredefinedSetup>(this.setups));
            comboBoxModel.insertElementAt((PredefinedSetup)((Object)this.description), 0);
            final JComboBox<PredefinedSetup> setupSelection = new JComboBox<PredefinedSetup>(comboBoxModel);
            setupSelection.setSelectedIndex(0);
            setupSelection.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (setupSelection.getSelectedItem() instanceof PredefinedSetup) {
                        PredefinedSetup setup = (PredefinedSetup)setupSelection.getSelectedItem();
                        if (setup.isUseFile() && setup.getFileName() != null) {
                            this.loadSetup(setup, controller, settings);
                        } else {
                            GameSetupPanels panels = GameSetupPanels.newInstance();
                            settings.put(WizardSupport.POST_PLAY_OFFLINE_WIZARD, panels);
                            controller.setProblem(null);
                            controller.setForwardNavigationMode(panels == null ? 2 : 1);
                        }
                    } else {
                        controller.setProblem(description);
                    }
                }
            });
            setupSelection.setMaximumSize(new Dimension(setupSelection.getMaximumSize().width, setupSelection.getPreferredSize().height));
            setupSelection.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel c = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    String labelText = value instanceof PredefinedSetup ? ((PredefinedSetup)value).getConfigureName() : (value == null ? "" : value.toString());
                    c.setText(labelText);
                    return c;
                }
            });
            Box box = Box.createVerticalBox();
            box.add(Box.createVerticalGlue());
            box.add(setupSelection);
            box.add(Box.createVerticalGlue());
            controller.setProblem(this.description);
            return box;
        }

        protected void loadSetup(PredefinedSetup setup, WizardController controller, Map settings) {
            try {
                new SavedGameLoader(controller, settings, new BufferedInputStream(setup.getSavedGameContents()), WizardSupport.POST_PLAY_OFFLINE_WIZARD).start();
            }
            catch (IOException e1) {
                controller.setProblem(Resources.getString("WizardSupport.UnableToLoad"));
            }
        }
    }

    public static class SetupStepPage
    extends WizardPage {
        private static final long serialVersionUID = 1L;

        public SetupStepPage(GameSetupStep step) {
            super(step.getStepTitle());
            this.setLayout(new BorderLayout());
            this.add(step.getControls());
            this.putWizardData(step, step);
        }
    }

    public static class LoadSavedGamePanels
    extends WizardPanelProvider {
        private FileConfigurer fileConfig;

        public LoadSavedGamePanels() {
            super(Resources.getString("WizardSupport.LoadGame"), WizardSupport.LOAD_GAME_ACTION, Resources.getString("WizardSupport.LoadSavedGame"));
        }

        protected JComponent createPanel(final WizardController controller, String id, final Map settings) {
            if (this.fileConfig == null) {
                this.fileConfig = new FileConfigurer(null, Resources.getString("WizardSupport.SavedGame"), GameModule.getGameModule().getGameState().getSavedGameDirectoryPreference());
                this.fileConfig.addPropertyChangeListener(new PropertyChangeListener(){
                    private Set<File> processing = new HashSet<File>();

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        final File f = (File)evt.getNewValue();
                        if (f == null || !f.exists()) {
                            controller.setProblem(Resources.getString("WizardSupport.NoSuchFile"));
                        } else if (f.isDirectory()) {
                            controller.setProblem("");
                        } else if (!this.processing.contains(f)) {
                            this.processing.add(f);
                            try {
                                new SavedGameLoader(controller, settings, new BufferedInputStream(new FileInputStream(f)), WizardSupport.POST_LOAD_GAME_WIZARD){

                                    @Override
                                    public void run() {
                                        super.run();
                                        processing.remove(f);
                                    }
                                }.start();
                            }
                            catch (IOException e) {
                                controller.setProblem(Resources.getString("WizardSupport.UnableToLoad"));
                            }
                        }
                    }
                });
                controller.setProblem(Resources.getString("WizardSupport.SelectSavedGame"));
            }
            return (JComponent)this.fileConfig.getControls();
        }
    }

    public static class TutorialLoader
    extends SavedGameLoader {
        private final Tutorial tutorial;

        public TutorialLoader(WizardController controller, Map<String, Object> settings, InputStream in, String wizardKey, Tutorial tutorial) {
            super(controller, settings, in, wizardKey);
            this.tutorial = tutorial;
        }

        @Override
        protected Command loadSavedGame() throws IOException {
            String msg = this.tutorial.getWelcomeMessage();
            Command c = msg == null ? new NullCommand() : new Chatter.DisplayText(GameModule.getGameModule().getChatter(), msg);
            c = c.append(super.loadSavedGame());
            return c;
        }
    }

    public static class SavedGameLoader
    extends Thread {
        private WizardController controller;
        private Map<String, Object> settings;
        private InputStream in;
        private String wizardKey;

        public SavedGameLoader(WizardController controller, Map<String, Object> settings, InputStream in, String wizardKey) {
            this.controller = controller;
            this.settings = settings;
            this.in = in;
            this.wizardKey = wizardKey;
        }

        @Override
        public void run() {
            try {
                this.controller.setProblem(Resources.getString("WizardSupport.LoadingGame"));
                Command setupCommand = this.loadSavedGame();
                setupCommand.execute();
                this.controller.setProblem(null);
                GameSetupPanels panels = GameSetupPanels.newInstance();
                this.settings.put(this.wizardKey, (Object)panels);
                this.controller.setForwardNavigationMode(panels == null ? 2 : 1);
            }
            catch (IOException e) {
                this.controller.setProblem(Resources.getString("WizardSupport.UnableToLoad"));
            }
        }

        protected Command loadSavedGame() throws IOException {
            Command setupCommand = GameModule.getGameModule().getGameState().decodeSavedGame(this.in);
            if (setupCommand == null) {
                throw new IOException(Resources.getString("WizardSupport.InvalidSavefile"));
            }
            setupCommand = new CommandFilter(){

                @Override
                protected boolean accept(Command c) {
                    return !(c instanceof GameState.SetupCommand) || !((GameState.SetupCommand)c).isGameStarting();
                }
            }.apply(setupCommand);
            return setupCommand;
        }
    }
}

