/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.documentation;

import VASSAL.Info;
import VASSAL.build.AbstractBuildable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.menu.MenuItemProxy;
import VASSAL.tools.menu.MenuManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.commons.io.file.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BrowserHelpFile
extends AbstractBuildable
implements Configurable {
    private static final Logger logger = LoggerFactory.getLogger(BrowserHelpFile.class);
    public static final String TITLE = "title";
    public static final String CONTENTS = "contents";
    public static final String STARTING_PAGE = "startingPage";
    protected String name;
    protected String startingPage;
    protected Action launch;
    protected URL url;
    protected PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    protected ComponentI18nData myI18nData;
    protected MenuItemProxy launchItem;

    public BrowserHelpFile() {
        this.launch = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserHelpFile.this.launch();
            }
        };
    }

    public void launch() {
        if (this.url == null) {
            this.extractContents();
        }
        if (this.url != null) {
            BrowserSupport.openURL(this.url.toString());
        }
    }

    protected String getContentsResource() {
        return this.name == null ? null : this.name.replace(' ', '_');
    }

    protected void extractContents() {
        try (ZipInputStream in = new ZipInputStream(new BufferedInputStream(GameModule.getGameModule().getDataArchive().getInputStream("help/" + this.getContentsResource())));){
            this.internalExtractContents(in);
        }
        catch (FileNotFoundException e) {
            logger.error("File not found in data archive: {}", (Object)("help/" + this.getContentsResource()), (Object)e);
            this.setFallbackUrl();
        }
        catch (IOException e) {
            logger.error("Error while reading file {} from data archive", (Object)("help/" + this.getContentsResource()), (Object)e);
            this.setFallbackUrl();
        }
    }

    private void setFallbackUrl() {
        try {
            this.url = new URL(this.startingPage);
        }
        catch (MalformedURLException e) {
            logger.error("Malformed URL: {}", (Object)this.startingPage, (Object)e);
        }
    }

    private void internalExtractContents(ZipInputStream in) throws IOException {
        ZipEntry entry;
        Path p = Path.of(Info.getTempDir().getAbsolutePath(), "VASSAL", "help", this.getContentsResource());
        if (Files.exists(p, new LinkOption[0])) {
            PathUtils.deleteDirectory((Path)p);
        }
        Files.createDirectories(p, new FileAttribute[0]);
        File output = p.toFile();
        while ((entry = in.getNextEntry()) != null) {
            if (entry.isDirectory()) {
                new File(output, entry.getName()).mkdirs();
                continue;
            }
            try (FileOutputStream fos = new FileOutputStream(new File(output, entry.getName()));){
                IOUtils.copy((InputStream)in, (OutputStream)fos);
            }
        }
        this.url = new File(output, this.startingPage).toURI().toURL();
    }

    @Deprecated(since="2020-10-04", forRemoval=true)
    protected void recursiveDelete(File output) {
        if (output.isDirectory()) {
            for (File f : output.listFiles()) {
                this.recursiveDelete(f);
            }
        } else {
            output.delete();
        }
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{TITLE, CONTENTS, STARTING_PAGE};
    }

    @Override
    public String getAttributeValueString(String key) {
        if (TITLE.equals(key)) {
            return this.name;
        }
        if (STARTING_PAGE.equals(key)) {
            return this.startingPage;
        }
        return null;
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (TITLE.equals(key)) {
            this.name = (String)value;
            this.launch.putValue("Name", this.name);
            this.url = null;
            this.getI18nData().setUntranslatedValue(key, this.name);
        } else if (STARTING_PAGE.equals(key)) {
            this.startingPage = (String)value;
            this.url = null;
        }
    }

    @Override
    public void addTo(Buildable parent) {
        this.launchItem = new MenuItemProxy(this.launch);
        MenuManager.getInstance().addToSection("Documentation.Module", this.launchItem);
        this.launch.setEnabled(true);
    }

    @Override
    public void removeFrom(Buildable parent) {
        MenuManager.getInstance().removeFromSection("Documentation.Module", this.launchItem);
        this.launch.setEnabled(false);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propSupport.addPropertyChangeListener(l);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    @Override
    public String getConfigureName() {
        return this.name;
    }

    @Override
    public Configurer getConfigurer() {
        return new MyConfigurer(new ConfigSupport());
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("HelpMenu.htm", "HtmlHelpFile");
    }

    @Override
    public void remove(Buildable child) {
    }

    public static String getConfigureTypeName() {
        return "HTML Help File";
    }

    @Override
    public ComponentI18nData getI18nData() {
        if (this.myI18nData == null) {
            this.myI18nData = new ComponentI18nData(this, "BrowserHelpFile." + this.getConfigureName(), null, new String[]{TITLE}, new boolean[]{true}, new String[]{"Menu Entry:  "});
        }
        return this.myI18nData;
    }

    protected static class MyConfigurer
    extends AutoConfigurer {
        public MyConfigurer(AutoConfigurable c) {
            super(c);
        }

        @Override
        public Object getValue() {
            if (this.target != null) {
                ((ConfigSupport)this.target).packContents();
            }
            return super.getValue();
        }
    }

    protected class ConfigSupport
    implements AutoConfigurable {
        public static final String DIR = "dir";
        protected File dir;

        protected ConfigSupport() {
        }

        @Override
        public String[] getAttributeDescriptions() {
            return new String[]{"Menu Entry:  ", "Contents:  ", "Starting Page:  "};
        }

        @Override
        public String[] getAttributeNames() {
            return new String[]{BrowserHelpFile.TITLE, DIR, BrowserHelpFile.STARTING_PAGE};
        }

        @Override
        public Class<?>[] getAttributeTypes() {
            return new Class[]{String.class, ContentsConfig.class, String.class};
        }

        @Override
        public String getAttributeValueString(String key) {
            if (DIR.equals(key)) {
                return this.dir == null ? null : this.dir.getPath();
            }
            return BrowserHelpFile.this.getAttributeValueString(key);
        }

        @Override
        public VisibilityCondition getAttributeVisibility(String name) {
            return null;
        }

        @Override
        public void setAttribute(String key, Object value) {
            if (DIR.equals(key)) {
                this.dir = (File)value;
            } else {
                BrowserHelpFile.this.setAttribute(key, value);
            }
        }

        public void packContents() {
            if (this.dir == null) {
                return;
            }
            File packed = null;
            try {
                packed = File.createTempFile("VASSALhelp", ".zip");
                try (FileOutputStream fout = new FileOutputStream(packed);
                     ZipOutputStream out = new ZipOutputStream(fout);){
                    for (File f : this.dir.listFiles()) {
                        this.packFile(f, "", out);
                    }
                }
                GameModule.getGameModule().getArchiveWriter().addFile(packed.getPath(), "help/" + BrowserHelpFile.this.getContentsResource());
            }
            catch (IOException e) {
                WriteErrorDialog.error(e, packed);
            }
        }

        protected void packFile(File packed, String prefix, ZipOutputStream out) throws IOException {
            if (packed.isDirectory()) {
                for (File f : packed.listFiles()) {
                    this.packFile(f, prefix + packed.getName() + "/", out);
                }
            } else {
                ZipEntry entry = new ZipEntry(prefix + packed.getName());
                out.putNextEntry(entry);
                try (FileInputStream in = new FileInputStream(packed);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
            }
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener l) {
            BrowserHelpFile.this.addPropertyChangeListener(l);
        }

        public Class<?>[] getAllowableConfigureComponents() {
            return BrowserHelpFile.this.getAllowableConfigureComponents();
        }

        @Override
        public Configurable[] getConfigureComponents() {
            return BrowserHelpFile.this.getConfigureComponents();
        }

        @Override
        public String getConfigureName() {
            return BrowserHelpFile.this.getConfigureName();
        }

        @Override
        public Configurer getConfigurer() {
            return null;
        }

        @Override
        public HelpFile getHelpFile() {
            return BrowserHelpFile.this.getHelpFile();
        }

        @Override
        public void remove(Buildable child) {
        }

        @Override
        public void removeFrom(Buildable parent) {
        }

        @Override
        public void add(Buildable child) {
        }

        @Override
        public void addTo(Buildable parent) {
        }

        @Override
        public void build(Element e) {
        }

        @Override
        public Element getBuildElement(Document doc) {
            return null;
        }

        @Override
        public ComponentI18nData getI18nData() {
            return null;
        }
    }

    public static class ContentsConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new DirectoryConfigurer(key, name){

                @Override
                public Component getControls() {
                    Component controls = super.getControls();
                    this.tf.setEditable(false);
                    return controls;
                }
            };
        }
    }
}

