/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.documentation;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.menu.MenuItemProxy;
import VASSAL.tools.menu.MenuManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tutorial
extends AbstractConfigurable {
    private static final Logger logger = LoggerFactory.getLogger(Tutorial.class);
    public static final String FILE_NAME = "logfile";
    public static final String NAME = "name";
    public static final String LAUNCH_ON_STARTUP = "launchOnStartup";
    public static final String PROMPT_MESSAGE = "promptMessage";
    public static final String WELCOME_MESSAGE = "welcomeMessage";
    private String fileName;
    private Action launch;
    private boolean launchOnFirstStartup;
    private String welcomeMessage = Resources.getString("Tutorial.instructions");
    private String promptMessage = Resources.getString("Tutorial.load_tutorial");
    protected BooleanConfigurer hasViewedTutorial;
    protected MenuItemProxy launchItem;

    public Tutorial() {
        this.launch = new AbstractAction(Resources.getString("Tutorial.tutorial")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Tutorial.this.launch();
            }
        };
    }

    public void launch() {
        GameModule.getGameModule().warn(Resources.getString("Tutorial.loading_tutorial"));
        new SwingWorker<Command, Void>(){

            @Override
            public Command doInBackground() throws Exception {
                return Tutorial.this.getTutorialCommand();
            }

            @Override
            protected void done() {
                Command saveCommand = null;
                String error = null;
                try {
                    saveCommand = (Command)this.get();
                }
                catch (InterruptedException e) {
                    ErrorDialog.bug(e);
                }
                catch (ExecutionException e) {
                    logger.error("", (Throwable)e);
                    Object msg = Resources.getString("Tutorial.unable_to_launch", Tutorial.this.name);
                    if (e.getMessage() != null) {
                        msg = (String)msg + ":  " + e.getMessage();
                    }
                    error = msg;
                }
                if (saveCommand != null) {
                    saveCommand.execute();
                    if (Tutorial.this.welcomeMessage != null && Tutorial.this.welcomeMessage.length() > 0) {
                        GameModule.getGameModule().warn(Tutorial.this.welcomeMessage);
                    }
                } else {
                    GameModule.getGameModule().warn(error);
                }
            }
        }.execute();
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Menu Text", "Logfile", "Launch automatically on first startup", "Auto-launch confirm message", "Welcome message"};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, File.class, Boolean.class, String.class, String.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, FILE_NAME, LAUNCH_ON_STARTUP, PROMPT_MESSAGE, WELCOME_MESSAGE};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (name.equals(PROMPT_MESSAGE)) {
            return new VisibilityCondition(){

                @Override
                public boolean shouldBeVisible() {
                    return Tutorial.this.launchOnFirstStartup;
                }
            };
        }
        return null;
    }

    @Override
    public String getAttributeValueString(String key) {
        if (FILE_NAME.equals(key)) {
            return this.fileName;
        }
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (LAUNCH_ON_STARTUP.equals(key)) {
            return String.valueOf(this.launchOnFirstStartup);
        }
        if (PROMPT_MESSAGE.equals(key)) {
            return this.promptMessage;
        }
        if (WELCOME_MESSAGE.equals(key)) {
            return this.welcomeMessage;
        }
        return null;
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (FILE_NAME.equals(key)) {
            if (value instanceof File) {
                value = ((File)value).getName();
            }
            this.fileName = (String)value;
        } else if (NAME.equals(key)) {
            this.launch.putValue("Name", value);
            this.setConfigureName((String)value);
        } else if (LAUNCH_ON_STARTUP.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.launchOnFirstStartup = (Boolean)value;
        } else if (PROMPT_MESSAGE.equals(key)) {
            this.promptMessage = (String)value;
        } else if (WELCOME_MESSAGE.equals(key)) {
            this.welcomeMessage = (String)value;
        }
    }

    @Override
    public void addTo(Buildable parent) {
        this.launchItem = new MenuItemProxy(this.launch);
        MenuManager.getInstance().addToSection("Documentation.Module", this.launchItem);
        String key = "viewedTutorial" + this.getConfigureName();
        this.hasViewedTutorial = new BooleanConfigurer(key, null, Boolean.FALSE);
        GameModule.getGameModule().getPrefs().addOption(null, this.hasViewedTutorial);
        GameModule.getGameModule().getWizardSupport().setTutorial(this);
    }

    @Override
    public void removeFrom(Buildable parent) {
        MenuManager.getInstance().removeFromSection("Documentation.Module", this.launchItem);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("HelpMenu.htm", "Tutorial");
    }

    public Command getTutorialCommand() throws IOException {
        return GameModule.getGameModule().getGameState().decodeSavedGame(this.getTutorialContents());
    }

    public InputStream getTutorialContents() throws IOException {
        if (this.fileName == null) {
            throw new FileNotFoundException("Tutorial has null filename");
        }
        return GameModule.getGameModule().getDataArchive().getInputStream(this.fileName);
    }

    public boolean isFirstRun() {
        return this.launchOnFirstStartup && this.hasViewedTutorial.booleanValue() == false;
    }

    public void markAsViewed() {
        this.hasViewedTutorial.setValue(Boolean.TRUE);
    }

    public String getWelcomeMessage() {
        return this.welcomeMessage;
    }
}

