/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.ImageItem;
import VASSAL.build.module.gamepieceimage.ItemInstance;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.SequenceEncoder;
import java.awt.Image;
import java.io.File;

public class ImageItemInstance
extends ItemInstance {
    protected static final String IMAGE = "image";
    protected String imageName = "";
    private final VisibilityCondition imageCond = () -> !((ImageItem)this.getItem()).isFixed();

    public ImageItemInstance() {
    }

    public ImageItemInstance(String code, GamePieceImage defn) {
        super(defn);
        this.decode(code);
    }

    public ImageItemInstance(String name, String type, String location) {
        super(name, type, location);
    }

    public ImageItemInstance(String nam, String typ, String loc, String iName) {
        super(nam, typ, loc);
        this.imageName = iName;
    }

    @Override
    public String encode() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.getType()).append(this.getName()).append(this.getLocation()).append(this.imageName);
        return se.getValue();
    }

    public void decode(String code) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(code, ';');
        this.setType(sd.nextToken(""));
        this.setName(sd.nextToken(""));
        this.setLocation(sd.nextToken(""));
        this.imageName = sd.nextToken("");
    }

    public String getImageName() {
        return this.imageName;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Image:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{Image.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{IMAGE};
    }

    @Override
    public void setAttribute(String key, Object o) {
        if (IMAGE.equals(key)) {
            this.imageName = o instanceof String ? (String)o : (o == null ? null : ((File)o).getName());
        } else {
            super.setAttribute(key, o);
        }
        if (this.myConfig != null) {
            this.myConfig.rebuildViz();
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (IMAGE.equals(key)) {
            return this.imageName;
        }
        return super.getAttributeValueString(key);
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (IMAGE.equals(name)) {
            return this.imageCond;
        }
        return super.getAttributeVisibility(name);
    }
}

