/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GameSetupStep;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.BoardSlot;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.Configurer;
import VASSAL.configure.DoubleConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.ValidityChecker;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.i18n.Translatable;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.SequenceEncoder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BoardPicker
extends AbstractBuildable
implements ActionListener,
GameComponent,
GameSetupStep,
Configurable,
CommandEncoder,
ValidityChecker {
    public static final String ID = "BoardPicker";
    protected List<Board> possibleBoards = new ArrayList<Board>();
    protected List<Board> currentBoards = null;
    protected Dimension psize = new Dimension(350, 125);
    protected double slotScale = 0.2;
    @Deprecated(since="2020-08-06", forRemoval=true)
    protected JTextField status;
    protected JLabel statusLabel;
    protected Map map;
    protected JPanel slotPanel;
    protected String version = "0.0";
    protected int nx = 1;
    protected int ny = 1;
    protected JToolBar toolbar;
    protected JPanel controls;
    protected JButton addRowButton;
    protected JButton addColumnButton;
    protected boolean allowMultiple = false;
    protected int maxColumns;
    protected String title = Resources.getString("BoardPicker.choose_boards");
    protected String addRowButtonText = Resources.getString("BoardPicker.add_row");
    protected String addColumnButtonText = Resources.getString("BoardPicker.add_column");
    protected String boardPrompt = Resources.getString("BoardPicker.select_board");
    protected String defaultSetup;
    protected List<JButton> multipleButtons;
    public static final String SCALE = "slotScale";
    public static final String SLOT_HEIGHT = "slotHeight";
    public static final String SLOT_WIDTH = "slotWidth";
    public static final String SETUP = "setup";
    public static final String DIALOG_TITLE = "title";
    public static final String ADD_ROW_BUTTON_TEXT = "addRowText";
    public static final String ADD_COLUMN_BUTTON_TEXT = "addColumnText";
    public static final String BOARD_PROMPT = "boardPrompt";
    public static final String MAX_COLUMNS = "maxColumns";
    protected JButton clearButton;
    protected JButton okButton;
    protected ComponentI18nData myI18nData;
    protected JScrollPane slotScroll;

    protected void initComponents() {
        this.multipleButtons = new ArrayList<JButton>();
        this.controls = new JPanel(new BorderLayout());
        this.statusLabel = new JLabel("");
        this.statusLabel.setForeground(Color.BLUE);
        this.slotPanel = new JPanel();
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.setLayout(new BoxLayout(this.toolbar, 1));
        this.addRowButton = this.addButton(this.addRowButtonText);
        this.multipleButtons.add(this.addRowButton);
        this.addColumnButton = this.addButton(this.addColumnButtonText);
        this.multipleButtons.add(this.addColumnButton);
        this.clearButton = this.addButton(Resources.getString("BoardPicker.clear"));
        this.multipleButtons.add(this.clearButton);
        this.setAllowMultiple(this.allowMultiple);
        this.controls.add("North", this.statusLabel);
        JPanel pp = new JPanel();
        pp.add(this.toolbar);
        this.controls.add("West", pp);
        this.slotScroll = new JScrollPane(this.slotPanel);
        this.controls.add("Center", this.slotScroll);
        this.reset();
    }

    public Dimension getDefaultSlotSize() {
        return this.psize;
    }

    public double getSlotScale() {
        return this.slotScale;
    }

    public void warn(String s) {
        if (this.statusLabel != null) {
            this.statusLabel.setText(s);
        }
    }

    @Override
    public void addTo(Buildable b) {
        this.map = (Map)b;
        this.map.setBoardPicker(this);
        for (Board board : this.possibleBoards) {
            board.setMap(this.map);
        }
        if (b instanceof Translatable) {
            this.getI18nData().setOwningComponent((Translatable)b);
        }
        GameModule.getGameModule().getGameState().addGameSetupStep(this);
    }

    @Override
    public void build(Element e) {
        if (e == null) {
            Board b = new Board();
            b.build(null);
            b.addTo(this);
        } else {
            NodeList l = e.getElementsByTagName(SETUP);
            if (l.getLength() > 0) {
                Element setupEl = (Element)l.item(0);
                this.defaultSetup = Builder.getText(setupEl);
                Node nextSibling = setupEl.getNextSibling();
                e.removeChild(setupEl);
                Builder.build(e, this);
                e.insertBefore(setupEl, nextSibling);
            } else {
                Builder.build(e, this);
            }
            try {
                this.psize = new Dimension(Integer.parseInt(e.getAttribute(SLOT_WIDTH)), Integer.parseInt(e.getAttribute(SLOT_HEIGHT)));
            }
            catch (NumberFormatException setupEl) {
                // empty catch block
            }
            try {
                this.slotScale = Double.parseDouble(e.getAttribute(SCALE));
            }
            catch (NumberFormatException setupEl) {
                // empty catch block
            }
            try {
                this.maxColumns = Integer.parseInt(e.getAttribute(MAX_COLUMNS));
            }
            catch (NumberFormatException ex) {
                this.maxColumns = 0;
            }
            String value = e.getAttribute(DIALOG_TITLE);
            if (value != null && value.length() > 0) {
                this.title = value;
            }
            if ((value = e.getAttribute(BOARD_PROMPT)) != null && value.length() > 0) {
                this.boardPrompt = value;
            }
            Localization.getInstance().saveTranslatableAttribute(this, BOARD_PROMPT, this.boardPrompt);
            Localization.getInstance().saveTranslatableAttribute(this, DIALOG_TITLE, this.title);
        }
    }

    @Override
    public void validate(Buildable target, ValidationReport report) {
        if (this.possibleBoards.isEmpty()) {
            report.addWarning(Resources.getString("BoardPicker.must_define", ConfigureTree.getConfigureName(this.map)));
        }
        HashSet<String> names = new HashSet<String>();
        for (Board b : this.possibleBoards) {
            if (names.contains(b.getName())) {
                report.addWarning(Resources.getString("BoardPicker.more_than_one", b.getName(), ConfigureTree.getConfigureName(this.map)));
            }
            names.add(b.getName());
            if (b.getName() == null) {
                report.addWarning(Resources.getString("BoardPicker.no_name", ConfigureTree.getConfigureName(this.map)));
            }
            b.validate(b, report);
        }
    }

    private String getDefaultSetup() {
        Board b;
        String s = this.defaultSetup;
        if (!(this.defaultSetup != null && this.defaultSetup.length() != 0 || this.possibleBoards.size() != 1 || "true".equals((b = this.possibleBoards.get(0)).getAttributeValueString("reversible")))) {
            s = this.encode(new SetBoards(this, Collections.singletonList(b)));
        }
        return s;
    }

    @Override
    public void add(Buildable b) {
        if (b instanceof Board) {
            this.possibleBoards.add((Board)b);
        }
        if (b instanceof Translatable) {
            ((Translatable)b).getI18nData().setOwningComponent(this);
        }
        super.add(b);
    }

    @Override
    public void remove(Buildable b) {
        this.buildComponents.remove(b);
        if (b instanceof Board) {
            this.possibleBoards.remove(b);
        }
    }

    @Override
    public void removeFrom(Buildable parent) {
        GameModule.getGameModule().getGameState().removeGameSetupStep(this);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.BoardPicker.component_type");
    }

    @Override
    public String getConfigureName() {
        return null;
    }

    public String getBoardDelimiter() {
        return "bd\t";
    }

    @Override
    public HelpFile getHelpFile() {
        return null;
    }

    @Override
    public Configurer getConfigurer() {
        return new Config();
    }

    @Override
    public Configurable[] getConfigureComponents() {
        return this.possibleBoards.toArray(new Configurable[0]);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{Board.class};
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void setBoards(Collection<Board> c) {
        this.reset();
        for (Board b : c) {
            if (b.relativePosition().x > this.nx - 1) {
                this.addColumn();
            }
            if (b.relativePosition().y <= this.ny - 1) continue;
            this.addRow();
        }
        for (Board b : c) {
            this.getSlot(b.relativePosition().x + this.nx * b.relativePosition().y).setBoard(b);
        }
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public void setBoards(Enumeration<Board> bdEnum) {
        ProblemDialog.showDeprecated("2020-08-06");
        this.setBoards(Collections.list(bdEnum));
    }

    protected void selectBoards(Component c) {
        this.reset();
        JDialog d = new JDialog((Frame)null, true);
        d.setDefaultCloseOperation(2);
        Box b = Box.createVerticalBox();
        Box buttons = Box.createHorizontalBox();
        JButton ok = new JButton(Resources.getString("General.ok"));
        ok.addActionListener(e -> {
            List<Board> l = this.getBoardsFromControls();
            this.defaultSetup = l.isEmpty() ? null : this.encode(new SetBoards(this, l));
            d.dispose();
        });
        buttons.add(ok);
        JButton cancel = new JButton(Resources.getString("General.cancel"));
        cancel.addActionListener(e -> d.dispose());
        buttons.add(cancel);
        b.add(this.controls);
        b.add(buttons);
        d.add(b);
        d.pack();
        d.setLocationRelativeTo(c);
        d.setVisible(true);
        this.currentBoards = new ArrayList<Board>(this.getBoardsFromControls());
    }

    public Collection<Board> getSelectedBoards() {
        if (this.currentBoards == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.currentBoards);
    }

    public List<String> getSelectedBoardNames() {
        if (this.currentBoards == null) {
            return Collections.emptyList();
        }
        return this.currentBoards.stream().map(Board::getName).collect(Collectors.toList());
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public Enumeration<Board> getCurrentBoards() {
        ProblemDialog.showDeprecated("2020-08-06");
        return Collections.enumeration(this.getSelectedBoards());
    }

    public String[] getAllowableBoardNames() {
        ArrayList<String> s = new ArrayList<String>(this.possibleBoards.size());
        for (Board b : this.possibleBoards) {
            s.add(b.getName());
        }
        return s.toArray(new String[0]);
    }

    public String[] getAllowableLocalizedBoardNames() {
        ArrayList<String> s = new ArrayList<String>(this.possibleBoards.size());
        for (Board b : this.possibleBoards) {
            s.add(b.getLocalizedName());
        }
        return s.toArray(new String[0]);
    }

    public Board getBoard(String boardName) {
        return this.getBoard(boardName, false);
    }

    public Board getLocalizedBoard(String localizedBoardName) {
        return this.getBoard(localizedBoardName, true);
    }

    protected Board getBoard(String boardName, boolean localized) {
        for (Board b : this.possibleBoards) {
            String checkName = localized ? b.getLocalizedName() : b.getName();
            if (!checkName.equals(boardName)) continue;
            return b;
        }
        this.warn(Resources.getString("BoardPicker.board_not_found", boardName));
        return null;
    }

    @Override
    public void setup(boolean show) {
        if (show) {
            Command c;
            String setup;
            if (this.currentBoards == null && (setup = this.getDefaultSetup()) != null && (c = this.decode(setup)) != null) {
                c.execute();
            }
            this.map.setBoards(this.getSelectedBoards());
        } else {
            this.currentBoards = null;
        }
    }

    @Override
    public void finish() {
        this.currentBoards = new ArrayList<Board>(this.getBoardsFromControls());
        this.map.setBoards(this.getSelectedBoards());
    }

    @Override
    public Component getControls() {
        this.reset();
        return this.controls;
    }

    @Override
    public String getStepTitle() {
        return this.title;
    }

    @Override
    public boolean isFinished() {
        return this.currentBoards != null || this.getDefaultSetup() != null;
    }

    @Override
    public Command getRestoreCommand() {
        return new SetBoards(this, this.currentBoards);
    }

    protected JButton addButton(String s) {
        return this.addButton(s, -1);
    }

    protected JButton addButton(String s, int index) {
        JButton b = new JButton(s);
        b.addActionListener(this);
        this.toolbar.add(b, null, index);
        return b;
    }

    protected void addRow() {
        this.slotPanel.setLayout(new GridLayout(++this.ny, this.nx));
        for (int i = 0; i < this.nx; ++i) {
            this.slotPanel.add((Component)new BoardSlot(this, this.boardPrompt), -1);
        }
        this.slotPanel.revalidate();
    }

    protected void addColumn() {
        this.slotPanel.setLayout(new GridLayout(this.ny, ++this.nx));
        for (int j = 0; j < this.ny; ++j) {
            this.slotPanel.add((Component)new BoardSlot(this, this.boardPrompt), (j + 1) * this.nx - 1);
        }
        this.slotPanel.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.addColumnButton == e.getSource()) {
            if (this.maxColumns == 0 || this.nx < this.maxColumns) {
                this.addColumn();
            } else {
                this.addRow();
            }
        } else if (this.addRowButton == e.getSource()) {
            this.addRow();
        } else if (this.clearButton == e.getSource()) {
            this.reset();
        }
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public Vector<Board> pickBoards() {
        ProblemDialog.showDeprecated("2020-08-06");
        return new Vector<Board>(this.getBoardsFromControls());
    }

    public List<Board> getBoardsFromControls() {
        ArrayList<Board> boardList = new ArrayList<Board>();
        if (this.toolbar != null) {
            for (int i = 0; i < this.nx; ++i) {
                for (int j = 0; j < this.ny; ++j) {
                    Board b;
                    BoardSlot slot = this.getSlot(i + this.nx * j);
                    if (slot == null || (b = slot.getBoard()) == null) continue;
                    b.relativePosition().move(i, j);
                    boardList.add(b);
                }
            }
        }
        return boardList;
    }

    public void reset() {
        if (this.toolbar == null) {
            this.initComponents();
        } else {
            this.warn("");
            this.removeAllBoards();
            this.slotPanel.add((Component)new BoardSlot(this, this.boardPrompt), 0);
        }
        this.controls.revalidate();
    }

    public int getRowCount() {
        return this.ny;
    }

    public int getColumnCount() {
        return this.ny;
    }

    public BoardSlot getNeighbor(BoardSlot slot, int dx, int dy) {
        int x = -1;
        int y = -1;
        block0: for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                if (this.getSlot(i + j * this.nx) == slot) {
                    x = i;
                    y = j;
                    continue block0;
                }
                if (x >= 0 && y >= 0) continue block0;
            }
        }
        if ((x += dx) < 0 || x >= this.nx || (y += dy) < 0 || y >= this.ny) {
            return null;
        }
        int index = x + y * this.nx;
        if (index < 0 || index >= this.nx * this.ny) {
            return null;
        }
        return this.getSlot(index);
    }

    public BoardSlot getSlot(int i) {
        return i >= 0 && i < this.slotPanel.getComponentCount() ? (BoardSlot)this.slotPanel.getComponent(i) : null;
    }

    public void repaintAll() {
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                this.getSlot(i + this.nx * j).repaint();
            }
        }
    }

    protected void removeAllBoards() {
        this.slotPanel.removeAll();
        this.slotPanel.setLayout(new GridLayout(1, 1));
        this.ny = 1;
        this.nx = 1;
    }

    public boolean isAllowMultiple() {
        return this.allowMultiple;
    }

    public void setAllowMultiple(boolean val) {
        this.allowMultiple = val;
        if (this.multipleButtons != null) {
            for (JButton b : this.multipleButtons) {
                b.setVisible(this.allowMultiple);
            }
        }
    }

    @Override
    public Element getBuildElement(Document doc) {
        Element el = doc.createElement(this.getClass().getName());
        el.setAttribute(SLOT_WIDTH, String.valueOf(this.psize.width));
        el.setAttribute(SLOT_HEIGHT, String.valueOf(this.psize.height));
        el.setAttribute(SCALE, String.valueOf(this.getSlotScale()));
        el.setAttribute(DIALOG_TITLE, this.title);
        el.setAttribute(ADD_ROW_BUTTON_TEXT, this.addRowButtonText);
        el.setAttribute(ADD_COLUMN_BUTTON_TEXT, this.addColumnButtonText);
        el.setAttribute(BOARD_PROMPT, this.boardPrompt);
        if (this.maxColumns > 0) {
            el.setAttribute(MAX_COLUMNS, String.valueOf(this.maxColumns));
        }
        if (this.defaultSetup != null) {
            Element setupEl = doc.createElement(SETUP);
            setupEl.appendChild(doc.createTextNode(this.defaultSetup));
            el.appendChild(setupEl);
        }
        for (Board b : this.possibleBoards) {
            el.appendChild(b.getBuildElement(doc));
        }
        return el;
    }

    @Override
    public Command decode(String command) {
        if (command.startsWith(this.map.getId() + ID) || command.startsWith(this.map.getConfigureName() + ID)) {
            ArrayList<Board> bds = new ArrayList<Board>();
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(command, '\t');
            st.nextToken();
            while (st.hasMoreTokens()) {
                SequenceEncoder.Decoder st2 = new SequenceEncoder.Decoder(st.nextToken(), '/');
                String name = st2.nextToken();
                boolean reversed = false;
                if (st2.hasMoreTokens()) {
                    reversed = "rev".equals(st2.nextToken());
                }
                Point p = new Point(st.nextInt(0), st.nextInt(0));
                Board b = this.getBoard(name);
                if (b == null) continue;
                if (bds.contains(b)) {
                    b = b.copy();
                }
                b.setReversed(reversed);
                b.relativePosition().move(p.x, p.y);
                bds.add(b);
            }
            return new SetBoards(this, bds);
        }
        return null;
    }

    @Override
    public String encode(Command c) {
        if (c instanceof SetBoards && this.map != null && ((SetBoards)c).target == this) {
            SequenceEncoder se = new SequenceEncoder(this.map.getIdentifier() + ID, '\t');
            List<Board> bds = ((SetBoards)c).boards;
            if (bds != null) {
                for (Board b : bds) {
                    if (b.getName() == null) continue;
                    SequenceEncoder se2 = new SequenceEncoder(b.getName(), '/');
                    if (b.isReversed()) {
                        se2.append("rev");
                    }
                    se.append(se2.getValue()).append(b.relativePosition().x).append(b.relativePosition().y);
                }
            }
            return se.getValue();
        }
        return null;
    }

    @Override
    public ComponentI18nData getI18nData() {
        if (this.myI18nData == null) {
            this.myI18nData = new ComponentI18nData(this, "", null, new String[]{DIALOG_TITLE, BOARD_PROMPT}, new boolean[]{true, true}, new String[]{Resources.getString("Editor.BoardPicker.dialog_title"), Resources.getString("Editor.BoardPicker.board_prompt")});
        }
        return this.myI18nData;
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (DIALOG_TITLE.equals(key)) {
            this.title = (String)value;
        } else if (BOARD_PROMPT.equals(key)) {
            this.boardPrompt = (String)value;
        }
    }

    @Override
    public String getAttributeValueString(String attr) {
        if (DIALOG_TITLE.equals(attr)) {
            return this.title;
        }
        if (BOARD_PROMPT.equals(attr)) {
            return this.boardPrompt;
        }
        return null;
    }

    public void repaint() {
        if (this.controls != null) {
            this.controls.repaint();
        }
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public void pack() {
        ProblemDialog.showDeprecated("2020-08-06");
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    public static class SetBoards
    extends Command {
        private final BoardPicker target;
        private final List<Board> boards;

        public SetBoards(BoardPicker picker, List<Board> bds) {
            this.target = picker;
            this.boards = bds;
        }

        @Deprecated(since="2020-08-06", forRemoval=true)
        public SetBoards(BoardPicker target, Vector<Board> boards) {
            ProblemDialog.showDeprecated("2020-08-06");
            this.target = target;
            this.boards = boards;
        }

        @Override
        protected void executeCommand() {
            this.target.currentBoards = this.boards;
            if (GameModule.getGameModule().getGameState().isGameStarted()) {
                this.target.map.setBoards(this.target.getSelectedBoards());
                this.target.map.getView().revalidate();
            }
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }

    private class Config
    extends Configurer {
        private final JPanel controls;

        public Config() {
            super(null, null);
            this.controls = new JPanel();
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            StringConfigurer title = new StringConfigurer(null, Resources.getString("Editor.BoardPicker.dialog_title"), BoardPicker.this.title);
            title.addPropertyChangeListener(evt -> {
                if (evt.getNewValue() != null) {
                    BoardPicker.this.title = (String)evt.getNewValue();
                }
            });
            this.controls.add(title.getControls());
            StringConfigurer prompt = new StringConfigurer(null, Resources.getString("Editor.BoardPicker.board_prompt"), BoardPicker.this.boardPrompt);
            prompt.addPropertyChangeListener(evt -> {
                if (evt.getNewValue() != null) {
                    BoardPicker.this.boardPrompt = (String)evt.getNewValue();
                }
            });
            this.controls.add(prompt.getControls());
            DoubleConfigurer scale = new DoubleConfigurer(null, Resources.getString("Editor.BoardPicker.cell_scale_factor"), BoardPicker.this.slotScale);
            scale.addPropertyChangeListener(evt -> {
                if (evt.getNewValue() != null) {
                    BoardPicker.this.slotScale = (Double)evt.getNewValue();
                }
            });
            this.controls.add(scale.getControls());
            IntConfigurer width = new IntConfigurer(null, Resources.getString("Editor.BoardPicker.cell_width"), (Integer)BoardPicker.this.psize.width);
            width.addPropertyChangeListener(evt -> {
                if (evt.getNewValue() != null) {
                    BoardPicker.this.psize.width = (Integer)evt.getNewValue();
                }
            });
            this.controls.add(width.getControls());
            IntConfigurer height = new IntConfigurer(null, Resources.getString("Editor.BoardPicker.cell_height"), (Integer)BoardPicker.this.psize.height);
            height.addPropertyChangeListener(evt -> {
                if (evt.getNewValue() != null) {
                    BoardPicker.this.psize.height = (Integer)evt.getNewValue();
                }
            });
            this.controls.add(height.getControls());
            JButton selectButton = new JButton(Resources.getString("BoardPicker.select_default"));
            selectButton.addActionListener(e -> BoardPicker.this.selectBoards(e.getSource() instanceof Component ? (Component)e.getSource() : null));
            this.controls.add(selectButton);
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getValueString() {
            return null;
        }

        @Override
        public void setValue(String s) {
        }
    }
}

