/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.metadata;

import VASSAL.build.GameModule;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.i18n.Resources;
import VASSAL.tools.io.FileArchive;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SaveMetaData
extends AbstractMetaData {
    private static final Logger logger = LoggerFactory.getLogger(SaveMetaData.class);
    public static final String ZIP_ENTRY_NAME = "savedata";
    public static final String DATA_VERSION = "1";
    public static final String PROMPT_LOG_COMMENT = "promptLogComment";
    protected ModuleMetaData moduleData;

    public SaveMetaData() {
        String comments = "";
        if (((Boolean)GameModule.getGameModule().getPrefs().getValue(PROMPT_LOG_COMMENT)).booleanValue()) {
            comments = (String)JOptionPane.showInputDialog(GameModule.getGameModule().getPlayerWindow(), Resources.getString("BasicLogger.enter_comments"), Resources.getString("BasicLogger.log_file_comments"), -1, null, null, "");
            this.setDescription(new AbstractMetaData.Attribute("description", comments));
        }
    }

    public SaveMetaData(ZipFile zip) {
        this.read(zip);
    }

    public String getModuleName() {
        return this.moduleData == null ? "" : this.moduleData.getName();
    }

    public String getModuleVersion() {
        return this.moduleData == null ? "" : this.moduleData.getVersion();
    }

    public ModuleMetaData getModuleData() {
        return this.moduleData;
    }

    @Override
    public String getZipEntryName() {
        return ZIP_ENTRY_NAME;
    }

    @Override
    public String getMetaDataVersion() {
        return DATA_VERSION;
    }

    @Override
    public void save(FileArchive archive) throws IOException {
        super.save(archive);
        this.copyModuleMetadata(archive);
    }

    @Override
    protected void addElements(Document doc, Element root) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ZipFile zip) {
        try (ZipFile zipFile = zip;){
            ZipEntry data = zip.getEntry(this.getZipEntryName());
            if (data == null) {
                return;
            }
            AbstractMetaData.XMLHandler handler = new AbstractMetaData.XMLHandler();
            try (InputStream zin = zip.getInputStream(data);
                 BufferedInputStream in = new BufferedInputStream(zin);){
                XMLReader xMLReader = parser;
                synchronized (xMLReader) {
                    parser.setContentHandler(handler);
                    parser.setDTDHandler(handler);
                    parser.setEntityResolver(handler);
                    parser.setErrorHandler(handler);
                    parser.parse(new InputSource(in));
                }
            }
            this.moduleData = new ModuleMetaData(zip);
        }
        catch (IOException | SAXException e) {
            logger.error("", (Throwable)e);
        }
    }
}

