/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.HttpRequestWrapper;
import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.ServerStatus;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SimpleRoom;
import VASSAL.i18n.Resources;
import VASSAL.tools.SequenceEncoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.Range;

public class CgiServerStatus
implements ServerStatus {
    private static final long DAY = 86400000L;
    public static final String LAST_DAY = "Server.last_24_hours";
    public static final String LAST_WEEK = "Server.last_week";
    public static final String LAST_MONTH = "Server.last_month";
    private static final Map<String, Long> timeRanges = new HashMap<String, Long>();
    private static final String[] times = new String[]{Resources.getString("Server.last_24_hours"), Resources.getString("Server.last_week"), Resources.getString("Server.last_month")};
    private HttpRequestWrapper request;
    private SortedMap<Long, List<String[]>> records = new TreeMap<Long, List<String[]>>();
    private List<Range<Long>> requests = new ArrayList<Range<Long>>();

    public CgiServerStatus() {
        this.request = new HttpRequestWrapper("http://www.vassalengine.org/util/");
        timeRanges.put(Resources.getString(LAST_DAY), 86400000L);
        timeRanges.put(Resources.getString(LAST_WEEK), 604800000L);
        timeRanges.put(Resources.getString(LAST_MONTH), 2592000000L);
    }

    @Override
    public ServerStatus.ModuleSummary[] getStatus() {
        HashMap<String, ServerStatus.ModuleSummary> entries = new HashMap<String, ServerStatus.ModuleSummary>();
        try {
            for (String s : this.request.doGet("getCurrentConnections", new Properties())) {
                SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, '\t');
                try {
                    String moduleName = st.nextToken();
                    String roomName = st.nextToken();
                    String playerName = st.nextToken();
                    ServerStatus.ModuleSummary entry = entries.get(moduleName);
                    if (entry == null) {
                        entries.put(moduleName, this.createEntry(moduleName, roomName, playerName));
                        continue;
                    }
                    this.updateEntry(entry, roomName, playerName);
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.sortEntriesByModuleName(entries);
    }

    @Override
    public ServerStatus.ModuleSummary[] getHistory(String timeRange) {
        Long l = timeRanges.get(timeRange);
        return l != null ? this.getHistory(l) : new ServerStatus.ModuleSummary[]{};
    }

    @Override
    public String[] getSupportedTimeRanges() {
        return times;
    }

    private ServerStatus.ModuleSummary[] getHistory(long time) {
        String playerName;
        String moduleName;
        if (time <= 0L) {
            return this.getStatus();
        }
        long now = System.currentTimeMillis();
        Range req = Range.between((Comparable)Long.valueOf(now - time), (Comparable)Long.valueOf(now));
        ArrayList<Range> toRequest = new ArrayList<Range>();
        toRequest.add(req);
        for (Range<Long> y : this.requests) {
            Iterator<Object> i = toRequest.listIterator();
            while (i.hasNext()) {
                Range x = (Range)i.next();
                if (!x.isOverlappedBy(y)) continue;
                i.remove();
                long xl = (Long)x.getMinimum();
                long xr = (Long)x.getMaximum();
                long yl = (Long)y.getMinimum();
                long yr = (Long)y.getMaximum();
                if (xl < yl && yl <= xr) {
                    i.add(Range.between((Comparable)Long.valueOf(xl), (Comparable)Long.valueOf(yl)));
                }
                if (xl > yr || yr >= xr) continue;
                i.add(Range.between((Comparable)Long.valueOf(yr), (Comparable)Long.valueOf(xr)));
            }
        }
        for (Range i : toRequest) {
            for (String s : this.getInterval((Range<Long>)i)) {
                SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, '\t');
                try {
                    moduleName = st.nextToken();
                    String roomName = st.nextToken();
                    playerName = st.nextToken();
                    Long when = Long.valueOf(st.nextToken());
                    List l = this.records.computeIfAbsent(when, k -> new ArrayList());
                    l.add(new String[]{moduleName, roomName, playerName});
                }
                catch (NumberFormatException | NoSuchElementException e) {
                    e.printStackTrace();
                }
            }
            this.requests.add((Range<Long>)i);
        }
        for (int i = 0; i < this.requests.size(); ++i) {
            Range<Long> a = this.requests.get(i);
            for (int j = i + 1; j < this.requests.size(); ++j) {
                Range<Long> b = this.requests.get(j);
                if (!a.isOverlappedBy(b)) continue;
                long al = (Long)a.getMinimum();
                long ar = (Long)a.getMaximum();
                long bl = (Long)b.getMinimum();
                long br = (Long)b.getMaximum();
                this.requests.set(i, (Range<Long>)Range.between((Comparable)Long.valueOf(Math.min(al, bl)), (Comparable)Long.valueOf(Math.max(ar, br))));
                this.requests.remove(j--);
            }
        }
        HashMap<String, ServerStatus.ModuleSummary> entries = new HashMap<String, ServerStatus.ModuleSummary>();
        for (List<String[]> l : this.records.subMap((Long)req.getMinimum(), (Long)req.getMaximum()).values()) {
            for (String[] r : l) {
                moduleName = r[0];
                String roomName = r[1];
                playerName = r[2];
                ServerStatus.ModuleSummary entry = entries.get(moduleName);
                if (entry == null) {
                    entries.put(moduleName, this.createEntry(moduleName, roomName, playerName));
                    continue;
                }
                this.updateEntry(entry, roomName, playerName);
            }
        }
        return this.sortEntriesByModuleName(entries);
    }

    private ServerStatus.ModuleSummary[] sortEntriesByModuleName(Map<String, ServerStatus.ModuleSummary> entries) {
        ServerStatus.ModuleSummary[] e = entries.values().toArray(new ServerStatus.ModuleSummary[0]);
        Arrays.sort(e, new Comparator<ServerStatus.ModuleSummary>(){

            @Override
            public int compare(ServerStatus.ModuleSummary a, ServerStatus.ModuleSummary b) {
                return a.getModuleName().compareTo(b.getModuleName());
            }
        });
        return e;
    }

    private List<String> getInterval(Range<Long> i) {
        Properties p = new Properties();
        p.setProperty("start", Long.toString((Long)i.getMinimum()));
        p.setProperty("end", Long.toString((Long)i.getMaximum()));
        try {
            return this.request.doGet("getConnectionHistory", p);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ServerStatus.ModuleSummary updateEntry(ServerStatus.ModuleSummary entry, String roomName, String playerName) {
        SimpleRoom existingRoom = entry.getRoom(roomName);
        if (existingRoom == null) {
            existingRoom = new SimpleRoom(roomName);
            existingRoom.setPlayers(new Player[]{new SimplePlayer(playerName)});
            entry.addRoom(existingRoom);
        } else {
            existingRoom.addPlayer(new SimplePlayer(playerName));
        }
        return entry;
    }

    private ServerStatus.ModuleSummary createEntry(String moduleName, String roomName, String playerName) {
        SimpleRoom r = new SimpleRoom(roomName);
        r.setPlayers(new Player[]{new SimplePlayer(playerName)});
        return new ServerStatus.ModuleSummary(moduleName, new Room[]{r});
    }
}

