/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.build.GameModule;
import VASSAL.chat.HttpRequestWrapper;
import VASSAL.chat.jabber.JabberClient;
import VASSAL.configure.StringConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import VASSAL.tools.PropertiesEncoder;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.icon.IconFactory;
import VASSAL.tools.swing.Dialogs;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class ServerAddressBook {
    public static final String CURRENT_SERVER = "currentServer";
    protected static final String ADDRESS_PREF = "ServerAddressBook";
    protected static final String LEGACY_TYPE = "node";
    protected static final String DYNAMIC_TYPE = "dynamic";
    protected static final String JABBER_TYPE = "jabber";
    protected static final String P2P_TYPE = "peer2peer";
    @Deprecated(since="2020-08-17", forRemoval=true)
    protected static final String P2P_MODE_KEY = "mode";
    @Deprecated(since="2020-08-17", forRemoval=true)
    protected static final String P2P_SERVER_MODE = "server";
    @Deprecated(since="2020-08-16", forRemoval=true)
    protected static final String P2P_CLIENT_MODE = "client";
    protected static final String TYPE_KEY = "type";
    protected static final String DESCRIPTION_KEY = "description";
    protected final int LEAF_ICON_SIZE = 1;
    protected final int CONTROLS_ICON_SIZE = 0;
    private boolean frozen;
    private JComponent controls;
    private StringConfigurer addressConfig;
    private JList<AddressBookEntry> myList;
    private DefaultListModel<AddressBookEntry> addressBook;
    private AddressBookEntry currentEntry;
    private boolean enabled = true;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private static ServerAddressBook instance;
    private static String localIPAddress;
    private static String externalIPAddress;
    private JButton addButton;
    private JButton removeButton;
    private JButton editButton;
    private JButton setButton;

    public static ServerAddressBook getInstance() {
        return instance;
    }

    public static void editCurrentServer(boolean connected) {
        instance.editCurrent(connected);
    }

    public static void changeServerPopup(JComponent source) {
        instance.showPopup(source);
    }

    public static String getLocalAddress() {
        if (localIPAddress == null) {
            try {
                localIPAddress = ServerAddressBook.getLocalHostLANAddress().getHostAddress();
            }
            catch (UnknownHostException e) {
                localIPAddress = "?";
            }
        }
        return localIPAddress;
    }

    public static String getExternalAddress() {
        return ServerAddressBook.getExternalAddress("?");
    }

    public static String getExternalAddress(String dflt) {
        if (externalIPAddress == null) {
            externalIPAddress = dflt;
            try {
                externalIPAddress = ServerAddressBook.discoverMyIpAddressFromRemote();
            }
            catch (IOException e) {
                externalIPAddress = "?";
            }
        }
        return externalIPAddress;
    }

    private static String discoverMyIpAddressFromRemote() throws IOException {
        String theIp = null;
        HttpRequestWrapper r = new HttpRequestWrapper("http://www.vassalengine.org/util/getMyAddress");
        List<String> l = r.doGet(null);
        if (l.isEmpty()) {
            throw new IOException(Resources.getString("Server.empty_response"));
        }
        theIp = l.get(0);
        return theIp;
    }

    private static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }

    public ServerAddressBook() {
        instance = this;
    }

    public JComponent getControls() {
        if (this.controls == null) {
            this.controls = new JPanel((LayoutManager)new MigLayout());
            this.addressConfig = new StringConfigurer(ADDRESS_PREF, null, "");
            Prefs.getGlobalPrefs().addOption(null, this.addressConfig);
            this.addressBook = new DefaultListModel();
            this.loadAddressBook();
            this.myList = new JList<AddressBookEntry>(this.addressBook);
            this.myList.setSelectionMode(0);
            this.myList.setCellRenderer(new MyRenderer());
            this.myList.addListSelectionListener(e -> this.updateButtonVisibility());
            this.myList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (ServerAddressBook.this.editButton.isEnabled() && e.getClickCount() == 2 && SwingUtils.isMainMouseButtonDown(e)) {
                        int index = ServerAddressBook.this.myList.locationToIndex(e.getPoint());
                        ServerAddressBook.this.editServer(index);
                    }
                }
            });
            JScrollPane scroll = new JScrollPane(this.myList);
            this.myList.repaint();
            this.controls.add((Component)scroll, "grow, push, w 500, h 400, wrap, span 4");
            this.setButton = new JButton(Resources.getString("ServerAddressBook.set_current"));
            this.setButton.setToolTipText(Resources.getString("ServerAddressBook.set_selected_server"));
            this.setButton.addActionListener(e -> this.setCurrentServer(this.myList.getSelectedIndex()));
            this.addButton = new JButton(Resources.getString("General.add"));
            this.addButton.setToolTipText(Resources.getString("ServerAddressBook.add_jabber_server"));
            this.addButton.addActionListener(e -> this.addServer());
            this.removeButton = new JButton(Resources.getString("General.remove"));
            this.removeButton.setToolTipText(Resources.getString("ServerAddressBook.remove_selected_server"));
            this.removeButton.addActionListener(e -> this.removeServer(this.myList.getSelectedIndex()));
            this.editButton = new JButton(Resources.getString("General.edit"));
            this.editButton.setToolTipText(Resources.getString("ServerAddressBook.edit_server"));
            this.editButton.addActionListener(e -> this.editServer(this.myList.getSelectedIndex()));
            this.controls.add((Component)this.addButton, "grow, push");
            this.controls.add((Component)this.editButton, "grow, push");
            this.controls.add((Component)this.removeButton, "grow, push");
            this.controls.add((Component)this.setButton, "grow, push");
            this.updateButtonVisibility();
        }
        return this.controls;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
        this.updateButtonVisibility();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setFrozen(boolean b) {
        this.frozen = b;
    }

    private void updateButtonVisibility() {
        int index = this.myList.getSelectedIndex();
        if (index >= 0) {
            AddressBookEntry e = this.addressBook.get(index);
            this.editButton.setEnabled(e.isEditable() && (this.isEnabled() || !e.isCurrent()));
            this.removeButton.setEnabled(e.isRemovable() && !e.isCurrent());
            this.setButton.setEnabled(this.isEnabled() && !e.isCurrent());
        } else {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.setButton.setEnabled(false);
        }
    }

    public void setCurrentServer(Properties p) {
        int index = 0;
        String type = p.getProperty(TYPE_KEY);
        String dtype = p.getProperty(DYNAMIC_TYPE);
        Enumeration<AddressBookEntry> e = this.addressBook.elements();
        while (e.hasMoreElements()) {
            AddressBookEntry entry = e.nextElement();
            Properties ep = entry.getProperties();
            if (ep.equals(p)) {
                this.setCurrentServer(index);
                return;
            }
            if (DYNAMIC_TYPE.equals(type) && DYNAMIC_TYPE.equals(ep.getProperty(TYPE_KEY)) && ep.getProperty(DYNAMIC_TYPE).equals(dtype)) {
                this.setCurrentServer(index);
                return;
            }
            if (P2P_TYPE.equals(type) && P2P_TYPE.equals(ep.getProperty(TYPE_KEY))) {
                this.setCurrentServer(index);
            }
            ++index;
        }
        AddressBookEntry newEntry = this.buildEntry(p);
        if (newEntry != null) {
            this.addressBook.addElement(newEntry);
            this.setCurrentServer(this.addressBook.indexOf(newEntry));
        }
        this.saveAddressBook();
    }

    private void setCurrentServer(AddressBookEntry e) {
        this.setCurrentServer(this.addressBook.indexOf(e));
    }

    private void setCurrentServer(int index) {
        AddressBookEntry e = this.addressBook.get(index);
        if (this.currentEntry != null) {
            this.currentEntry.setCurrent(false);
        }
        Properties oldProps = this.currentEntry == null ? null : this.currentEntry.getProperties();
        this.currentEntry = e;
        this.currentEntry.setCurrent(true);
        if (!this.frozen) {
            this.changeSupport.firePropertyChange(CURRENT_SERVER, oldProps, e.getProperties());
        }
        this.updateButtonVisibility();
        this.myList.repaint();
    }

    protected Properties getCurrentServerProperties() {
        return this.currentEntry.getProperties();
    }

    public void showPopup(JComponent source) {
        JPopupMenu popup = new JPopupMenu();
        Enumeration<AddressBookEntry> e = this.addressBook.elements();
        while (e.hasMoreElements()) {
            AddressBookEntry entry = e.nextElement();
            JMenuItem item = new JMenuItem(entry.toString());
            MenuAction action = new MenuAction(entry);
            item.setAction(action);
            item.setIcon(entry.getIcon(1));
            popup.add(item);
        }
        popup.show(source, 0, 0);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    public Icon getCurrentIcon() {
        return this.currentEntry.getIcon(0);
    }

    public String getCurrentDescription() {
        return this.currentEntry.toString();
    }

    private void editCurrent(boolean connected) {
        if (this.currentEntry != null) {
            this.editServer(this.addressBook.indexOf(this.currentEntry), connected);
        }
    }

    private void editServer(int index) {
        this.editServer(index, true);
    }

    private void editServer(int index, boolean enabled) {
        AddressBookEntry e = this.addressBook.get(index);
        boolean current = e.equals(this.currentEntry);
        Properties oldProps = e.getProperties();
        if (e.edit(enabled) && current) {
            this.changeSupport.firePropertyChange(CURRENT_SERVER, oldProps, e.getProperties());
        }
    }

    private void removeServer(int index) {
        AddressBookEntry e = this.addressBook.get(index);
        int i = JOptionPane.showConfirmDialog(GameModule.getGameModule().getPlayerWindow(), Resources.getString("ServerAddressBook.remove_server", e.getDescription()));
        if (i == 0) {
            this.addressBook.remove(index);
            this.myList.setSelectedIndex(-1);
            this.myList.repaint();
            this.updateButtonVisibility();
            this.saveAddressBook();
        }
    }

    private void addServer() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem p2pItem = new JMenuItem(Resources.getString("ServerAddressBook.peer_server"));
        p2pItem.addActionListener(e -> this.addEntry(new PeerServerEntry()));
        JMenuItem jabItem = new JMenuItem(Resources.getString("ServerAddressBook.jabber_server"));
        jabItem.addActionListener(e -> this.addEntry(new JabberEntry()));
        popup.add(p2pItem);
        popup.add(jabItem);
        popup.show(this.addButton, 0, 0);
    }

    private void addEntry(AddressBookEntry e) {
        if (e.edit()) {
            this.addressBook.addElement(e);
            this.saveAddressBook();
        }
    }

    public Properties getDefaultServerProperties() {
        return new LegacyEntry().getProperties();
    }

    private void loadAddressBook() {
        this.decodeAddressBook(this.addressConfig.getValueString());
        DefaultListModel<AddressBookEntry> newAddressBook = new DefaultListModel<AddressBookEntry>();
        Enumeration<AddressBookEntry> e = this.addressBook.elements();
        while (e.hasMoreElements()) {
            AddressBookEntry entry = e.nextElement();
            if (entry instanceof LegacyEntry) {
                newAddressBook.add(0, entry);
                continue;
            }
            newAddressBook.addElement(entry);
        }
        this.addressBook = newAddressBook;
        boolean legacy = false;
        boolean jabber = false;
        boolean peerServer = false;
        boolean updated = false;
        Enumeration<AddressBookEntry> e2 = this.addressBook.elements();
        while (e2.hasMoreElements()) {
            AddressBookEntry entry = e2.nextElement();
            if (entry instanceof LegacyEntry) {
                legacy = true;
                continue;
            }
            if (entry instanceof VassalJabberEntry) {
                jabber = true;
                continue;
            }
            if (!(entry instanceof PeerServerEntry)) continue;
            peerServer = true;
        }
        if (!jabber) {
            VassalJabberEntry entry = new VassalJabberEntry();
            entry.setCurrent(true);
            this.currentEntry = entry;
            this.addressBook.addElement(entry);
            updated = true;
        }
        if (!legacy) {
            this.addressBook.addElement(new LegacyEntry());
            updated = true;
        }
        if (!peerServer) {
            this.addressBook.addElement(new PeerServerEntry());
            updated = true;
        }
        if (updated) {
            this.saveAddressBook();
        }
    }

    private void saveAddressBook() {
        this.addressConfig.setValue(this.encodeAddressBook());
        if (this.myList != null) {
            this.myList.repaint();
        }
    }

    private String encodeAddressBook() {
        SequenceEncoder se = new SequenceEncoder(',');
        Enumeration<AddressBookEntry> e = this.addressBook.elements();
        while (e.hasMoreElements()) {
            AddressBookEntry entry = e.nextElement();
            if (entry == null) continue;
            se.append(entry.encode());
        }
        return se.getValue();
    }

    private void decodeAddressBook(String s) {
        this.addressBook.clear();
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ',');
        while (sd.hasMoreTokens()) {
            AddressBookEntry entry;
            String token = sd.nextToken("");
            if (token.length() <= 0 || (entry = this.buildEntry(token)) == null) continue;
            this.addressBook.addElement(this.buildEntry(token));
        }
    }

    private AddressBookEntry buildEntry(String s) {
        Properties newProperties = new Properties();
        try {
            newProperties = new PropertiesEncoder(s).getProperties();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.buildEntry(newProperties);
    }

    private AddressBookEntry buildEntry(Properties newProperties) {
        String type = newProperties.getProperty(TYPE_KEY);
        if (JABBER_TYPE.equals(type)) {
            return new JabberEntry(newProperties);
        }
        if (DYNAMIC_TYPE.equals(type)) {
            String dtype = newProperties.getProperty(DYNAMIC_TYPE);
            if (JABBER_TYPE.equals(dtype)) {
                return new VassalJabberEntry(newProperties);
            }
            if (LEGACY_TYPE.equals(dtype)) {
                return new LegacyEntry(newProperties);
            }
        } else if (P2P_TYPE.equals(type)) {
            return new PeerServerEntry(newProperties);
        }
        return null;
    }

    private class MyRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        private Font standardFont;
        private Font highlightFont;

        private MyRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (this.standardFont == null) {
                this.standardFont = this.getFont();
                this.highlightFont = new Font(this.standardFont.getFamily(), 3, this.standardFont.getSize());
            }
            if (value instanceof AddressBookEntry) {
                AddressBookEntry e = (AddressBookEntry)value;
                this.setIcon(e.getIcon(1));
                if (e.isCurrent()) {
                    this.setFont(this.highlightFont);
                    this.setText(e + Resources.getString("ServerAddressBook.current"));
                } else {
                    this.setFont(this.standardFont);
                }
            }
            return this;
        }
    }

    private abstract class AddressBookEntry
    implements Comparable<AddressBookEntry> {
        protected Properties properties = new Properties();
        protected boolean current;

        protected AddressBookEntry() {
            this(new Properties());
        }

        protected AddressBookEntry(Properties props) {
            this.properties = props;
        }

        protected String getDescription() {
            return this.getProperty(ServerAddressBook.DESCRIPTION_KEY);
        }

        protected void setDescription(String desc) {
            this.properties.setProperty(ServerAddressBook.DESCRIPTION_KEY, desc);
        }

        public String getProperty(String key) {
            return this.properties.getProperty(key);
        }

        public void setProperty(String key, String value) {
            this.properties.setProperty(key, value);
        }

        protected boolean isRemovable() {
            return true;
        }

        protected boolean isEditable() {
            return true;
        }

        protected abstract String getIconName();

        protected Icon getIcon(int size) {
            return IconFactory.getIcon(this.getIconName(), size);
        }

        public String getType() {
            return this.properties.getProperty(ServerAddressBook.TYPE_KEY);
        }

        public void setType(String t) {
            this.properties.setProperty(ServerAddressBook.TYPE_KEY, t);
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void setProperties(Properties p) {
            this.properties = p;
        }

        public String encode() {
            return new PropertiesEncoder(this.properties).getStringValue();
        }

        @Override
        public int compareTo(AddressBookEntry target) {
            if (this.getType().equals(target.getType())) {
                return this.getDescription().compareTo(target.getDescription());
            }
            return this.getType().compareTo(target.getType());
        }

        public boolean isCurrent() {
            return this.current;
        }

        public void setCurrent(boolean b) {
            this.current = b;
        }

        protected boolean isDescriptionEditable() {
            return true;
        }

        public boolean edit() {
            return this.edit(true);
        }

        public boolean edit(boolean enabled) {
            if (this.isEditable()) {
                ServerConfig config = this.getEditor(this.getProperties(), enabled);
                Integer result = (Integer)Dialogs.showDialog(null, Resources.getString("ServerAddressBook.edit_server_configuration"), config.getControls(), -1, null, 2, null, null, null, null);
                if (result != null && result == 0) {
                    if (enabled) {
                        this.setProperties(config.getProperties());
                        ServerAddressBook.this.saveAddressBook();
                    }
                    return true;
                }
            }
            return false;
        }

        protected abstract void setAdditionalProperties(Properties var1);

        protected abstract void getAdditionalProperties(Properties var1);

        protected abstract void addAdditionalControls(JComponent var1, boolean var2);

        public ServerConfig getEditor(Properties p, boolean enabled) {
            return new ServerConfig(p, this, enabled);
        }

        class ServerConfig {
            protected JComponent configControls;
            protected JTextField description = new JTextField();
            protected AddressBookEntry entry;
            boolean enabled;

            public ServerConfig() {
            }

            public ServerConfig(Properties props, AddressBookEntry entry, boolean enabled) {
                this();
                this.entry = entry;
                this.enabled = enabled;
                this.description.setText(props.getProperty(ServerAddressBook.DESCRIPTION_KEY));
                this$1.setAdditionalProperties(props);
            }

            protected boolean isEnabled() {
                return this.enabled;
            }

            public JComponent getControls() {
                if (this.configControls == null) {
                    this.configControls = new JPanel();
                    this.configControls.setLayout((LayoutManager)new MigLayout("", "[align right]rel[]", ""));
                    this.configControls.add((Component)new JLabel(IconFactory.getIcon(this.entry.getIconName(), 3)), "span 2, align center, wrap");
                    this.configControls.add(new JLabel(Resources.getString("Editor.description_label")));
                    this.configControls.add((Component)this.description, "wrap, grow, push");
                    this.entry.addAdditionalControls(this.configControls, this.enabled);
                    this.description.setEditable(AddressBookEntry.this.isDescriptionEditable() && this.isEnabled());
                }
                return this.configControls;
            }

            public Properties getProperties() {
                Properties props = new Properties();
                props.setProperty(ServerAddressBook.DESCRIPTION_KEY, this.description.getText());
                AddressBookEntry.this.getAdditionalProperties(props);
                return props;
            }
        }
    }

    private class MenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private AddressBookEntry entry;

        public MenuAction(AddressBookEntry e) {
            super(e.toString());
            this.entry = e;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ServerAddressBook.getInstance().setCurrentServer(this.entry);
        }
    }

    private class LegacyEntry
    extends AddressBookEntry {
        public LegacyEntry() {
            this(new Properties());
            this.setDescription(Resources.getString("ServerAddressBook.legacy_server"));
            this.setType(ServerAddressBook.DYNAMIC_TYPE);
            this.setProperty(ServerAddressBook.DYNAMIC_TYPE, ServerAddressBook.LEGACY_TYPE);
        }

        public LegacyEntry(Properties props) {
            super(props);
        }

        public String toString() {
            return this.getDescription();
        }

        @Override
        protected String getIconName() {
            return "VASSAL";
        }

        @Override
        protected boolean isRemovable() {
            return false;
        }

        @Override
        protected boolean isEditable() {
            return false;
        }

        @Override
        protected boolean isDescriptionEditable() {
            return false;
        }

        @Override
        protected void addAdditionalControls(JComponent c, boolean enabled) {
        }

        @Override
        protected void getAdditionalProperties(Properties props) {
        }

        @Override
        protected void setAdditionalProperties(Properties props) {
        }
    }

    private class VassalJabberEntry
    extends AddressBookEntry {
        protected JTextField jabberUser;
        protected JTextField jabberPw;

        public VassalJabberEntry() {
            this(new Properties());
            this.setDescription("VASSAL" + Resources.getString("ServerAddressBook.jabber_server"));
            this.setType(ServerAddressBook.DYNAMIC_TYPE);
            this.setProperty(ServerAddressBook.DYNAMIC_TYPE, ServerAddressBook.JABBER_TYPE);
            this.setProperty("jabberLogin", "");
            this.setProperty("jabberPassword", "");
        }

        public VassalJabberEntry(Properties props) {
            super(props);
            this.jabberUser = new JTextField();
            this.jabberPw = new JTextField();
        }

        public String toString() {
            String login = this.getProperty("jabberLogin");
            String pw = this.getProperty("jabberPassword");
            Object details = login == null || login.isEmpty() || pw == null || pw.isEmpty() ? Resources.getString("ServerAddressBook.login_details_required") : this.getProperty("jabberLogin") + "/" + this.getProperty("jabberPassword");
            return this.getDescription() + " [" + (String)details + "]";
        }

        @Override
        protected boolean isRemovable() {
            return false;
        }

        @Override
        protected boolean isDescriptionEditable() {
            return false;
        }

        @Override
        protected String getIconName() {
            return "VASSAL-jabber";
        }

        @Override
        protected void setAdditionalProperties(Properties props) {
            this.setType(ServerAddressBook.DYNAMIC_TYPE);
            this.setProperty(ServerAddressBook.DYNAMIC_TYPE, ServerAddressBook.JABBER_TYPE);
            this.jabberUser.setText(props.getProperty("jabberLogin"));
            this.jabberPw.setText(props.getProperty("jabberPassword"));
        }

        @Override
        protected void getAdditionalProperties(Properties props) {
            props.setProperty(ServerAddressBook.TYPE_KEY, ServerAddressBook.DYNAMIC_TYPE);
            props.setProperty(ServerAddressBook.DYNAMIC_TYPE, ServerAddressBook.JABBER_TYPE);
            props.setProperty("jabberLogin", this.jabberUser.getText());
            props.setProperty("jabberPassword", this.jabberPw.getText());
        }

        @Override
        protected void addAdditionalControls(JComponent c, boolean enabled) {
            this.jabberUser.setEditable(enabled);
            this.jabberPw.setEditable(enabled);
            c.add(new JLabel(Resources.getString("ServerAddressBook.user_name")));
            c.add((Component)this.jabberUser, "wrap, grow, push");
            c.add(new JLabel(Resources.getString("ServerAddressBook.password")));
            c.add((Component)this.jabberPw, "wrap, grow, push");
        }
    }

    private class PeerServerEntry
    extends AddressBookEntry {
        private JTextField listenPort;
        private JTextField serverPw;

        public PeerServerEntry() {
            this.listenPort = new JTextField();
            this.serverPw = new JTextField();
            this.setDescription(Resources.getString("ServerAddressBook.peer_server"));
            this.setType(ServerAddressBook.P2P_TYPE);
            this.setProperty("listenPort", "5050");
            this.setProperty("serverPw", "xyzzy");
        }

        public PeerServerEntry(Properties props) {
            super(props);
            this.listenPort = new JTextField();
            this.serverPw = new JTextField();
        }

        public String toString() {
            return Resources.getString("ServerAddressBook.peer_server") + " [" + this.getProperty(ServerAddressBook.DESCRIPTION_KEY) + "]";
        }

        @Override
        public boolean isRemovable() {
            return true;
        }

        @Override
        protected boolean isDescriptionEditable() {
            return true;
        }

        @Override
        protected String getIconName() {
            return "network-server";
        }

        @Override
        protected void setAdditionalProperties(Properties p) {
            this.setType(ServerAddressBook.P2P_TYPE);
            this.listenPort.setText(p.getProperty("listenPort"));
            this.serverPw.setText(p.getProperty("serverPw"));
        }

        @Override
        protected void getAdditionalProperties(Properties props) {
            props.setProperty(ServerAddressBook.TYPE_KEY, ServerAddressBook.P2P_TYPE);
            props.setProperty("listenPort", this.listenPort.getText());
            props.setProperty("serverPw", this.serverPw.getText());
        }

        @Override
        protected void addAdditionalControls(JComponent c, boolean enabled) {
            this.listenPort.setEditable(enabled);
            c.add(new JLabel(Resources.getString("ServerAddressBook.listen_port")));
            c.add((Component)this.listenPort, "wrap, growx, push");
            this.serverPw.setEditable(enabled);
            c.add(new JLabel(Resources.getString("ServerAddressBook.server_password")));
            c.add((Component)this.serverPw, "wrap, growx, push");
            c.add(new JLabel(Resources.getString("Peer2Peer.internet_address")));
            JTextField externalIP = new JTextField(ServerAddressBook.getExternalAddress());
            externalIP.setEditable(false);
            c.add((Component)externalIP, "wrap, growx, push");
            if (!ServerAddressBook.getLocalAddress().equals(ServerAddressBook.getExternalAddress())) {
                c.add(new JLabel(Resources.getString("Peer2Peer.local_address")));
                JTextField localIP = new JTextField(ServerAddressBook.getLocalAddress());
                localIP.setEditable(false);
                c.add((Component)localIP, "wrap, growx, push");
            }
        }
    }

    private class JabberEntry
    extends AddressBookEntry {
        private JTextField jabberHost;
        private JTextField jabberPort;
        private JTextField jabberUser;
        private JTextField jabberPw;
        private JButton testButton;

        public JabberEntry() {
            this(new Properties());
            this.setType(ServerAddressBook.JABBER_TYPE);
            this.setDescription("");
            this.setProperty("jabberPort", "5222");
        }

        public JabberEntry(Properties props) {
            super(props);
            this.jabberHost = new JTextField();
            this.jabberPort = new JTextField();
            this.jabberUser = new JTextField();
            this.jabberPw = new JTextField();
        }

        public String toString() {
            return Resources.getString("ServerAddressBook.jabber_server") + " " + this.getDescription() + " [" + this.getProperty("jabberHost") + ":" + this.getProperty("jabberPort") + " " + this.getProperty("jabberLogin") + "/" + this.getProperty("jabberPassword") + "]";
        }

        @Override
        protected String getIconName() {
            return ServerAddressBook.JABBER_TYPE;
        }

        @Override
        protected boolean isDescriptionEditable() {
            return true;
        }

        @Override
        protected void setAdditionalProperties(Properties props) {
            this.jabberHost.setText(props.getProperty("jabberHost"));
            this.jabberPort.setText(props.getProperty("jabberPort"));
            this.jabberUser.setText(props.getProperty("jabberLogin"));
            this.jabberPw.setText(props.getProperty("jabberPassword"));
        }

        @Override
        protected void getAdditionalProperties(Properties props) {
            props.setProperty(ServerAddressBook.TYPE_KEY, ServerAddressBook.JABBER_TYPE);
            props.setProperty("jabberHost", this.jabberHost.getText());
            props.setProperty("jabberPort", this.jabberPort.getText());
            props.setProperty("jabberLogin", this.jabberUser.getText());
            props.setProperty("jabberPassword", this.jabberPw.getText());
        }

        @Override
        protected void addAdditionalControls(JComponent c, boolean enabled) {
            this.jabberHost.setEditable(enabled);
            this.jabberPort.setEditable(enabled);
            this.jabberUser.setEditable(enabled);
            this.jabberPw.setEditable(enabled);
            c.add(new JLabel(Resources.getString("ServerAddressBook.jabber_host")));
            c.add((Component)this.jabberHost, "wrap, grow, push");
            c.add(new JLabel(Resources.getString("ServerAddressBook.port")));
            c.add((Component)this.jabberPort, "wrap, grow, push");
            c.add(new JLabel(Resources.getString("ServerAddressBook.user_name")));
            c.add((Component)this.jabberUser, "wrap, grow, push");
            c.add(new JLabel(Resources.getString("ServerAddressBook.password")));
            c.add((Component)this.jabberPw, "wrap, grow, push");
            this.testButton = new JButton(Resources.getString("ServerAddressBook.test_connection"));
            this.testButton.addActionListener(e -> this.test());
            c.add((Component)this.testButton, "span 2, align center, wrap");
        }

        protected void test() {
            JTextArea result = new JTextArea(10, 30);
            result.setText(JabberClient.testConnection(this.jabberHost.getText(), this.jabberPort.getText(), this.jabberUser.getText(), this.jabberPw.getText()));
            try {
                Dialogs.showDialog(null, Resources.getString("ServerAddressBook.connection_test"), result, 1, null, 2, null, null, null, null);
            }
            catch (IllegalStateException ex) {
                ex.printStackTrace();
            }
        }
    }
}

