/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IpWatch
implements Runnable {
    private PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    private String currentIp;
    private long wait = 1000L;

    public IpWatch(long waitInterval) {
        this.wait = waitInterval;
        this.currentIp = this.findIp();
    }

    public IpWatch() {
        this(1000L);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propSupport.addPropertyChangeListener(l);
    }

    @Override
    public void run() {
        while (true) {
            String newIp = this.findIp();
            this.propSupport.firePropertyChange("address", this.currentIp, newIp);
            this.currentIp = newIp;
            try {
                Thread.sleep(this.wait);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public String getCurrentIp() {
        return this.currentIp;
    }

    private String findIp() {
        try {
            InetAddress[] a = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            StringBuilder buff = new StringBuilder();
            for (int i = 0; i < a.length; ++i) {
                buff.append(a[i].getHostAddress());
                if (i >= a.length - 1) continue;
                buff.append(",");
            }
            return buff.toString();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static void main(String[] args) {
        IpWatch w = new IpWatch();
        w.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                System.out.println("Address = " + evt.getNewValue());
            }
        });
        System.out.println("Address = " + w.getCurrentIp());
        new Thread(w).start();
    }
}

