/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.command;

import VASSAL.build.GameModule;
import VASSAL.command.Command;
import VASSAL.tools.ReadErrorDialog;
import java.io.IOException;

public class PlayAudioClipCommand
extends Command {
    public static final String COMMAND_PREFIX = "AUDIO\t";
    private String clipName;

    public PlayAudioClipCommand(String clipName) {
        this.clipName = clipName;
    }

    @Override
    protected void executeCommand() {
        try {
            GameModule.getGameModule().getDataArchive().getCachedAudioClip(this.clipName).play();
        }
        catch (IOException e) {
            ReadErrorDialog.error(e, this.clipName);
        }
    }

    @Override
    protected Command myUndoCommand() {
        return null;
    }

    public static PlayAudioClipCommand decode(String s) {
        if (s.startsWith(COMMAND_PREFIX)) {
            return new PlayAudioClipCommand(s.substring(COMMAND_PREFIX.length()));
        }
        return null;
    }

    public String encode() {
        return COMMAND_PREFIX + this.clipName;
    }
}

