/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.Configurer;
import VASSAL.configure.ShowHelpAction;
import VASSAL.launch.BasicModule;
import VASSAL.tools.ErrorDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropertiesWindow
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Configurer configurer;
    private Configurable target;
    private Element originalState;

    public PropertiesWindow(Frame owner, boolean modal, Configurable target, HelpWindow helpWindow) {
        super(owner, modal);
        this.initialize(target, helpWindow);
    }

    protected void initialize(Configurable target, HelpWindow helpWindow) {
        this.target = target;
        this.originalState = target.getBuildElement(Builder.createNewDocument());
        Node child = this.originalState.getFirstChild();
        while (child != null) {
            Node nextChild = child.getNextSibling();
            if (1 == child.getNodeType()) {
                try {
                    Class<?> c = GameModule.getGameModule().getDataArchive().loadClass(((Element)child).getTagName());
                    if (Buildable.class.isAssignableFrom(c)) {
                        this.originalState.removeChild(child);
                    }
                }
                catch (ClassNotFoundException c) {
                }
                catch (LinkageError e) {
                    ErrorDialog.bug(e);
                }
            }
            child = nextChild;
        }
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.configurer = target.getConfigurer();
        target.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("name".equals(evt.getPropertyName())) {
                    PropertiesWindow.this.setTitle((String)evt.getNewValue());
                }
            }
        });
        this.add(this.configurer.getControls());
        this.setTitle(ConfigureTree.getConfigureName(target));
        Box buttonBox = Box.createHorizontalBox();
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesWindow.this.save();
            }
        });
        buttonBox.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesWindow.this.cancel();
            }
        });
        buttonBox.add(cancelButton);
        if (target.getHelpFile() != null) {
            ShowHelpAction helpAction = new ShowHelpAction(target.getHelpFile().getContents(), null);
            JButton helpButton = new JButton(helpAction);
            buttonBox.add(helpButton);
            this.pack();
        }
        this.add(buttonBox);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                PropertiesWindow.this.cancel();
            }
        });
    }

    public void cancel() {
        if (this.target instanceof BasicModule) {
            this.target.setAttribute("name", this.originalState.getAttribute("name"));
            this.target.setAttribute("version", this.originalState.getAttribute("version"));
            this.target.setAttribute("description", this.originalState.getAttribute("description"));
        } else {
            this.target.build(this.originalState);
        }
        this.dispose();
    }

    public void save() {
        this.configurer.getValue();
        this.dispose();
    }
}

