/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.BadDataReport;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceFilter;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.ExpressionException;
import VASSAL.script.expression.NullExpression;
import VASSAL.script.expression.PropertyMatchExpression;
import VASSAL.tools.ErrorDialog;

public class PropertyExpression
implements PieceFilter {
    protected Expression expression = new NullExpression();

    public PropertyExpression() {
    }

    public PropertyExpression(String s) {
        this.setExpression(s);
    }

    public void setExpression(String s) {
        this.expression = Expression.createPropertyExpression(s);
    }

    public String getExpression() {
        return this.expression.getExpression();
    }

    public boolean isNull() {
        return this.expression == null || this.expression instanceof NullExpression;
    }

    public PieceFilter getFilter(PropertySource source) {
        return this.expression.getFilter(source);
    }

    public PieceFilter getFilter() {
        return this.expression.getFilter();
    }

    @Override
    public boolean accept(GamePiece piece) {
        if (this.expression instanceof PropertyMatchExpression) {
            return this.expression.getFilter(piece).accept(piece);
        }
        return this.isTrue(piece);
    }

    public boolean accept(GamePiece source, GamePiece piece) {
        return this.getFilter(source).accept(piece);
    }

    public boolean equals(Object o) {
        if (o instanceof PropertyExpression) {
            return this.getExpression().equals(((PropertyExpression)o).getExpression());
        }
        return false;
    }

    public boolean isTrue(PropertySource ps) {
        String result = null;
        try {
            result = this.expression.evaluate(ps);
        }
        catch (ExpressionException e) {
            ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Error.expression_error"), "Expression=" + this.getExpression() + ", Error=" + e.getError(), e));
        }
        return "true".equals(result);
    }
}

