/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.configure.Configurer;
import VASSAL.tools.AudioClip;
import VASSAL.tools.AudioSystemClip;
import VASSAL.tools.Mp3AudioClip;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.URLUtils;
import VASSAL.tools.filechooser.AudioFileFilter;
import VASSAL.tools.filechooser.FileChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SoundConfigurer
extends Configurer {
    public static final String DEFAULT = "default";
    private String defaultResource;
    private String clipName;
    private JPanel controls;
    private JTextField textField;
    private AudioClipFactory clipFactory;
    private static final String NO_VALUE = "<disabled>";

    public SoundConfigurer(String key, String name, String defaultResource) {
        super(key, name);
        this.defaultResource = defaultResource;
        this.clipFactory = this.createAudioClipFactory();
        this.setValue(DEFAULT);
    }

    @Override
    public Component getControls() {
        if (this.controls == null) {
            this.controls = new JPanel();
            this.controls.setLayout(new BoxLayout(this.controls, 0));
            this.controls.add(new JLabel(this.name));
            JButton b = new JButton("Play");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SoundConfigurer.this.play();
                }
            });
            this.controls.add(b);
            b = new JButton("Default");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SoundConfigurer.this.setValue(SoundConfigurer.DEFAULT);
                }
            });
            this.controls.add(b);
            b = new JButton("Select");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SoundConfigurer.this.chooseClip();
                }
            });
            this.controls.add(b);
            this.textField = new JTextField();
            this.textField.setMaximumSize(new Dimension(this.textField.getMaximumSize().width, this.textField.getPreferredSize().height));
            this.textField.setEditable(false);
            this.textField.setText(DEFAULT.equals(this.clipName) ? this.defaultResource : this.clipName);
            this.controls.add(this.textField);
        }
        return this.controls;
    }

    @Override
    public String getValueString() {
        String s = NO_VALUE;
        if (this.clipName != null) {
            s = this.clipName;
        }
        return s;
    }

    @Override
    public void setValue(String s) {
        if (this.clipFactory == null) {
            return;
        }
        URL url = null;
        if (DEFAULT.equals(s)) {
            url = this.getClass().getResource("/images/" + this.defaultResource);
            this.clipName = s;
        } else if (NO_VALUE.equals(s)) {
            this.clipName = s;
        } else if (s != null) {
            try {
                url = URLUtils.toURL(new File(s));
                this.clipName = s;
            }
            catch (MalformedURLException e) {
                ReadErrorDialog.error((IOException)e, s);
                this.clipName = null;
            }
        }
        if (this.textField != null) {
            this.textField.setText(DEFAULT.equals(this.clipName) ? this.defaultResource : this.clipName);
        }
        if (url != null) {
            try {
                this.setValue(this.clipFactory.getAudioClip(url));
            }
            catch (IOException e) {
                ReadErrorDialog.error(e, url.toString());
            }
        } else {
            if (this.textField != null) {
                this.textField.setText(null);
            }
            this.setValue((Object)null);
        }
    }

    protected AudioClipFactory createAudioClipFactory() {
        return new AudioClipFactory(){

            @Override
            public AudioClip getAudioClip(URL url) {
                AudioSystemClip audioSystemClip;
                block9: {
                    if (url.toString().toLowerCase().endsWith(".mp3")) {
                        return new Mp3AudioClip(url);
                    }
                    InputStream in = url.openStream();
                    try {
                        audioSystemClip = new AudioSystemClip(in);
                        if (in == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            return null;
                        }
                    }
                    in.close();
                }
                return audioSystemClip;
            }
        };
    }

    public void play() {
        AudioClip clip = (AudioClip)this.getValue();
        if (clip != null) {
            clip.play();
        }
    }

    public void chooseClip() {
        FileChooser fc = GameModule.getGameModule().getFileChooser();
        fc.setFileFilter(new AudioFileFilter());
        if (fc.showOpenDialog(this.getControls()) != 0) {
            this.setValue(NO_VALUE);
        } else {
            File f = fc.getSelectedFile();
            this.setValue(f.getName());
        }
    }

    protected static interface AudioClipFactory {
        public AudioClip getAudioClip(URL var1) throws IOException;
    }
}

