/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.Map;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import java.awt.Point;
import java.awt.Shape;
import java.util.Iterator;

public interface PieceFinder {
    public static final PieceFinder STACK_ONLY = new StackOnly();
    public static final PieceFinder PIECE_IN_STACK = new PieceInStack();
    public static final PieceFinder DECK_OR_PIECE_IN_STACK = new DeckOrPieceInStack();
    public static final PieceFinder MOVABLE = new Movable();

    public GamePiece select(Map var1, GamePiece var2, Point var3);

    public static class StackOnly
    extends Movable {
        @Override
        public Object visitDefault(GamePiece piece) {
            return null;
        }

        @Override
        public Object visitStack(Stack s) {
            GamePiece selected = (GamePiece)super.visitStack(s);
            if (selected != null && selected.getParent() == s) {
                selected = s;
            }
            return selected;
        }
    }

    public static class PieceInStack
    extends Movable {
        @Override
        public Object visitStack(Stack s) {
            GamePiece selected = (GamePiece)super.visitStack(s);
            if (selected == s && !s.isExpanded()) {
                selected = s.topPiece();
            }
            return selected;
        }
    }

    public static class DeckOrPieceInStack
    extends PieceInStack {
        @Override
        public Object visitDeck(Deck d) {
            Shape s = d.getShape();
            Point pos = d.getPosition();
            Point p = new Point(this.pt.x - pos.x, this.pt.y - pos.y);
            return s.contains(p) ? d : null;
        }
    }

    public static class Movable
    implements PieceFinder,
    DeckVisitor {
        protected Shape[] shapes = new Shape[0];
        protected Map map;
        protected Point pt;
        protected DeckVisitorDispatcher dispatcher = new DeckVisitorDispatcher(this);

        public Movable() {
            this(null, null);
        }

        public Movable(Map map, Point pt) {
            this.map = map;
            this.pt = pt;
        }

        @Override
        public Object visitDeck(Deck d) {
            return null;
        }

        @Override
        public Object visitDefault(GamePiece piece) {
            GamePiece selected = null;
            Shape s = piece.getShape();
            Point pos = piece.getPosition();
            Point p = new Point(this.pt.x - pos.x, this.pt.y - pos.y);
            if (s.contains(p)) {
                selected = piece;
            }
            return selected;
        }

        @Override
        public Object visitStack(Stack s) {
            GamePiece selected = null;
            if (this.shapes.length < s.getPieceCount()) {
                this.shapes = new Shape[s.getPieceCount()];
            }
            this.map.getStackMetrics().getContents(s, null, this.shapes, null, s.getPosition().x, s.getPosition().y);
            Iterator<GamePiece> i = s.getPiecesInVisibleOrderIterator();
            while (i.hasNext()) {
                GamePiece child = i.next();
                int index = s.indexOf(child);
                if (index < 0 || index >= this.shapes.length || !this.shapes[index].contains(this.pt)) continue;
                selected = s.isExpanded() ? child : s;
                break;
            }
            return selected;
        }

        @Override
        public GamePiece select(Map map, GamePiece piece, Point pt) {
            this.map = map;
            this.pt = pt;
            return (GamePiece)this.dispatcher.accept(piece);
        }
    }
}

