/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.NamedKeyStrokeArrayConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.PropertyExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LoopControl;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class TriggerAction
extends Decorator
implements TranslatablePiece,
RecursionLimiter.Loopable {
    public static final String ID = "macro;";
    protected String name = "";
    protected String command = "";
    protected NamedKeyStroke key = NamedKeyStroke.NULL_KEYSTROKE;
    protected PropertyExpression propertyMatch = new PropertyExpression();
    protected NamedKeyStroke[] watchKeys = new NamedKeyStroke[0];
    protected NamedKeyStroke[] actionKeys = new NamedKeyStroke[0];
    protected boolean loop = false;
    protected NamedKeyStroke preLoopKey = NamedKeyStroke.NULL_KEYSTROKE;
    protected NamedKeyStroke postLoopKey = NamedKeyStroke.NULL_KEYSTROKE;
    protected String loopType = "counted";
    protected PropertyExpression whileExpression = new PropertyExpression();
    protected PropertyExpression untilExpression = new PropertyExpression();
    protected FormattedString loopCount = new FormattedString("1");
    protected boolean index = false;
    protected String indexProperty = "";
    protected FormattedString indexStart = new FormattedString("1");
    protected FormattedString indexStep = new FormattedString("1");
    protected int indexValue = 0;
    protected GamePiece outer;

    public TriggerAction() {
        this(ID, null);
    }

    public TriggerAction(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.command.length() > 0 && this.key != null) {
            KeyCommand c = new KeyCommand(this.command, this.key, Decorator.getOutermost(this), this.matchesFilter());
            if (this.getMap() == null) {
                c.setEnabled(false);
            }
            return new KeyCommand[]{c};
        }
        return new KeyCommand[0];
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.name).append(this.command).append(this.key).append(this.propertyMatch.getExpression()).append(NamedKeyStrokeArrayConfigurer.encode(this.watchKeys)).append(NamedKeyStrokeArrayConfigurer.encode(this.actionKeys)).append(this.loop).append(this.preLoopKey).append(this.postLoopKey).append(this.loopType).append(this.whileExpression.getExpression()).append(this.untilExpression.getExpression()).append(this.loopCount.getFormat()).append(this.index).append(this.indexProperty).append(this.indexStart.getFormat()).append(this.indexStep.getFormat());
        return ID + se.getValue();
    }

    @Override
    public Command keyEvent(KeyStroke stroke) {
        Command c = this.piece.keyEvent(stroke);
        return c == null ? this.myKeyEvent(stroke) : c.append(this.myKeyEvent(stroke));
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        boolean seen = false;
        if (this.key.equals(stroke)) {
            seen = true;
        }
        for (int i = 0; i < this.watchKeys.length && !seen; ++i) {
            if (!this.watchKeys[i].equals(stroke)) continue;
            seen = true;
        }
        if (!seen) {
            return null;
        }
        if (!this.matchesFilter()) {
            return null;
        }
        this.outer = Decorator.getOutermost(this);
        Command c = new NullCommand();
        if (!this.loop) {
            try {
                c = c.append(this.doLoopOnce());
            }
            catch (RecursionLimitException e) {
                RecursionLimiter.infiniteLoop(e);
            }
            return c;
        }
        this.indexValue = this.parse("Index Property Start Value", this.indexStart, this.outer);
        int step = this.parse("Index Property increment value", this.indexStep, this.outer);
        c = c.append(this.executeKey(this.preLoopKey));
        int loopCounter = 0;
        int loopCountLimit = 0;
        if ("counted".equals(this.loopType)) {
            loopCountLimit = this.loopCount.getTextAsInt((PropertySource)this.outer, Resources.getString("Editor.LoopControl.loop_count"), this);
        }
        RecursionLimitException loopException = null;
        while (!"while".equals(this.loopType) || this.whileExpression.accept(this.outer)) {
            try {
                c = c.append(this.doLoopOnce());
            }
            catch (RecursionLimitException ex) {
                loopException = ex;
                break;
            }
            if ("until".equals(this.loopType) && this.untilExpression.accept(this.outer)) break;
            if (loopCounter++ >= 500) {
                loopException = new RecursionLimitException(this);
                break;
            }
            if ("counted".equals(this.loopType) && loopCounter >= loopCountLimit) break;
            this.indexValue += step;
        }
        c = c.append(this.executeKey(this.postLoopKey));
        if (loopException != null) {
            RecursionLimiter.infiniteLoop(loopException);
        }
        return c;
    }

    private int parse(String desc, FormattedString s, GamePiece outer) {
        int i = 0;
        String val = s.getText((PropertySource)outer, "0");
        try {
            i = Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            TriggerAction.reportDataError(this, Resources.getString("Error.non_number_error"), s.debugInfo(val, desc), e);
        }
        return i;
    }

    protected boolean isIndex() {
        return this.loop && this.index && this.indexProperty != null && this.indexProperty.length() > 0;
    }

    @Override
    public Object getProperty(Object key) {
        if (this.isIndex() && this.indexProperty.equals(key)) {
            return String.valueOf(this.indexValue);
        }
        return super.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if (this.isIndex() && this.indexProperty.equals(key)) {
            return String.valueOf(this.indexValue);
        }
        return super.getLocalizedProperty(key);
    }

    protected Command doLoopOnce() throws RecursionLimitException {
        Command comm = new NullCommand();
        try {
            RecursionLimiter.startExecution(this);
            for (int i = 0; i < this.actionKeys.length && this.getMap() != null; ++i) {
                comm = comm.append(this.outer.keyEvent(this.actionKeys[i].getKeyStroke()));
            }
        }
        finally {
            RecursionLimiter.endExecution();
        }
        return comm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Command executeKey(NamedKeyStroke key) {
        Command comm = null;
        if (key.isNull() || this.getMap() == null) {
            return comm;
        }
        try {
            RecursionLimiter.startExecution(this);
            comm = this.outer.keyEvent(key.getKeyStroke());
        }
        catch (RecursionLimitException e) {
            RecursionLimiter.infiniteLoop(e);
        }
        finally {
            RecursionLimiter.endExecution();
        }
        return comm;
    }

    protected boolean matchesFilter() {
        GamePiece outer = Decorator.getOutermost(this);
        return this.propertyMatch.isNull() || this.propertyMatch.accept(outer);
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String getDescription() {
        Object s = Resources.getString("Editor.TriggerAction.component_type");
        if (this.name.length() > 0) {
            s = (String)s + " - " + this.name;
        }
        return s;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("TriggerAction.htm");
    }

    @Override
    public void mySetType(String type) {
        int i;
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.name = st.nextToken("");
        this.command = st.nextToken("Trigger");
        this.key = st.nextNamedKeyStroke('T');
        this.propertyMatch.setExpression(st.nextToken(""));
        String keys = st.nextToken("");
        if (keys.indexOf(44) > 0) {
            this.watchKeys = NamedKeyStrokeArrayConfigurer.decode(keys);
        } else {
            this.watchKeys = new NamedKeyStroke[keys.length()];
            for (i = 0; i < this.watchKeys.length; ++i) {
                this.watchKeys[i] = NamedKeyStroke.getNamedKeyStroke(keys.charAt(i), 128);
            }
        }
        keys = st.nextToken("");
        if (keys.indexOf(44) > 0) {
            this.actionKeys = NamedKeyStrokeArrayConfigurer.decode(keys);
        } else {
            this.actionKeys = new NamedKeyStroke[keys.length()];
            for (i = 0; i < this.actionKeys.length; ++i) {
                this.actionKeys[i] = NamedKeyStroke.getNamedKeyStroke(keys.charAt(i), 128);
            }
        }
        this.loop = st.nextBoolean(false);
        this.preLoopKey = st.nextNamedKeyStroke();
        this.postLoopKey = st.nextNamedKeyStroke();
        this.loopType = st.nextToken("counted");
        this.whileExpression.setExpression(st.nextToken(""));
        this.untilExpression.setExpression(st.nextToken(""));
        this.loopCount.setFormat(st.nextToken(""));
        this.index = st.nextBoolean(false);
        this.indexProperty = st.nextToken("");
        this.indexStart.setFormat(st.nextToken("1"));
        this.indexStep.setFormat(st.nextToken("1"));
    }

    @Override
    public List<String> getPropertyNames() {
        if (this.isIndex()) {
            ArrayList<String> l = new ArrayList<String>();
            l.add(this.indexProperty);
            return l;
        }
        return super.getPropertyNames();
    }

    public void setPropertyMatch(String s) {
        this.propertyMatch.setExpression(s);
    }

    public void setCommandName(String s) {
        this.command = s;
    }

    public void setKey(NamedKeyStroke k) {
        this.key = k;
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.command, this.getCommandDescription(this.name, "Trigger command"));
    }

    @Override
    public String getComponentName() {
        return this.piece.getName();
    }

    @Override
    public String getComponentTypeName() {
        return this.getDescription();
    }

    public static class Ed
    implements PieceEditor {
        private StringConfigurer name;
        private StringConfigurer command;
        private NamedHotKeyConfigurer key;
        private PropertyExpressionConfigurer propertyMatch;
        private NamedKeyStrokeArrayConfigurer watchKeys;
        private NamedKeyStrokeArrayConfigurer actionKeys;
        private JPanel box;
        private BooleanConfigurer loopConfig;
        private NamedHotKeyConfigurer preLoopKeyConfig;
        private NamedHotKeyConfigurer postLoopKeyConfig;
        private StringEnumConfigurer loopTypeConfig;
        private PropertyExpressionConfigurer whileExpressionConfig;
        private PropertyExpressionConfigurer untilExpressionConfig;
        private FormattedStringConfigurer loopCountConfig;
        private BooleanConfigurer indexConfig;
        private StringConfigurer indexPropertyConfig;
        private FormattedStringConfigurer indexStartConfig;
        private FormattedStringConfigurer indexStepConfig;

        public Ed(TriggerAction piece) {
            PropertyChangeListener updateListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    this.updateVisibility();
                }
            };
            this.box = new JPanel();
            this.box.setLayout(new BoxLayout(this.box, 1));
            this.name = new StringConfigurer(null, Resources.getString("Editor.description_label"), piece.name);
            this.box.add(this.name.getControls());
            this.propertyMatch = new PropertyExpressionConfigurer(null, Resources.getString("Editor.TriggerAction.trigger_when_properties"), piece.propertyMatch, Decorator.getOutermost(piece));
            this.box.add(this.propertyMatch.getControls());
            Box commandBox = Box.createHorizontalBox();
            this.command = new StringConfigurer(null, Resources.getString("Editor.menu_command"), piece.command);
            commandBox.add(this.command.getControls());
            this.key = new NamedHotKeyConfigurer(null, Resources.getString("Editor.keyboard_command"), piece.key);
            commandBox.add(this.key.getControls());
            this.box.add(commandBox);
            this.watchKeys = new NamedKeyStrokeArrayConfigurer(null, Resources.getString("Editor.TriggerAction.watch_for"), piece.watchKeys);
            this.box.add(this.watchKeys.getControls());
            this.actionKeys = new NamedKeyStrokeArrayConfigurer(null, Resources.getString("Editor.TriggerAction.perform_keystrokes"), piece.actionKeys);
            this.box.add(this.actionKeys.getControls());
            this.loopConfig = new BooleanConfigurer(null, Resources.getString("Editor.TriggerAction.repeat_this"), piece.loop);
            this.loopConfig.addPropertyChangeListener(updateListener);
            this.box.add(this.loopConfig.getControls());
            this.loopTypeConfig = new StringEnumConfigurer(null, Resources.getString("Editor.LoopControl.type_of_loop"), LoopControl.LOOP_TYPE_DESCS);
            this.loopTypeConfig.setValue(LoopControl.loopTypeToDesc(piece.loopType));
            this.loopTypeConfig.addPropertyChangeListener(updateListener);
            this.box.add(this.loopTypeConfig.getControls());
            this.loopCountConfig = new FormattedExpressionConfigurer(null, Resources.getString("Editor.LoopControl.loop_how_many"), piece.loopCount.getFormat(), piece);
            this.box.add(this.loopCountConfig.getControls());
            this.whileExpressionConfig = new PropertyExpressionConfigurer(null, Resources.getString("Editor.TriggerAction.looping_continues"), piece.whileExpression);
            this.box.add(this.whileExpressionConfig.getControls());
            this.untilExpressionConfig = new PropertyExpressionConfigurer(null, Resources.getString("Editor.TriggerAction.looping_ends"), piece.untilExpression);
            this.box.add(this.untilExpressionConfig.getControls());
            this.preLoopKeyConfig = new NamedHotKeyConfigurer(null, Resources.getString("Editor.TriggerAction.keystroke_before"), piece.preLoopKey);
            this.box.add(this.preLoopKeyConfig.getControls());
            this.postLoopKeyConfig = new NamedHotKeyConfigurer(null, Resources.getString("Editor.TriggerAction.keystroke_after"), piece.postLoopKey);
            this.box.add(this.postLoopKeyConfig.getControls());
            this.indexConfig = new BooleanConfigurer(null, Resources.getString("Editor.LoopControl.loop_index"), piece.index);
            this.indexConfig.addPropertyChangeListener(updateListener);
            this.box.add(this.indexConfig.getControls());
            this.indexPropertyConfig = new StringConfigurer(null, Resources.getString("Editor.LoopControl.index_name"), piece.indexProperty);
            this.box.add(this.indexPropertyConfig.getControls());
            this.indexStartConfig = new FormattedExpressionConfigurer(null, Resources.getString("Editor.LoopControl.index_start"), piece.indexStart.getFormat(), piece);
            this.box.add(this.indexStartConfig.getControls());
            this.indexStepConfig = new FormattedExpressionConfigurer(null, Resources.getString("Editor.LoopControl.index_step"), piece.indexStep.getFormat(), piece);
            this.box.add(this.indexStepConfig.getControls());
            this.updateVisibility();
        }

        private void updateVisibility() {
            boolean isLoop = this.loopConfig.booleanValue();
            boolean isIndex = this.indexConfig.booleanValue();
            String type = LoopControl.loopDescToType(this.loopTypeConfig.getValueString());
            this.loopTypeConfig.getControls().setVisible(isLoop);
            this.loopCountConfig.getControls().setVisible(isLoop && type.equals("counted"));
            this.whileExpressionConfig.getControls().setVisible(isLoop && type.equals("while"));
            this.untilExpressionConfig.getControls().setVisible(isLoop && type.equals("until"));
            this.preLoopKeyConfig.getControls().setVisible(isLoop);
            this.postLoopKeyConfig.getControls().setVisible(isLoop);
            this.indexConfig.getControls().setVisible(isLoop);
            this.indexPropertyConfig.getControls().setVisible(isLoop && isIndex);
            this.indexStartConfig.getControls().setVisible(isLoop && isIndex);
            this.indexStepConfig.getControls().setVisible(isLoop && isIndex);
            Window w = SwingUtilities.getWindowAncestor(this.box);
            if (w != null) {
                w.pack();
            }
        }

        @Override
        public Component getControls() {
            return this.box;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.name.getValueString()).append(this.command.getValueString()).append(this.key.getValueString()).append(this.propertyMatch.getValueString()).append(this.watchKeys.getValueString()).append(this.actionKeys.getValueString()).append(this.loopConfig.getValueString()).append(this.preLoopKeyConfig.getValueString()).append(this.postLoopKeyConfig.getValueString()).append(LoopControl.loopDescToType(this.loopTypeConfig.getValueString())).append(this.whileExpressionConfig.getValueString()).append(this.untilExpressionConfig.getValueString()).append(this.loopCountConfig.getValueString()).append(this.indexConfig.getValueString()).append(this.indexPropertyConfig.getValueString()).append(this.indexStartConfig.getValueString()).append(this.indexStepConfig.getValueString());
            return TriggerAction.ID + se.getValue();
        }
    }
}

