/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.build.module.metadata.SaveMetaData;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.LongConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslateVassalWindow;
import VASSAL.launch.CustomVmOptions;
import VASSAL.launch.Editor;
import VASSAL.launch.ExceptionHandler;
import VASSAL.launch.FirstTimeDialog;
import VASSAL.launch.LaunchRequest;
import VASSAL.launch.LaunchRequestException;
import VASSAL.launch.ModuleManagerMacOSXStartUp;
import VASSAL.launch.ModuleManagerWindow;
import VASSAL.launch.Player;
import VASSAL.launch.StandardConfig;
import VASSAL.launch.StartUp;
import VASSAL.launch.UpdateCheckRequest;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ThrowableUtils;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.logging.LoggedOutputStream;
import VASSAL.tools.menu.MacOSXMenuManager;
import VASSAL.tools.menu.MenuBarProxy;
import VASSAL.tools.menu.MenuManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleManager {
    private static final Logger logger = LoggerFactory.getLogger(ModuleManager.class);
    private static final String NEXT_VERSION_CHECK = "nextVersionCheck";
    public static final String MAXIMUM_HEAP = "maximumHeap";
    public static final String INITIAL_HEAP = "initialHeap";
    private static ModuleManager instance = null;
    private final long key;
    private FileOutputStream lout;
    private FileLock lock;
    private final ServerSocket serverSocket;

    public static void main(String[] args) {
        System.setProperty("swing.boldMetal", "false");
        try {
            Info.setConfig(new StandardConfig());
        }
        catch (IOException e) {
            System.err.println("VASSAL: " + e.getMessage());
            System.exit(1);
        }
        LaunchRequest lr = null;
        try {
            lr = LaunchRequest.parseArgs(args);
        }
        catch (LaunchRequestException e) {
            System.err.println("VASSAL: " + e.getMessage());
            System.exit(1);
        }
        if (lr.mode == LaunchRequest.Mode.TRANSLATE) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new TranslateVassalWindow(null).setVisible(true);
                }
            });
            return;
        }
        String ver = Info.getReportableVersion();
        File keyfile = new File(Info.getConfDir(), "key-" + ver);
        File lockfile = new File(Info.getConfDir(), "lock-" + ver);
        int port = 0;
        long key = 0L;
        FileLock klock = null;
        try (RandomAccessFile kraf = new RandomAccessFile(keyfile, "rw");){
            try {
                klock = kraf.getChannel().lock();
            }
            catch (OverlappingFileLockException e) {
                throw new IOException(e);
            }
            FileLock lock = null;
            FileOutputStream lout = new FileOutputStream(lockfile);
            try {
                lock = lout.getChannel().tryLock();
            }
            catch (OverlappingFileLockException e) {
                throw new IOException(e);
            }
            if (lock != null) {
                ServerSocket serverSocket = new ServerSocket(0, 0, InetAddress.getByName(null));
                port = serverSocket.getLocalPort();
                kraf.writeInt(port);
                key = (long)(Math.random() * 9.223372036854776E18);
                kraf.writeLong(key);
                new ModuleManager(serverSocket, key, lout, lock);
            } else {
                lout.close();
                port = kraf.readInt();
                key = kraf.readLong();
            }
        }
        catch (IOException e) {
            System.err.println("VASSAL: IO error");
            e.printStackTrace();
            System.exit(1);
        }
        lr.key = key;
        try (Socket clientSocket = new Socket((String)null, port);
             ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(clientSocket.getOutputStream()));){
            out.writeObject(lr);
            out.flush();
            try (InputStream in = clientSocket.getInputStream();){
                IOUtils.copy((InputStream)in, (OutputStream)System.err);
            }
        }
        catch (UnknownHostException e) {
            logger.error("Unable to open socket for loopback device", (Throwable)e);
            System.exit(1);
        }
        catch (IOException e) {
            logger.error("VASSAL: Problem with socket on port {}", (Object)port, (Object)e);
            System.exit(1);
        }
    }

    public static ModuleManager getInstance() {
        return instance;
    }

    public ModuleManager(ServerSocket serverSocket, long key, FileOutputStream lout, FileLock lock) throws IOException {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = this;
        this.serverSocket = serverSocket;
        this.key = key;
        this.lout = lout;
        this.lock = lock;
        File errorLog = Info.getErrorLogPath();
        new FileOutputStream(errorLog).close();
        StartUp start = SystemUtils.IS_OS_MAC_OSX ? new ModuleManagerMacOSXStartUp() : new StartUp();
        start.startErrorLog();
        System.setErr(new PrintStream((OutputStream)new LoggedOutputStream(), true, Charset.defaultCharset()));
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
        start.initSystemProperties();
        if (SystemUtils.IS_OS_MAC_OSX) {
            new MacOSXMenuManager();
        } else {
            new ModuleManagerMenuManager();
        }
        new CustomVmOptions().ensureCustomVmOptionsFileExistsInConfDir();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ModuleManager.this.launch();
            }
        });
        Thread socketListener = new Thread((Runnable)new SocketListener(serverSocket), "socket listener");
        socketListener.setDaemon(true);
        socketListener.start();
        Prefs globalPrefs = Prefs.getGlobalPrefs();
        LongConfigurer nextVersionCheckConfig = new LongConfigurer(NEXT_VERSION_CHECK, null, -1L);
        globalPrefs.addOption(null, nextVersionCheckConfig);
        long nextVersionCheck = nextVersionCheckConfig.getLongValue(-1L);
        if (nextVersionCheck < System.currentTimeMillis()) {
            new UpdateCheckRequest().execute();
        }
        nextVersionCheck = nextVersionCheck == -1L ? System.currentTimeMillis() + (long)(Math.random() * 10.0 * 8.64E7) : (nextVersionCheck += 864000000L);
        nextVersionCheckConfig.setValue(nextVersionCheck);
        IntConfigurer initHeapConf = new IntConfigurer(INITIAL_HEAP, Resources.getString("GlobalOptions.initial_heap"), (Integer)256);
        globalPrefs.addOption("Importer", initHeapConf);
        IntConfigurer maxHeapConf = new IntConfigurer(MAXIMUM_HEAP, Resources.getString("GlobalOptions.maximum_heap"), (Integer)512);
        globalPrefs.addOption("Importer", maxHeapConf);
    }

    public void shutDown() throws IOException {
        this.lock.release();
        this.lout.close();
    }

    protected void launch() {
        boolean isFirstTime;
        logger.info("Manager");
        ModuleManagerWindow window = ModuleManagerWindow.getInstance();
        window.setVisible(true);
        boolean bl = isFirstTime = !Info.getPrefsDir().exists();
        if (isFirstTime) {
            new FirstTimeDialog(window).setVisible(true);
        }
    }

    protected String execute(Object req) {
        if (req instanceof LaunchRequest) {
            LaunchRequest lr = (LaunchRequest)req;
            if (lr.key != this.key) {
                return "incorrect key";
            }
            LaunchRequestHandler handler = new LaunchRequestHandler(lr);
            try {
                SwingUtilities.invokeAndWait(handler);
            }
            catch (InterruptedException e) {
                return "interrupted";
            }
            catch (InvocationTargetException e) {
                ErrorDialog.bug(e);
                return null;
            }
            return handler.getResult();
        }
        return "unrecognized command";
    }

    private static class ModuleManagerMenuManager
    extends MenuManager {
        private final MenuBarProxy menuBar = new MenuBarProxy();

        private ModuleManagerMenuManager() {
        }

        @Override
        public JMenuBar getMenuBarFor(JFrame fc) {
            return fc instanceof ModuleManagerWindow ? this.menuBar.createPeer() : null;
        }

        @Override
        public MenuBarProxy getMenuBarProxyFor(JFrame fc) {
            return fc instanceof ModuleManagerWindow ? this.menuBar : null;
        }
    }

    private class SocketListener
    implements Runnable {
        private final ServerSocket serverSocket;

        public SocketListener(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                clientSocket = null;
                while (true) lbl-1000:
                // 7 sources

                {
                    try {
                        clientSocket = this.serverSocket.accept();
                        in = new ObjectInputStream(new BufferedInputStream(clientSocket.getInputStream()));
                        try {
                            message = ModuleManager.this.execute(in.readObject());
                        }
                        finally {
                            in.close();
                        }
                        clientSocket.close();
                        if (message == null || clientSocket.isClosed()) ** GOTO lbl-1000
                        out = new PrintStream((OutputStream)new BufferedOutputStream(clientSocket.getOutputStream()), true, StandardCharsets.UTF_8);
                        try {
                            out.println(message);
                        }
                        finally {
                            out.close();
                        }
                    }
                    catch (IOException e) {
                        ErrorDialog.showDetails(e, ThrowableUtils.getStackTrace(e), "Error.socket_error", new Object[0]);
                    }
                    catch (ClassNotFoundException e) {
                        ErrorDialog.bug(e);
                    }
                    finally {
                        if (clientSocket == null) continue;
                        try {
                            clientSocket.close();
                        }
                        catch (IOException e) {
                            ModuleManager.logger.error("Error while closing client socket", (Throwable)e);
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable var8_16) {
                if (this.serverSocket != null) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException e) {
                        ModuleManager.logger.error("Error while closing server socket", (Throwable)e);
                    }
                }
                throw var8_16;
            }
            ** GOTO lbl-1000
        }
    }

    private static class LaunchRequestHandler
    implements Runnable {
        private final LaunchRequest lr;
        private String result;

        public LaunchRequestHandler(LaunchRequest lr) {
            this.lr = lr;
        }

        @Override
        public void run() {
            this.result = this.handle();
        }

        public String getResult() {
            return this.result;
        }

        private String handle() {
            ModuleManagerWindow window = ModuleManagerWindow.getInstance();
            switch (this.lr.mode) {
                case MANAGE: {
                    window.toFront();
                    break;
                }
                case LOAD: {
                    AbstractMetaData data;
                    if (Player.LaunchAction.isEditing(this.lr.module)) {
                        return "module open for editing";
                    }
                    if (this.lr.module == null && this.lr.game != null && (data = MetaDataFactory.buildMetaData(this.lr.game)) instanceof SaveMetaData) {
                        String moduleName = ((SaveMetaData)data).getModuleName();
                        if (moduleName != null && moduleName.length() > 0) {
                            this.lr.module = window.getModuleByName(moduleName);
                        } else {
                            return "cannot find module";
                        }
                    }
                    if (this.lr.module == null) {
                        return "cannot find module";
                    }
                    if (this.lr.game == null) {
                        new Player.LaunchAction(window, this.lr.module).actionPerformed(null);
                        break;
                    }
                    new Player.LaunchAction(window, this.lr.module, this.lr.game).actionPerformed(null);
                    break;
                }
                case EDIT: {
                    if (Editor.LaunchAction.isInUse(this.lr.module)) {
                        return "module open for play";
                    }
                    if (Editor.LaunchAction.isEditing(this.lr.module)) {
                        return "module open for editing";
                    }
                    new Editor.LaunchAction(window, this.lr.module).actionPerformed(null);
                    break;
                }
                case IMPORT: {
                    new Editor.ImportLaunchAction(window, this.lr.importFile).actionPerformed(null);
                    break;
                }
                case NEW: {
                    new Editor.NewModuleLaunchAction(window).actionPerformed(null);
                    break;
                }
                case EDIT_EXT: {
                    return "not yet implemented";
                }
                case NEW_EXT: {
                    return "not yet implemented";
                }
                default: {
                    return "unrecognized mode";
                }
            }
            return null;
        }
    }
}

