/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;

class JPEGDecoder {
    static final int TEM = 65281;
    static final int SOF0 = 65472;
    static final int SOF1 = 65473;
    static final int SOF2 = 65474;
    static final int SOF3 = 65475;
    static final int SOF4 = 65476;
    static final int SOF5 = 65477;
    static final int SOF6 = 65478;
    static final int SOF7 = 65479;
    static final int SOF8 = 65480;
    static final int SOF9 = 65481;
    static final int SOF10 = 65482;
    static final int SOF11 = 65483;
    static final int SOF12 = 65484;
    static final int SOF13 = 65485;
    static final int SOF14 = 65486;
    static final int SOF15 = 65487;
    static final int RST0 = 65488;
    static final int RST1 = 65489;
    static final int RST2 = 65490;
    static final int RST3 = 65491;
    static final int RST4 = 65492;
    static final int RST5 = 65493;
    static final int RST6 = 65494;
    static final int RST7 = 65495;
    static final int SOI = 65496;
    static final int EOI = 65497;
    static final int SOS = 65498;
    static final int APP0 = 65504;
    static final int APP2 = 65506;
    static final int APP13 = 65517;
    static final int APP14 = 65518;

    protected JPEGDecoder() {
    }

    public static boolean decodeSignature(DataInputStream in) throws IOException {
        return in.readUnsignedShort() == 65496;
    }

    public static Chunk decodeChunk(DataInputStream in) throws IOException {
        byte[] data;
        int type = in.readUnsignedShort();
        if ((type & 0xFF00) != 65280) {
            throw new IOException("initial byte of chunk must be FF");
        }
        if (type == 65281 || 65488 <= type && type <= 65497) {
            data = new byte[]{};
        } else {
            int length = in.readUnsignedShort();
            data = new byte[length - 2];
            in.readFully(data);
        }
        return new Chunk(type, data);
    }

    public static void main(String[] args) throws IOException {
        try (FileInputStream fin = new FileInputStream(args[0]);
             DataInputStream in = new DataInputStream(fin);){
            Chunk ch;
            if (!JPEGDecoder.decodeSignature(in)) {
                System.out.println("Not a JPEG");
            }
            do {
                ch = JPEGDecoder.decodeChunk(in);
                System.out.println("type == " + Integer.toHexString(ch.type) + ", length == " + ch.data.length);
            } while (ch.type != 65497);
        }
    }

    public static class Chunk {
        public final int type;
        public final byte[] data;

        private Chunk(int type, byte[] data) {
            this.type = type;
            this.data = data;
        }
    }
}

