/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.tilecache;

import VASSAL.tools.image.ImageLoader;
import VASSAL.tools.image.tilecache.TileSlicer;
import VASSAL.tools.io.FileArchive;
import VASSAL.tools.lang.Callback;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileArchiveImageTiler {
    private static final Logger logger = LoggerFactory.getLogger(FileArchiveImageTiler.class);

    public void run(FileArchive fa, String tpath, int tw, int th, String[] ipaths, ExecutorService exec, ImageLoader loader, TileSlicer slicer, Callback<String> imageListener, Callback<Void> tileListener, Callback<Void> doneListener) throws IOException {
        for (String ipath : ipaths) {
            BufferedImage src;
            logger.info("Tiling {}", (Object)ipath);
            imageListener.receive(ipath);
            try (InputStream in = fa.getInputStream(ipath);){
                src = loader.load(ipath, in, 1, 3, false);
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
                continue;
            }
            slicer.slice(src, ipath, tpath, tw, th, exec, tileListener);
        }
        exec.shutdown();
        doneListener.receive(null);
    }
}

