/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.tilecache;

import VASSAL.tools.concurrent.DaemonThreadFactory;
import VASSAL.tools.image.FallbackImageTypeConverter;
import VASSAL.tools.image.ImageIOImageLoader;
import VASSAL.tools.image.tilecache.TileSlicerImpl;
import VASSAL.tools.io.TemporaryFileFactory;
import VASSAL.tools.lang.Callback;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ImageToTiles {
    public static void main(String[] args) throws IOException {
        System.setProperty("java.awt.headless", "true");
        String ipath = args[0];
        String tpath = args[1];
        int tw = Integer.parseInt(args[2]);
        int th = Integer.parseInt(args[3]);
        Runtime runtime = Runtime.getRuntime();
        ThreadPoolExecutor exec = new ThreadPoolExecutor(runtime.availableProcessors(), runtime.availableProcessors() + 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory(ImageToTiles.class.getSimpleName()));
        TemporaryFileFactory tfac = () -> Files.createTempFile(Path.of(tpath, new String[0]), "img_", "", new FileAttribute[0]).toFile();
        FallbackImageTypeConverter itc = new FallbackImageTypeConverter(tfac);
        ImageIOImageLoader loader = new ImageIOImageLoader(itc);
        BufferedImage src = null;
        try (FileInputStream in = new FileInputStream(ipath);){
            src = loader.load(ipath, in, 1, 3, false);
        }
        String iname = new File(ipath).getName();
        Callback<Void> dotter = new Callback<Void>(){

            @Override
            public void receive(Void obj) {
                System.out.print('.');
            }
        };
        TileSlicerImpl slicer = new TileSlicerImpl();
        slicer.slice(src, iname, tpath, tw, th, exec, dotter);
        exec.shutdown();
        System.out.println("");
    }
}

