/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imports;

import VASSAL.build.GameModule;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.ImportMetaData;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.launch.BasicModule;
import VASSAL.launch.EditModuleAction;
import VASSAL.launch.ModuleEditorWindow;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.filechooser.ExtensionFileFilter;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.FileFilter;
import VASSAL.tools.imports.FileFormatException;
import VASSAL.tools.imports.Importer;
import VASSAL.tools.imports.adc2.ADC2Module;
import VASSAL.tools.imports.adc2.MapBoard;
import VASSAL.tools.imports.adc2.SymbolSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JOptionPane;

public final class ImportAction
extends EditModuleAction {
    private static final long serialVersionUID = 1L;
    private static final String[] EXTENSIONS = new String[]{".ops", ".map", ".set"};
    private static final String[] DESCRIPTIONS = new String[]{"ADC2 Game Module", "ADC2 Map Board", "ADC2 Symbol Set"};
    private static final Class<?>[] IMPORTERS = new Class[]{ADC2Module.class, MapBoard.class, SymbolSet.class};

    public ImportAction(Component comp) {
        super(comp);
        this.putValue("Name", Resources.getString("Editor.import_module"));
    }

    public static FileChooser getFileChooser(Component c) {
        FileChooser chooser = FileChooser.createFileChooser(c, (DirectoryConfigurer)Prefs.getGlobalPrefs().getOption("modulesDir"));
        chooser.resetChoosableFileFilters();
        for (int i = IMPORTERS.length - 1; i >= 0; --i) {
            chooser.addChoosableFileFilter(new ExtensionFileFilter(DESCRIPTIONS[i] + " (*" + EXTENSIONS[i].toLowerCase() + ";*" + EXTENSIONS[i].toUpperCase() + ")", new String[]{EXTENSIONS[i]}));
        }
        return chooser;
    }

    public static Class<?> getImporterClass(File f) throws IOException {
        int[] indices = new int[IMPORTERS.length];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        String s = "." + Importer.getExtension(f.getName());
        for (int i = 0; i < EXTENSIONS.length; ++i) {
            if (EXTENSIONS[i].compareToIgnoreCase(s) != 0) continue;
            indices[0] = i;
            indices[i] = 0;
            break;
        }
        for (int index : indices) {
            try {
                if (!((Importer)IMPORTERS[index].getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).isValidImportFile(f)) continue;
                return IMPORTERS[index];
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                ErrorDialog.bug(e);
            }
        }
        return null;
    }

    @Override
    public void performAction(ActionEvent e) throws IOException {
        File f;
        this.actionCancelled = true;
        this.fc.resetChoosableFileFilters();
        for (int i = IMPORTERS.length - 1; i >= 0; --i) {
            this.fc.addChoosableFileFilter(new ExtensionFileFilter(DESCRIPTIONS[i] + " (*" + EXTENSIONS[i].toLowerCase() + ";*" + EXTENSIONS[i].toUpperCase() + ")", new String[]{EXTENSIONS[i]}));
        }
        if (this.fc.showOpenDialog() == 0 && (f = this.fc.getSelectedFile()) != null && f.exists()) {
            this.loadModule(f);
            this.actionCancelled = false;
        }
    }

    @Override
    public void loadModule(File f) throws IOException {
        Class<?> impClass = ImportAction.getImporterClass(f);
        if (impClass == null) {
            throw new FileFormatException("Unrecognized file format");
        }
        BasicModule module = new BasicModule(new ArchiveWriter(null, ".vmod"));
        GameModule.init(module);
        try {
            Importer imp = (Importer)impClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            imp.importFile(this, f);
            imp.writeToArchive();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            ErrorDialog.bug(e);
        }
        module.getPlayerWindow().setVisible(true);
        new ModuleEditorWindow(module).setVisible(true);
    }

    public File getCaseInsensitiveFile(File f, File base, boolean queryIfNotFound, FileFilter filter) {
        File[] peers;
        if (f.exists()) {
            return f;
        }
        String name = Importer.getFileName(f.getName());
        File parent = f.getParentFile();
        if (parent != null && (peers = parent.listFiles()) != null) {
            for (File p : peers) {
                if (!p.getName().equalsIgnoreCase(name)) continue;
                return p;
            }
        }
        if (base != null && (peers = base.getParentFile().listFiles()) != null) {
            for (File p : peers) {
                if (!p.getName().equalsIgnoreCase(name)) continue;
                return p;
            }
        }
        if (queryIfNotFound) {
            File p;
            JOptionPane.showMessageDialog(this.comp, "Unable to locate file:\n" + f.getPath() + "\nPlease locate it in the following dialog.", "File Warning", 2);
            if (this.fc == null) {
                this.fc = ImportAction.getFileChooser(this.comp);
            }
            this.fc.resetChoosableFileFilters();
            if (filter != null) {
                this.fc.setFileFilter(filter);
            }
            this.fc.setSelectedFile(new File(f.getName()));
            if (this.fc.showOpenDialog() == 0 && (p = this.fc.getSelectedFile()).exists()) {
                return p;
            }
        }
        return null;
    }

    public static AbstractMetaData buildMetaData(File module) {
        try {
            if (ImportAction.getImporterClass(module) == null) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        return new ImportMetaData();
    }
}

