/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.DieRoll;
import VASSAL.build.module.InternetDiceButton;
import VASSAL.build.module.MultiRoll;
import VASSAL.build.module.dice.BonesDiceServer;
import VASSAL.build.module.dice.DieServer;
import VASSAL.build.module.dice.RollSet;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import VASSAL.tools.FormattedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DieManager
extends AbstractConfigurable {
    private final Map<String, DieServer> servers;
    private final List<InternetDiceButton> dieButtons = new ArrayList<InternetDiceButton>();
    private String desc = "Die Manager";
    private boolean useMultiRoll;
    private int defaultNDice = 2;
    private int defaultNSides = 6;
    private DieServer server;
    private String lastServerName = "";
    private MultiRoll myMultiRoll;
    final StringEnumConfigurer semail;
    public static final String USE_INTERNET_DICE = "useinternetdice";
    public static final String DICE_SERVER = "diceserver";
    public static final String SERVER_PW = "serverpw";
    public static final String USE_EMAIL = "useemail";
    public static final String PRIMARY_EMAIL = "primaryemail";
    public static final String SECONDARY_EMAIL = "secondaryemail";
    public static final String ADDRESS_BOOK = "addressbook";
    public static final String MULTI_ROLL = "multiroll";
    public static final String DIE_MANAGER = "Internet Die Roller";
    public static final String DESC = "description";
    public static final String DFLT_NSIDES = "dfltnsides";
    public static final String DFLT_NDICE = "dfltndice";

    public DieManager() {
        this.servers = new HashMap<String, DieServer>();
        BonesDiceServer d = new BonesDiceServer();
        this.servers.put(d.getName(), d);
        this.server = d;
        StringEnumConfigurer dieserver = new StringEnumConfigurer(DICE_SERVER, "Internet Dice Server", this.getDescriptions());
        dieserver.setValue(this.server.getDescription());
        StringConfigurer serverpw = new StringConfigurer(SERVER_PW, "Dice Server Password");
        BooleanConfigurer useemail = new BooleanConfigurer(USE_EMAIL, "Email results?");
        StringConfigurer pemail = new StringConfigurer(PRIMARY_EMAIL, "Primary Email");
        StringArrayConfigurer abook = new StringArrayConfigurer(ADDRESS_BOOK, "Address Book");
        BooleanConfigurer multiroll = new BooleanConfigurer(MULTI_ROLL, "Put multiple rolls into single email");
        GameModule.getGameModule().getPrefs().addOption(null, dieserver);
        GameModule.getGameModule().getPrefs().addOption(null, serverpw);
        GameModule.getGameModule().getPrefs().addOption(DIE_MANAGER, useemail);
        GameModule.getGameModule().getPrefs().addOption(DIE_MANAGER, abook);
        String[] addressList = (String[])GameModule.getGameModule().getPrefs().getValue(ADDRESS_BOOK);
        this.semail = new StringEnumConfigurer(SECONDARY_EMAIL, "Secondary Email", addressList);
        GameModule.getGameModule().getPrefs().addOption(DIE_MANAGER, pemail);
        GameModule.getGameModule().getPrefs().addOption(DIE_MANAGER, this.semail);
        GameModule.getGameModule().getPrefs().addOption(DIE_MANAGER, multiroll);
        this.setSemailValues();
        DefaultListModel<String> m = abook.getModel();
        ListDataListener ldl = new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent arg0) {
                DieManager.this.setSemailValues();
            }

            @Override
            public void intervalAdded(ListDataEvent arg0) {
                DieManager.this.setSemailValues();
            }

            @Override
            public void intervalRemoved(ListDataEvent arg0) {
                DieManager.this.setSemailValues();
            }
        };
        m.addListDataListener(ldl);
    }

    public void setSemailValues() {
        String currentSemail = (String)GameModule.getGameModule().getPrefs().getValue(SECONDARY_EMAIL);
        String[] addressBook = (String[])GameModule.getGameModule().getPrefs().getValue(ADDRESS_BOOK);
        this.semail.setValidValues(addressBook);
        this.semail.setValue(currentSemail);
    }

    public String[] getNames() {
        if (this.servers == null) {
            return null;
        }
        return this.servers.keySet().toArray(new String[0]);
    }

    public String[] getDescriptions() {
        if (this.servers == null) {
            return null;
        }
        String[] s = new String[this.servers.size()];
        int i = 0;
        for (DieServer d : this.servers.values()) {
            s[i++] = d.getDescription();
        }
        return s;
    }

    public DieServer getServerForName(String name) {
        return this.servers.get(name);
    }

    public DieServer getServerFromDescription(String de) {
        for (DieServer d : this.servers.values()) {
            if (!de.equals(d.getDescription())) continue;
            return d;
        }
        return null;
    }

    public DieServer getServer() {
        this.getPrefs();
        return this.server;
    }

    public String getServerDescription() {
        return this.getServer().getDescription();
    }

    public String getServerName() {
        return this.getServer().getName();
    }

    public int getDfltNDice() {
        return this.defaultNDice;
    }

    public int getDfltNSides() {
        return this.defaultNSides;
    }

    public MultiRoll getMultiRoll(int nDice, int nSides) {
        String serverName = this.getServer().getName();
        if (this.myMultiRoll == null || !serverName.equals(this.lastServerName)) {
            this.myMultiRoll = new MultiRoll(this, nDice, nSides);
        }
        this.lastServerName = serverName;
        return this.myMultiRoll;
    }

    public void roll(int nDice, int nSides, int plus, boolean reportTotal, String description, FormattedString format) {
        RollSet rollSet;
        MultiRoll mroll = this.getMultiRoll(nDice, nSides);
        this.getPrefs();
        String desc = GameModule.getGameModule().getChatter().getInputField().getText();
        if (desc != null && desc.length() > 0) {
            mroll.setDescription(desc);
        }
        if (this.useMultiRoll) {
            mroll.setVisible(true);
            if (mroll.wasCancelled()) {
                return;
            }
            rollSet = mroll.getRollSet();
            desc = rollSet.getDescription();
        } else {
            DieRoll[] rolls = new DieRoll[]{new DieRoll(description, nDice, nSides, plus, reportTotal)};
            rollSet = new RollSet(description, rolls);
            desc = "";
        }
        Chatter.DisplayText chatCommand = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), " - Roll sent to " + this.server.getDescription());
        if (desc == null || desc.length() == 0) {
            desc = GameModule.getGameModule().getChatter().getInputField().getText();
        }
        if (this.server.getUseEmail()) {
            if (desc == null || desc.length() == 0) {
                chatCommand.append(new Chatter.DisplayText(GameModule.getGameModule().getChatter(), " - Emailing " + this.server.getSecondaryEmail() + " (no subject line)"));
                chatCommand.append(new Chatter.DisplayText(GameModule.getGameModule().getChatter(), " - Leave text in the chat input area to provide a subject line"));
            } else {
                chatCommand.append(new Chatter.DisplayText(GameModule.getGameModule().getChatter(), " - Emailing " + this.server.getSecondaryEmail() + " (Subject:  " + desc + ")"));
            }
        }
        chatCommand.execute();
        GameModule.getGameModule().sendAndLog(chatCommand);
        GameModule.getGameModule().getChatter().getInputField().setText("");
        rollSet.setDescription(desc);
        this.server.roll(rollSet, format);
    }

    private void getPrefs() {
        Prefs prefs = GameModule.getGameModule().getPrefs();
        String serverName = (String)prefs.getValue(DICE_SERVER);
        this.server = this.getServerFromDescription(serverName);
        this.server.setPasswd((String)prefs.getValue(SERVER_PW));
        this.server.setUseEmail((Boolean)prefs.getValue(USE_EMAIL));
        this.server.setPrimaryEmail((String)prefs.getValue(PRIMARY_EMAIL));
        this.server.setSecondaryEmail((String)prefs.getValue(SECONDARY_EMAIL));
        this.useMultiRoll = (Boolean)prefs.getValue(MULTI_ROLL);
    }

    public void addDieButton(InternetDiceButton d) {
        this.dieButtons.add(d);
    }

    public void removeDieButton(InternetDiceButton d) {
        this.dieButtons.remove(d);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.description_label"), Resources.getString("Editor.DieManager.ndice"), Resources.getString("Editor.DieManager.nsides")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Integer.class, Integer.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{DESC, DFLT_NDICE, DFLT_NSIDES};
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (DESC.equals(key)) {
            this.desc = (String)value;
        } else if (DFLT_NDICE.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.defaultNDice = (Integer)value;
        } else if (DFLT_NSIDES.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.defaultNSides = (Integer)value;
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (DESC.equals(key)) {
            return this.desc;
        }
        if (DFLT_NDICE.equals(key)) {
            return Integer.toString(this.defaultNDice);
        }
        if (DFLT_NSIDES.equals(key)) {
            return Integer.toString(this.defaultNSides);
        }
        return null;
    }

    @Override
    public void removeFrom(Buildable parent) {
    }

    @Override
    public HelpFile getHelpFile() {
        return null;
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{InternetDiceButton.class};
    }

    @Override
    public void addTo(Buildable parent) {
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.DieManager.component_type");
    }

    public void setSecondaryEmail(String email) {
        GameModule.getGameModule().getPrefs().setValue(SECONDARY_EMAIL, email);
        this.server.setSecondaryEmail(email);
    }
}

