/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.GameModule;
import VASSAL.build.GpIdChecker;
import VASSAL.build.GpIdSupport;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.PrototypesContainer;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.widget.PieceSlot;
import VASSAL.command.ChangePiece;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.command.RemovePiece;
import VASSAL.counters.Deck;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.ErrorDialog;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GameRefresher
implements GameComponent {
    private static final Logger logger = LoggerFactory.getLogger(GameRefresher.class);
    private Action refreshAction;
    private final GpIdSupport gpIdSupport;
    private GpIdChecker gpIdChecker;
    private RefreshDialog dialog;
    private int updatedCount;
    private int notFoundCount;
    private final GameModule theModule;
    private final Set<String> options = new HashSet<String>();

    public GameRefresher(GpIdSupport gpIdSupport) {
        this.gpIdSupport = gpIdSupport;
        this.theModule = GameModule.getGameModule();
    }

    public void addTo(AbstractConfigurable parent) {
        this.refreshAction = new AbstractAction(Resources.getString("GameRefresher.refresh_counters")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                new GameRefresher(GameRefresher.this.gpIdSupport).start();
            }
        };
        this.refreshAction.setEnabled(false);
        GameModule.getGameModule().getGameState().addGameComponent(this);
    }

    public Action getRefreshAction() {
        return this.refreshAction;
    }

    public boolean isTestMode() {
        return this.options.contains("TestMode");
    }

    public void start() {
        this.dialog = new RefreshDialog(this);
        this.dialog.setVisible(true);
        this.dialog = null;
    }

    public void log(String message) {
        GameModule.getGameModule().warn(message);
        logger.info(message);
    }

    public List<GamePiece> getCurrentGameRefresherPieces() {
        ArrayList<GamePiece> pieces = new ArrayList<GamePiece>();
        int totalCount = 0;
        int notOwnedCount = 0;
        int notVisibleCount = 0;
        for (GamePiece piece : this.theModule.getGameState().getAllPieces()) {
            Iterator<GamePiece> i;
            if (piece instanceof Deck) {
                i = ((Stack)piece).getPiecesInVisibleOrderIterator();
                while (i.hasNext()) {
                    ++totalCount;
                    pieces.add(0, i.next());
                }
                continue;
            }
            if (piece instanceof Stack) {
                i = ((Stack)piece).getPiecesInVisibleOrderIterator();
                while (i.hasNext()) {
                    GamePiece p = i.next();
                    if (!Boolean.TRUE.equals(p.getProperty("Invisible")) && !Boolean.TRUE.equals(p.getProperty("Obscured"))) {
                        ++totalCount;
                        pieces.add(0, p);
                        continue;
                    }
                    if (Boolean.TRUE.equals(piece.getProperty("Invisible"))) {
                        ++notVisibleCount;
                        continue;
                    }
                    ++notOwnedCount;
                }
                continue;
            }
            if (piece.getParent() != null) continue;
            if (!Boolean.TRUE.equals(piece.getProperty("Invisible")) && !Boolean.TRUE.equals(piece.getProperty("Obscured"))) {
                ++totalCount;
                pieces.add(0, piece);
                continue;
            }
            if (Boolean.TRUE.equals(piece.getProperty("Invisible"))) {
                ++notVisibleCount;
                continue;
            }
            ++notOwnedCount;
        }
        this.log(Resources.getString("GameRefresher.get_all_pieces"));
        this.log(Resources.getString("GameRefresher.counters_total", totalCount));
        this.log(Resources.getString("GameRefresher.counters_kept", totalCount - notOwnedCount - notVisibleCount));
        this.log(Resources.getString("GameRefresher.counters_not_owned", notOwnedCount));
        this.log(Resources.getString("GameRefresher.counters_not_visible", notVisibleCount));
        this.log("-");
        return pieces;
    }

    public void execute(Set<String> options, Command command) throws IllegalBuildException {
        if (command == null) {
            command = new NullCommand();
        }
        if (!options.isEmpty()) {
            this.options.addAll(options);
        }
        this.notFoundCount = 0;
        this.updatedCount = 0;
        if (Objects.isNull(this.gpIdChecker)) {
            this.gpIdChecker = new GpIdChecker(options);
            for (PieceSlot slot : this.theModule.getAllDescendantComponentsOf(PieceSlot.class)) {
                this.gpIdChecker.add(slot);
            }
            for (PrototypesContainer pc : this.theModule.getComponentsOf(PrototypesContainer.class)) {
                pc.getDefinitions().forEach(this.gpIdChecker::add);
            }
            if (this.gpIdChecker.hasErrors()) {
                this.gpIdChecker = null;
                throw new IllegalBuildException("GameRefresher.execute: gpIdChecker has errors");
            }
        }
        List<GamePiece> pieces = this.getCurrentGameRefresherPieces();
        for (GamePiece piece : pieces) {
            this.processGamePiece(piece, command);
        }
        this.log(Resources.getString("GameRefresher.run_refresh_counters_v3", this.theModule.getGameVersion()));
        this.log(Resources.getString("GameRefresher.counters_refreshed", this.updatedCount));
        this.log(Resources.getString("GameRefresher.counters_not_found", this.notFoundCount));
        this.log("----------");
    }

    private void processGamePiece(GamePiece piece, Command command) {
        Map map = piece.getMap();
        if (map == null) {
            this.log("Can't refresh piece " + piece.getName() + "(" + piece.getId() + "): No Map");
            return;
        }
        GamePiece newPiece = this.gpIdChecker.createUpdatedPiece(piece);
        if (newPiece == null) {
            ++this.notFoundCount;
            this.log("Can't refresh piece " + piece.getName() + "(" + piece.getId() + "): Can't find matching Piece Slot");
            return;
        }
        ++this.updatedCount;
        if (this.isTestMode()) {
            RemovePiece remove = new RemovePiece(Decorator.getOutermost(newPiece));
            remove.execute();
            command.append(remove);
        } else {
            int newPos;
            Point pos = piece.getPosition();
            Stack oldStack = piece.getParent();
            int oldPos = oldStack == null ? 0 : oldStack.indexOf(piece);
            Command place = map.placeOrMerge(newPiece, pos);
            command.append(place);
            RemovePiece remove = new RemovePiece(Decorator.getOutermost(piece));
            remove.execute();
            command.append(remove);
            Stack newStack = newPiece.getParent();
            if (newStack != null && newStack == oldStack && (newPos = newStack.indexOf(newPiece)) >= 0 && oldPos >= 0 && newPos != oldPos) {
                String oldState = newStack.getState();
                newStack.insert(newPiece, oldPos);
                command.append(new ChangePiece(newStack.getId(), oldState, newStack.getState()));
            }
        }
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    @Override
    public void setup(boolean gameStarting) {
        this.refreshAction.setEnabled(gameStarting);
    }

    static class RefreshDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private final GameRefresher refresher;
        private JTextArea results;
        private JCheckBox nameCheck;
        private JCheckBox testModeOn;
        private JCheckBox labelerNameCheck;
        private JCheckBox layerNameCheck;
        private final Set<String> options = new HashSet<String>();

        RefreshDialog(GameRefresher refresher) {
            this.refresher = refresher;
            this.setTitle(Resources.getString("GameRefresher.refresh_counters"));
            this.setModal(true);
            this.initComponents();
        }

        protected void initComponents() {
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    this.exit();
                }
            });
            this.setLayout((LayoutManager)new MigLayout("wrap 1", "[center]"));
            JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout());
            JButton runButton = new JButton(Resources.getString("General.run"));
            runButton.addActionListener(e -> this.run());
            JButton exitButton = new JButton(Resources.getString("General.exit"));
            exitButton.addActionListener(e -> this.exit());
            JButton helpButton = new JButton(Resources.getString("General.help"));
            helpButton.addActionListener(e -> this.help());
            buttonPanel.add(runButton);
            buttonPanel.add(exitButton);
            buttonPanel.add(helpButton);
            this.add(buttonPanel);
            this.results = new JTextArea(7, 40);
            this.results.setEditable(false);
            this.add(this.results);
            this.nameCheck = new JCheckBox(Resources.getString("GameRefresher.use_basic_name"));
            this.add(this.nameCheck);
            this.labelerNameCheck = new JCheckBox(Resources.getString("GameRefresher.use_labeler_descr"));
            this.add(this.labelerNameCheck);
            this.layerNameCheck = new JCheckBox(Resources.getString("GameRefresher.use_layer_descr"));
            this.add(this.layerNameCheck);
            this.testModeOn = new JCheckBox(Resources.getString("GameRefresher.test_mode"));
            this.add(this.testModeOn);
            this.pack();
        }

        protected void setOptions() {
            this.options.clear();
            if (this.nameCheck.isSelected()) {
                this.options.add("UseName");
            }
            if (this.labelerNameCheck.isSelected()) {
                this.options.add("UseLabelerName");
            }
            if (this.layerNameCheck.isSelected()) {
                this.options.add("UseLayerName");
            }
            if (this.testModeOn.isSelected()) {
                this.options.add("TestMode");
            }
        }

        protected void exit() {
            this.setVisible(false);
        }

        protected void run() {
            GameModule g = GameModule.getGameModule();
            NullCommand command = new NullCommand();
            String player = GlobalOptions.getInstance().getPlayerId();
            this.setOptions();
            if (this.refresher.isTestMode()) {
                this.refresher.log(Resources.getString("GameRefresher.refresh_counters_test_mode"));
            } else {
                Chatter.DisplayText msg = new Chatter.DisplayText(g.getChatter(), Resources.getString("GameRefresher.run_refresh_counters_v2", player, g.getGameVersion()));
                msg.execute();
                command.append(msg);
            }
            this.refresher.execute(this.options, command);
            g.sendAndLog(command);
            this.exit();
        }

        protected void help() {
            File dir = Documentation.getDocumentationBaseDir();
            dir = new File(dir, "ReferenceManual");
            File theFile = new File(dir, "HelpMenu.html");
            HelpFile h = null;
            try {
                h = new HelpFile(null, theFile, "#HelpFile");
            }
            catch (MalformedURLException e) {
                ErrorDialog.bug(e);
            }
            BrowserSupport.openURL(h.getContents().toString());
        }

        public void addMessage(String mess) {
            this.results.setText(this.results.getText() + "\n" + mess);
        }
    }
}

