/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.BadDataReport;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.Drawable;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.FlareCommand;
import VASSAL.command.NullCommand;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.FlareFormattedStringConfigurer;
import VASSAL.configure.TranslatableStringEnum;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.search.HTMLImageFinder;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.UniqueIdManager;
import VASSAL.tools.swing.SwingUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;

public class Flare
extends AbstractConfigurable
implements CommandEncoder,
GameComponent,
Drawable,
MouseListener,
UniqueIdManager.Identifyable {
    private static final char DELIMITER = '\t';
    public static final String COMMAND_PREFIX = "FLARE\t";
    protected static final UniqueIdManager idMgr = new UniqueIdManager("Flare");
    protected String id = "";
    private int circleSize = 100;
    private boolean circleScale = true;
    private int pulses = 6;
    private int pulsesPerSec = 3;
    private String flareKey = "keyAlt";
    private Color color;
    private FormattedString reportFormat = new FormattedString();
    private Map map;
    private Point clickPoint;
    private boolean animate;
    private volatile boolean active = false;
    public static final String CIRCLE_SIZE = "circleSize";
    public static final String CIRCLE_SCALE = "circleScale";
    public static final String CIRCLE_COLOR = "circleColor";
    public static final String FLARE_KEY = "flareKey";
    public static final String PULSES = "flarePulses";
    public static final String PULSES_PER_SEC = "flarePulsesPerSec";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String NAME = "flareName";
    public static final String FLARE_ALT_LOCAL = Resources.getString("Editor.Flare.flare_key_desc", Resources.getString("Keys.alt"));
    public static final String FLARE_CTRL_LOCAL = Resources.getString("Editor.Flare.flare_key_desc", Resources.getString("Keys.ctrl"));
    public static final String FLARE_COMMAND_LOCAL = Resources.getString("Editor.Flare.flare_key_desc", Resources.getString("Keys.meta"));
    public static final String FLARE_ALT_SHIFT_LOCAL = Resources.getString("Editor.Flare.flare_key_desc", Resources.getString("Keys.alt_shift"));
    public static final String FLARE_SHIFT_COMMAND_LOCAL = Resources.getString("Editor.Flare.flare_key_desc", Resources.getString("Keys.shift_command"));
    public static final String FLARE_CTRL_SHIFT_LOCAL = Resources.getString("Editor.Flare.flare_key_desc", Resources.getString("Keys.ctrl_shift"));
    public static final String FLARE_ALT_COMMAND_LOCAL = Resources.getString("Editor.Flare.flare_key_desc", Resources.getString("Keys.alt_command"));
    public static final String FLARE_CTRL_ALT_LOCAL = Resources.getString("Editor.Flare.flare_key_desc", Resources.getString("Keys.ctrl_alt"));
    public static final String FLARE_ALT_SHIFT_COMMAND_LOCAL = Resources.getString("Editor.Flare.flare_key_desc", Resources.getString("Keys.alt_shift_command"));
    public static final String FLARE_CTRL_ALT_SHIFT_LOCAL = Resources.getString("Editor.Flare.flare_key_desc", Resources.getString("Keys.ctrl_alt_shift"));
    public static final String FLARE_ALT = "keyAlt";
    public static final String FLARE_CTRL = "keyCtrl";
    public static final String FLARE_ALT_SHIFT = "keyAltShift";
    public static final String FLARE_CTRL_SHIFT = "keyCtrlShift";
    public static final String FLARE_CTRL_ALT = "keyCtrlAlt";
    public static final String FLARE_CTRL_ALT_SHIFT = "keyCtrlAltShift";
    public static final String FLARE_NAME = "FlareName";
    public static final String FLARE_LOCATION = "FlareLocation";
    public static final String FLARE_ZONE = "FlareZone";
    public static final String FLARE_MAP = "FlareMap";
    private static final int STROKE = 3;
    private double os_scale = 1.0;
    private volatile float animfrac;
    private final Animator animator = new Animator(0, 1.0, Animator.RepeatBehavior.LOOP, (TimingTarget)new TimingTargetAdapter(){

        public void begin() {
            Flare.this.active = true;
            Flare.this.animfrac = 0.0f;
            Flare.this.repaintArea();
        }

        public void timingEvent(float fraction) {
            Flare.this.animfrac = fraction;
            Flare.this.repaintArea();
        }

        public void end() {
            Flare.this.active = false;
            Flare.this.repaintArea();
        }
    });

    public Flare() {
        this.color = Color.RED;
        this.setConfigureName(Resources.getString("Editor.Flare.desc"));
    }

    public String getDescription() {
        return Resources.getString("Editor.Flare.desc");
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.Flare.configure");
    }

    public Map getMap() {
        return this.map;
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, FlareKeyConfig.class, Integer.class, Color.class, Boolean.class, Integer.class, Integer.class, ReportFormatConfig.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, FLARE_KEY, CIRCLE_SIZE, CIRCLE_COLOR, CIRCLE_SCALE, PULSES, PULSES_PER_SEC, REPORT_FORMAT};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.Flare.flare_key"), Resources.getString("Editor.Flare.circle_size"), Resources.getString("Editor.Flare.circle_color"), Resources.getString("Editor.Flare.circle_scale"), Resources.getString("Editor.Flare.pulses"), Resources.getString("Editor.Flare.pulses_per_sec"), Resources.getString("Editor.report_format")};
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (FLARE_KEY.equals(key)) {
            return this.flareKey;
        }
        if (CIRCLE_SIZE.equals(key)) {
            return String.valueOf(this.circleSize);
        }
        if (CIRCLE_COLOR.equals(key)) {
            return ColorConfigurer.colorToString(this.color);
        }
        if (CIRCLE_SCALE.equals(key)) {
            return String.valueOf(this.circleScale);
        }
        if (PULSES.equals(key)) {
            return String.valueOf(this.pulses);
        }
        if (PULSES_PER_SEC.equals(key)) {
            return String.valueOf(this.pulsesPerSec);
        }
        if (REPORT_FORMAT.equals(key)) {
            return this.reportFormat.getFormat();
        }
        return null;
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)value);
        } else if (FLARE_KEY.equals(key)) {
            this.flareKey = FLARE_ALT_LOCAL.equals(value) ? FLARE_ALT : (FLARE_COMMAND_LOCAL.equals(value) || FLARE_CTRL_LOCAL.equals(value) ? FLARE_CTRL : (FLARE_ALT_SHIFT_LOCAL.equals(value) ? FLARE_ALT_SHIFT : (FLARE_SHIFT_COMMAND_LOCAL.equals(value) || FLARE_CTRL_SHIFT_LOCAL.equals(value) ? FLARE_CTRL_SHIFT : (FLARE_ALT_COMMAND_LOCAL.equals(value) || FLARE_CTRL_ALT_LOCAL.equals(value) ? FLARE_CTRL_ALT : (FLARE_ALT_SHIFT_COMMAND_LOCAL.equals(value) || FLARE_CTRL_ALT_SHIFT_LOCAL.equals(value) ? FLARE_CTRL_ALT_SHIFT : (String)value)))));
        } else if (CIRCLE_SIZE.equals(key)) {
            if (value instanceof String) {
                this.circleSize = Integer.parseInt((String)value);
            } else if (value instanceof Integer) {
                this.circleSize = (Integer)value;
            }
        } else if (CIRCLE_COLOR.equals(key)) {
            if (value instanceof String) {
                value = ColorConfigurer.stringToColor((String)value);
            }
            this.color = (Color)value;
        } else if (CIRCLE_SCALE.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.circleScale = (Boolean)value;
        } else if (PULSES.equals(key)) {
            this.pulses = value instanceof String ? Integer.parseInt((String)value) : (Integer)value;
        } else if (PULSES_PER_SEC.equals(key)) {
            this.pulsesPerSec = value instanceof String ? Integer.parseInt((String)value) : (Integer)value;
        } else if (REPORT_FORMAT.equals(key)) {
            if (value instanceof String) {
                this.reportFormat.setFormat((String)value);
            } else {
                this.reportFormat = (FormattedString)value;
            }
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Flare.htm");
    }

    @Override
    public void addTo(Buildable parent) {
        idMgr.add(this);
        if (parent instanceof Map) {
            this.map = (Map)parent;
            GameModule.getGameModule().addCommandEncoder(this);
            this.map.addDrawComponent(this);
            this.map.addLocalMouseListener(this);
        } else {
            ErrorDialog.dataWarning(new BadDataReport("Flare - can only be added to a Map. ", this.reportFormat.getFormat()));
        }
    }

    @Override
    public void removeFrom(Buildable parent) {
        if (parent instanceof Map) {
            GameModule.getGameModule().removeCommandEncoder(this);
        }
        idMgr.remove(this);
    }

    private void repaintArea() {
        this.map.repaint(new Rectangle((int)((double)this.clickPoint.x - (double)this.circleSize / 2.0 - 6.0 * this.os_scale), (int)((double)this.clickPoint.y - (double)this.circleSize / 2.0 - 6.0 * this.os_scale), (int)((double)this.circleSize + 12.0 * this.os_scale + 0.5), (int)((double)this.circleSize + 12.0 * this.os_scale + 0.5)));
    }

    public void startAnimation(boolean isLocal) {
        if (this.map == null) {
            return;
        }
        if (!isLocal && GlobalOptions.getInstance().centerOnOpponentsMove()) {
            this.map.centerAt(this.clickPoint);
        }
        this.animator.stop();
        this.animate = this.pulses > 0 && this.pulsesPerSec > 0;
        this.animator.setRepeatCount((double)Math.max(this.pulses, 1));
        this.animator.setDuration(1000 / Math.max(this.pulsesPerSec, 1));
        this.animator.start();
    }

    @Override
    public void draw(Graphics g, Map map) {
        if (!this.active || this.clickPoint == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        this.os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
        double diameter = (this.circleScale ? map.getZoom() : 1.0) * this.os_scale * (double)this.circleSize;
        if (this.animate) {
            diameter *= 1.0 - (double)this.animfrac;
        }
        if (diameter <= 0.0) {
            return;
        }
        Point p = map.mapToDrawing(this.clickPoint, this.os_scale);
        g2d.setColor(this.color);
        g2d.setStroke(new BasicStroke((float)(3.0 * this.os_scale)));
        g2d.drawOval((int)((double)p.x - diameter / 2.0), (int)((double)p.y - diameter / 2.0), (int)(diameter + 0.5), (int)(diameter + 0.5));
    }

    @Override
    public boolean drawAboveCounters() {
        return true;
    }

    @Override
    public String encode(Command c) {
        if (c instanceof FlareCommand) {
            SequenceEncoder se = new SequenceEncoder('\t');
            se.append(((FlareCommand)c).getId()).append(((FlareCommand)c).getClickPoint().x).append(((FlareCommand)c).getClickPoint().y);
            return COMMAND_PREFIX + se.getValue();
        }
        return null;
    }

    @Override
    public Command decode(String s) {
        if (s.startsWith(COMMAND_PREFIX + this.getId())) {
            SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, '\t');
            sd.nextToken();
            sd.nextToken();
            int x = sd.nextInt(0);
            int y = sd.nextInt(0);
            this.clickPoint = new Point(x, y);
            return new FlareCommand(this);
        }
        return null;
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!SwingUtils.isMainMouseButtonDown(e)) {
            return;
        }
        if (FLARE_CTRL.equals(this.flareKey) ? !SwingUtils.isSelectionToggle(e) || e.isAltDown() || e.isShiftDown() : (FLARE_ALT.equals(this.flareKey) ? !e.isAltDown() || e.isShiftDown() || SwingUtils.isSelectionToggle(e) : (FLARE_ALT_SHIFT.equals(this.flareKey) ? !e.isAltDown() || !e.isShiftDown() || SwingUtils.isSelectionToggle(e) : (FLARE_CTRL_SHIFT.equals(this.flareKey) ? !e.isShiftDown() || !SwingUtils.isSelectionToggle(e) || e.isAltDown() : (FLARE_CTRL_ALT.equals(this.flareKey) ? !e.isAltDown() || !SwingUtils.isSelectionToggle(e) || e.isShiftDown() : FLARE_CTRL_ALT_SHIFT.equals(this.flareKey) && (!e.isAltDown() || !e.isShiftDown() || !SwingUtils.isSelectionToggle(e))))))) {
            return;
        }
        this.clickPoint = new Point(e.getX(), e.getY());
        GameModule mod = GameModule.getGameModule();
        Command c = new NullCommand();
        this.reportFormat.setProperty(FLARE_NAME, this.getAttributeValueString(NAME));
        this.reportFormat.setProperty(FLARE_LOCATION, this.map.locationName(this.clickPoint));
        Zone z = this.map.findZone(this.clickPoint);
        this.reportFormat.setProperty(FLARE_ZONE, z != null ? z.getName() : "");
        this.reportFormat.setProperty(FLARE_MAP, this.map.getMapName());
        String reportText = this.reportFormat.getLocalizedText(this.map);
        if (!reportText.isBlank()) {
            c = new Chatter.DisplayText(mod.getChatter(), "* " + reportText);
            c.execute();
        }
        c = c.append(new FlareCommand(this));
        mod.sendAndLog(c);
        this.startAnimation(true);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void setup(boolean gameStarting) {
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    public void setClickPoint(Point p) {
        this.clickPoint = p;
    }

    public Point getClickPoint() {
        return this.clickPoint;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<String> getFormattedStringList() {
        return List.of(this.reportFormat.getFormat());
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        HTMLImageFinder h = new HTMLImageFinder(this.reportFormat.getFormat());
        h.addImageNames(s);
    }

    public static class FlareKeyConfig
    extends TranslatableStringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{Flare.FLARE_ALT, Flare.FLARE_CTRL, Flare.FLARE_ALT_SHIFT, Flare.FLARE_CTRL_SHIFT, Flare.FLARE_CTRL_ALT, Flare.FLARE_CTRL_ALT_SHIFT};
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            boolean macLegacy = GlobalOptions.getInstance().getPrefMacLegacy();
            return new String[]{FLARE_ALT_LOCAL, SystemUtils.IS_OS_MAC && !macLegacy ? FLARE_COMMAND_LOCAL : FLARE_CTRL_LOCAL, FLARE_ALT_SHIFT_LOCAL, SystemUtils.IS_OS_MAC && !macLegacy ? FLARE_SHIFT_COMMAND_LOCAL : FLARE_CTRL_SHIFT_LOCAL, SystemUtils.IS_OS_MAC && !macLegacy ? FLARE_ALT_COMMAND_LOCAL : FLARE_CTRL_ALT_LOCAL, SystemUtils.IS_OS_MAC && !macLegacy ? FLARE_ALT_SHIFT_COMMAND_LOCAL : FLARE_CTRL_ALT_SHIFT_LOCAL};
        }

        @Override
        public boolean isDisplayNames() {
            return true;
        }
    }

    public static class ReportFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new FlareFormattedStringConfigurer(key, name, new String[0]);
        }
    }
}

